/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.transport;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipe;
import com.refinedmods.refinedpipes.network.pipe.transport.ItemTransportProps;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallbackFactory;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallbackFactoryRegistry;
import com.refinedmods.refinedpipes.util.DirectionUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemTransport {
    private static final Logger LOGGER = LogManager.getLogger(ItemTransport.class);
    private final ItemStack value;
    private final BlockPos source;
    private final BlockPos destination;
    private final Deque<BlockPos> path;
    private final Direction initialDirection;
    private final TransportCallback finishedCallback;
    private final TransportCallback cancelCallback;
    private final TransportCallback pipeGoneCallback;
    private boolean firstPipe = true;
    private int progressInCurrentPipe;

    public ItemTransport(ItemStack value, BlockPos source, BlockPos destination, Deque<BlockPos> path, TransportCallback finishedCallback, TransportCallback cancelCallback, TransportCallback pipeGoneCallback) {
        this.value = value;
        this.source = source;
        this.destination = destination;
        this.path = path;
        this.initialDirection = ItemTransport.getDirection(source, path.peek());
        this.path.poll();
        this.finishedCallback = finishedCallback;
        this.cancelCallback = cancelCallback;
        this.pipeGoneCallback = pipeGoneCallback;
    }

    public ItemTransport(ItemStack value, BlockPos source, BlockPos destination, Deque<BlockPos> path, Direction initialDirection, TransportCallback finishedCallback, TransportCallback cancelCallback, TransportCallback pipeGoneCallback, boolean firstPipe, int progressInCurrentPipe) {
        this.value = value;
        this.source = source;
        this.destination = destination;
        this.path = path;
        this.initialDirection = initialDirection;
        this.finishedCallback = finishedCallback;
        this.cancelCallback = cancelCallback;
        this.pipeGoneCallback = pipeGoneCallback;
        this.firstPipe = firstPipe;
        this.progressInCurrentPipe = progressInCurrentPipe;
    }

    public ItemStack getValue() {
        return this.value;
    }

    public Direction getDirection(ItemPipe currentPipe) {
        BlockPos nextPipe = this.path.peek();
        if (nextPipe == null) {
            return ItemTransport.getDirection(currentPipe.getPos(), this.destination);
        }
        return ItemTransport.getDirection(currentPipe.getPos(), nextPipe);
    }

    private boolean onDone(Network network, World world, ItemPipe currentPipe) {
        this.finishedCallback.call(network, world, currentPipe.getPos(), this.cancelCallback);
        return true;
    }

    private boolean onPipeGone(Network network, World world, BlockPos posWherePipeIsGone) {
        LOGGER.warn("Pipe on path is gone");
        this.pipeGoneCallback.call(network, world, posWherePipeIsGone, this.cancelCallback);
        return true;
    }

    public boolean update(Network network, ItemPipe currentPipe) {
        ++this.progressInCurrentPipe;
        double progress = (double)this.progressInCurrentPipe / (double)this.getMaxTicksInPipe(currentPipe);
        BlockPos nextPos = currentPipe.getPos().func_177972_a(this.getDirection(currentPipe));
        if (progress > 0.25 && currentPipe.getWorld().func_175623_d(nextPos)) {
            currentPipe.removeTransport(this);
            return this.onPipeGone(network, currentPipe.getWorld(), nextPos);
        }
        if (this.progressInCurrentPipe >= this.getMaxTicksInPipe(currentPipe)) {
            currentPipe.removeTransport(this);
            this.firstPipe = false;
            BlockPos nextPipePos = this.path.poll();
            if (nextPipePos == null) {
                return this.onDone(network, currentPipe.getWorld(), currentPipe);
            }
            Pipe nextPipe = network.getPipe(nextPipePos);
            if (nextPipe == null) {
                return this.onPipeGone(network, currentPipe.getWorld(), nextPipePos);
            }
            this.progressInCurrentPipe = 0;
            ((ItemPipe)nextPipe).addTransport(this);
        }
        return false;
    }

    private boolean isLastPipe() {
        return this.path.isEmpty();
    }

    private static Direction getDirection(BlockPos a, BlockPos b) {
        if (a.func_177972_a(Direction.NORTH).equals((Object)b)) {
            return Direction.NORTH;
        }
        if (a.func_177972_a(Direction.EAST).equals((Object)b)) {
            return Direction.EAST;
        }
        if (a.func_177972_a(Direction.SOUTH).equals((Object)b)) {
            return Direction.SOUTH;
        }
        if (a.func_177972_a(Direction.WEST).equals((Object)b)) {
            return Direction.WEST;
        }
        if (a.func_177972_a(Direction.UP).equals((Object)b)) {
            return Direction.UP;
        }
        if (a.func_177972_a(Direction.DOWN).equals((Object)b)) {
            return Direction.DOWN;
        }
        return Direction.NORTH;
    }

    private int getMaxTicksInPipe(ItemPipe currentPipe) {
        double mt = currentPipe.getMaxTicksInPipe();
        if (this.firstPipe) {
            mt *= 1.25;
        }
        if (this.isLastPipe()) {
            mt *= 0.25;
        }
        return (int)mt;
    }

    public ItemTransportProps createProps(ItemPipe currentPipe) {
        return new ItemTransportProps(this.value, currentPipe.getMaxTicksInPipe(), this.progressInCurrentPipe, this.getDirection(currentPipe), this.initialDirection, this.isLastPipe(), this.firstPipe);
    }

    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_218657_a("v", (INBT)this.value.func_77955_b(new CompoundNBT()));
        tag.func_74772_a("src", this.source.func_218275_a());
        tag.func_74772_a("dst", this.destination.func_218275_a());
        ListNBT path = new ListNBT();
        for (BlockPos pathItem : this.path) {
            path.add((Object)LongNBT.func_229698_a_((long)pathItem.func_218275_a()));
        }
        tag.func_218657_a("pth", (INBT)path);
        tag.func_74768_a("initiald", this.initialDirection.ordinal());
        tag.func_218657_a("fc", (INBT)this.finishedCallback.writeToNbt(new CompoundNBT()));
        tag.func_74778_a("fcid", this.finishedCallback.getId().toString());
        tag.func_218657_a("cc", (INBT)this.cancelCallback.writeToNbt(new CompoundNBT()));
        tag.func_74778_a("ccid", this.cancelCallback.getId().toString());
        tag.func_218657_a("pgc", (INBT)this.pipeGoneCallback.writeToNbt(new CompoundNBT()));
        tag.func_74778_a("pgcid", this.pipeGoneCallback.getId().toString());
        tag.func_74757_a("fp", this.firstPipe);
        tag.func_74768_a("p", this.progressInCurrentPipe);
        return tag;
    }

    @Nullable
    public static ItemTransport of(CompoundNBT tag) {
        ItemStack value = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("v"));
        if (value.func_190926_b()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        BlockPos source = BlockPos.func_218283_e((long)tag.func_74763_f("src"));
        BlockPos destination = BlockPos.func_218283_e((long)tag.func_74763_f("dst"));
        ListNBT pathTag = tag.func_150295_c("pth", 4);
        ArrayDeque<BlockPos> path = new ArrayDeque<BlockPos>();
        for (INBT pathItem : pathTag) {
            path.add(BlockPos.func_218283_e((long)((LongNBT)pathItem).func_150291_c()));
        }
        Direction initialDirection = DirectionUtil.safeGet((byte)tag.func_74762_e("initd"));
        ResourceLocation finishedCallbackId = new ResourceLocation(tag.func_74779_i("fcid"));
        TransportCallbackFactory finishedCallbackFactory = TransportCallbackFactoryRegistry.INSTANCE.getFactory(finishedCallbackId);
        if (finishedCallbackFactory == null) {
            LOGGER.warn("Finished callback factory " + finishedCallbackId + " no longer exists");
            return null;
        }
        TransportCallback finishedCallback = finishedCallbackFactory.create(tag.func_74775_l("fc"));
        if (finishedCallback == null) {
            LOGGER.warn("Finished callback factory " + finishedCallbackId + " returned null!");
            return null;
        }
        ResourceLocation cancelCallbackId = new ResourceLocation(tag.func_74779_i("ccid"));
        TransportCallbackFactory cancelCallbackFactory = TransportCallbackFactoryRegistry.INSTANCE.getFactory(cancelCallbackId);
        if (cancelCallbackFactory == null) {
            LOGGER.warn("Cancel callback factory " + cancelCallbackId + " no longer exists");
            return null;
        }
        TransportCallback cancelCallback = cancelCallbackFactory.create(tag.func_74775_l("cc"));
        if (cancelCallback == null) {
            LOGGER.warn("Cancel callback factory " + cancelCallbackId + " returned null!");
            return null;
        }
        ResourceLocation pipeGoneCallbackId = new ResourceLocation(tag.func_74779_i("pgcid"));
        TransportCallbackFactory pipeGoneCallbackFactory = TransportCallbackFactoryRegistry.INSTANCE.getFactory(pipeGoneCallbackId);
        if (pipeGoneCallbackFactory == null) {
            LOGGER.warn("Pipe gone callback factory " + pipeGoneCallbackId + " no longer exists");
            return null;
        }
        TransportCallback pipeGoneCallback = pipeGoneCallbackFactory.create(tag.func_74775_l("pgc"));
        if (pipeGoneCallback == null) {
            LOGGER.warn("Pipe gone callback factory " + pipeGoneCallbackId + " returned null!");
            return null;
        }
        boolean firstPipe = tag.func_74767_n("fp");
        int progressInCurrentPipe = tag.func_74762_e("p");
        return new ItemTransport(value, source, destination, path, initialDirection, finishedCallback, cancelCallback, pipeGoneCallback, firstPipe, progressInCurrentPipe);
    }
}

