/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedpipes.container.ExtractorAttachmentContainer;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.refinedmods.refinedpipes.screen.BaseScreen;
import com.refinedmods.refinedpipes.screen.widget.IconButton;
import com.refinedmods.refinedpipes.screen.widget.IconButtonPreset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ExtractorAttachmentScreen
extends BaseScreen<ExtractorAttachmentContainer> {
    private static final ResourceLocation RESOURCE = new ResourceLocation("refinedpipes", "textures/gui/extractor_attachment.png");
    private final List<String> tooltip = new ArrayList<String>();
    private Button redstoneModeButton;
    private Button blacklistWhitelistButton;
    @Nullable
    private Button routingModeButton;
    @Nullable
    private Button exactModeButton;
    @Nullable
    private Button plusButton;
    @Nullable
    private Button minusButton;

    public ExtractorAttachmentScreen(ExtractorAttachmentContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_146999_f = 176;
        this.field_147000_g = 193;
    }

    protected void init() {
        super.init();
        this.redstoneModeButton = (Button)this.addButton((Widget)new IconButton(this.field_147003_i + 32, this.field_147009_r + 76, IconButtonPreset.NORMAL, this.getRedstoneModeX(((ExtractorAttachmentContainer)this.field_147002_h).getRedstoneMode()), 61, this.getRedstoneModeText(((ExtractorAttachmentContainer)this.field_147002_h).getRedstoneMode()), btn -> this.setRedstoneMode((IconButton)btn, ((ExtractorAttachmentContainer)this.field_147002_h).getRedstoneMode().next())));
        this.redstoneModeButton.active = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getCanSetRedstoneMode();
        this.blacklistWhitelistButton = (Button)this.addButton((Widget)new IconButton(this.field_147003_i + 55, this.field_147009_r + 76, IconButtonPreset.NORMAL, this.getBlacklistWhitelistX(((ExtractorAttachmentContainer)this.field_147002_h).getBlacklistWhitelist()), 82, this.getBlacklistWhitelistText(((ExtractorAttachmentContainer)this.field_147002_h).getBlacklistWhitelist()), btn -> this.setBlacklistWhitelist((IconButton)btn, ((ExtractorAttachmentContainer)this.field_147002_h).getBlacklistWhitelist().next())));
        this.blacklistWhitelistButton.active = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getCanSetWhitelistBlacklist();
        this.exactModeButton = (Button)this.addButton((Widget)new IconButton(this.field_147003_i + 78, this.field_147009_r + 76, IconButtonPreset.NORMAL, this.getExactModeX(((ExtractorAttachmentContainer)this.field_147002_h).isExactMode()), 103, this.getExactModeText(((ExtractorAttachmentContainer)this.field_147002_h).isExactMode()), btn -> this.setExactMode((IconButton)btn, !((ExtractorAttachmentContainer)this.field_147002_h).isExactMode())));
        this.exactModeButton.active = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getCanSetExactMode();
        if (!((ExtractorAttachmentContainer)this.field_147002_h).isFluidMode()) {
            this.routingModeButton = (Button)this.addButton((Widget)new IconButton(this.field_147003_i + 101, this.field_147009_r + 76, IconButtonPreset.NORMAL, this.getRoutingModeX(((ExtractorAttachmentContainer)this.field_147002_h).getRoutingMode()), 194, this.getRoutingModeText(((ExtractorAttachmentContainer)this.field_147002_h).getRoutingMode()), btn -> this.setRoutingMode((IconButton)btn, ((ExtractorAttachmentContainer)this.field_147002_h).getRoutingMode().next())));
            this.routingModeButton.active = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getCanSetWhitelistBlacklist();
            this.plusButton = (Button)this.addButton((Widget)new IconButton(this.field_147003_i + 125, this.field_147009_r + 76 - 3, IconButtonPreset.SMALL, 198, 19, "+", btn -> this.updateStackSize(1)));
            this.minusButton = (Button)this.addButton((Widget)new IconButton(this.field_147003_i + 125, this.field_147009_r + 76 + 14 - 3, IconButtonPreset.SMALL, 198, 34, "-", btn -> this.updateStackSize(-1)));
            this.minusButton.active = ((ExtractorAttachmentContainer)this.field_147002_h).getStackSize() > 0;
            this.plusButton.active = ((ExtractorAttachmentContainer)this.field_147002_h).getStackSize() < ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getItemsToExtract();
        }
    }

    private void updateStackSize(int amount) {
        int newAmount;
        if (ExtractorAttachmentScreen.hasShiftDown()) {
            amount *= 4;
        }
        if ((newAmount = ((ExtractorAttachmentContainer)this.field_147002_h).getStackSize() + amount) < 0) {
            newAmount = 0;
        }
        if (newAmount > ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getItemsToExtract()) {
            newAmount = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getItemsToExtract();
        }
        this.minusButton.active = newAmount > 0;
        this.plusButton.active = newAmount < ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getItemsToExtract();
        ((ExtractorAttachmentContainer)this.field_147002_h).setStackSize(newAmount);
    }

    private int getRedstoneModeX(RedstoneMode redstoneMode) {
        switch (redstoneMode) {
            case IGNORED: {
                return 219;
            }
            case HIGH: {
                return 177;
            }
            case LOW: {
                return 198;
            }
        }
        return 0;
    }

    private String getRedstoneModeText(RedstoneMode redstoneMode) {
        return I18n.func_135052_a((String)("misc.refinedpipes.redstone_mode." + redstoneMode.toString().toLowerCase()), (Object[])new Object[0]);
    }

    private void setRedstoneMode(IconButton button, RedstoneMode redstoneMode) {
        button.setMessage(this.getRedstoneModeText(redstoneMode));
        button.setOverlayTexX(this.getRedstoneModeX(redstoneMode));
        ((ExtractorAttachmentContainer)this.field_147002_h).setRedstoneMode(redstoneMode);
    }

    private int getBlacklistWhitelistX(BlacklistWhitelist blacklistWhitelist) {
        switch (blacklistWhitelist) {
            case BLACKLIST: {
                return 198;
            }
            case WHITELIST: {
                return 177;
            }
        }
        return 0;
    }

    private String getBlacklistWhitelistText(BlacklistWhitelist blacklistWhitelist) {
        return I18n.func_135052_a((String)("misc.refinedpipes.mode." + blacklistWhitelist.toString().toLowerCase()), (Object[])new Object[0]);
    }

    private void setBlacklistWhitelist(IconButton button, BlacklistWhitelist blacklistWhitelist) {
        button.setMessage(this.getBlacklistWhitelistText(blacklistWhitelist));
        button.setOverlayTexX(this.getBlacklistWhitelistX(blacklistWhitelist));
        ((ExtractorAttachmentContainer)this.field_147002_h).setBlacklistWhitelist(blacklistWhitelist);
    }

    private int getRoutingModeX(RoutingMode routingMode) {
        switch (routingMode) {
            case NEAREST: {
                return 0;
            }
            case FURTHEST: {
                return 21;
            }
            case RANDOM: {
                return 42;
            }
            case ROUND_ROBIN: {
                return 63;
            }
        }
        return 0;
    }

    private String getRoutingModeText(RoutingMode routingMode) {
        return I18n.func_135052_a((String)("misc.refinedpipes.routing_mode." + routingMode.toString().toLowerCase()), (Object[])new Object[0]);
    }

    private void setRoutingMode(IconButton button, RoutingMode routingMode) {
        button.setMessage(this.getRoutingModeText(routingMode));
        button.setOverlayTexX(this.getRoutingModeX(routingMode));
        ((ExtractorAttachmentContainer)this.field_147002_h).setRoutingMode(routingMode);
    }

    private int getExactModeX(boolean exactMode) {
        return exactMode ? 177 : 198;
    }

    private String getExactModeText(boolean exactMode) {
        return I18n.func_135052_a((String)("misc.refinedpipes.exact_mode." + (exactMode ? "on" : "off")), (Object[])new Object[0]);
    }

    private void setExactMode(IconButton button, boolean exactMode) {
        button.setMessage(this.getExactModeText(exactMode));
        button.setOverlayTexX(this.getExactModeX(exactMode));
        ((ExtractorAttachmentContainer)this.field_147002_h).setExactMode(exactMode);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 7.0f, 7.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 7.0f, 99.0f, 0x404040);
        if (!((ExtractorAttachmentContainer)this.field_147002_h).isFluidMode()) {
            this.font.func_211126_b("" + ((ExtractorAttachmentContainer)this.field_147002_h).getStackSize(), 143.0f, 83.0f, 0x404040);
        }
        this.func_191948_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        this.tooltip.clear();
        if (this.blacklistWhitelistButton.isHovered()) {
            this.tooltip.add(I18n.func_135052_a((String)"misc.refinedpipes.mode", (Object[])new Object[0]));
            this.tooltip.add(TextFormatting.GRAY + this.getBlacklistWhitelistText(((ExtractorAttachmentContainer)this.field_147002_h).getBlacklistWhitelist()));
        } else if (this.redstoneModeButton.isHovered()) {
            this.tooltip.add(I18n.func_135052_a((String)"misc.refinedpipes.redstone_mode", (Object[])new Object[0]));
            this.tooltip.add(TextFormatting.GRAY + this.getRedstoneModeText(((ExtractorAttachmentContainer)this.field_147002_h).getRedstoneMode()));
        } else if (this.routingModeButton != null && this.routingModeButton.isHovered()) {
            this.tooltip.add(I18n.func_135052_a((String)"misc.refinedpipes.routing_mode", (Object[])new Object[0]));
            this.tooltip.add(TextFormatting.GRAY + this.getRoutingModeText(((ExtractorAttachmentContainer)this.field_147002_h).getRoutingMode()));
        } else if (this.exactModeButton.isHovered()) {
            this.tooltip.add(I18n.func_135052_a((String)"misc.refinedpipes.exact_mode", (Object[])new Object[0]));
            this.tooltip.add(TextFormatting.GRAY + this.getExactModeText(((ExtractorAttachmentContainer)this.field_147002_h).isExactMode()));
        }
        if (!this.tooltip.isEmpty()) {
            GuiUtils.drawHoveringText(this.tooltip, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r), (int)this.width, (int)this.height, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(RESOURCE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int x = 43;
        int y = 18;
        for (int filterSlotId = 1; filterSlotId <= 15; ++filterSlotId) {
            if (filterSlotId > ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getFilterSlots()) {
                this.blit(i + x, j + y, 198, 0, 18, 18);
            }
            if (filterSlotId % 5 == 0) {
                x = 43;
                y += 18;
                continue;
            }
            x += 18;
        }
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }
}

