/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.util;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class Raytracer {
    public static Pair<Vec3d, Vec3d> getVectors(Entity entity) {
        float pitch = entity.field_70125_A;
        float yaw = entity.field_70177_z;
        Vec3d start = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        float f1 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = f2 * f3;
        float f6 = f1 * f3;
        double d3 = 5.0;
        if (entity instanceof ServerPlayerEntity) {
            d3 = ((ServerPlayerEntity)entity).func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        }
        Vec3d end = start.func_72441_c((double)f5 * d3, (double)f4 * d3, (double)f6 * d3);
        return Pair.of((Object)start, (Object)end);
    }

    public static AdvancedRayTraceResult<BlockRayTraceResult> collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, Collection<AxisAlignedBB> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult<BlockRayTraceResult> hit = null;
        int i = -1;
        for (AxisAlignedBB aabb : boxes) {
            double d;
            AdvancedRayTraceResult<BlockRayTraceResult> result;
            AdvancedRayTraceResult<BlockRayTraceResult> advancedRayTraceResult = result = aabb == null ? null : Raytracer.collisionRayTrace(pos, start, end, aabb, i, null);
            if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = result;
            }
            ++i;
        }
        return hit;
    }

    public static AdvancedRayTraceResult<BlockRayTraceResult> collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB bounds, int subHit, Object hitInfo) {
        BlockRayTraceResult result = AxisAlignedBB.func_197743_a(Collections.singleton(bounds), (Vec3d)start, (Vec3d)end, (BlockPos)pos);
        if (result == null) {
            return null;
        }
        result.subHit = subHit;
        result.hitInfo = hitInfo;
        return new AdvancedRayTraceResult<BlockRayTraceResult>(result, bounds);
    }

    public static boolean inclusiveContains(AxisAlignedBB aabb, Vec3d hit) {
        return hit.field_72450_a >= aabb.field_72340_a && hit.field_72450_a <= aabb.field_72336_d && hit.field_72448_b >= aabb.field_72338_b && hit.field_72448_b <= aabb.field_72337_e && hit.field_72449_c >= aabb.field_72339_c && hit.field_72449_c <= aabb.field_72334_f;
    }

    public static class AdvancedRayTraceResult<T extends RayTraceResult> {
        public final AxisAlignedBB bounds;
        public final T hit;

        public AdvancedRayTraceResult(T mop, AxisAlignedBB aabb) {
            this.hit = mop;
            this.bounds = aabb;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vec3d vec) {
            return this.hit.func_216347_e().func_72436_e(vec);
        }
    }
}

