/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world;

import com.mojang.datafixers.Dynamic;
import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.init.BMFeature;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftFeatureConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.VerticalEntrance;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

@MethodsReturnNonnullByDefault
public class BetterMineshaftStructure
extends Structure<BetterMineshaftFeatureConfig> {
    public BetterMineshaftStructure(Function<Dynamic<?>, ? extends BetterMineshaftFeatureConfig> configFactory) {
        super(configFactory);
    }

    @ParametersAreNonnullByDefault
    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGenerator, Random random, int chunkX, int chunkZ, Biome biome) {
        ((SharedSeedRandom)random).func_202425_c(chunkGenerator.func_202089_c(), chunkX, chunkZ);
        if (chunkGenerator.func_202094_a(biome, (Structure)this)) {
            BetterMineshaftFeatureConfig featureConfig = (BetterMineshaftFeatureConfig)chunkGenerator.func_202087_b(biome, (Structure)this);
            if (featureConfig == null) {
                featureConfig = new BetterMineshaftFeatureConfig(BMConfig.mineshaftSpawnRate, Type.NORMAL);
            }
            return random.nextDouble() < featureConfig.probability;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "Mineshaft";
    }

    public int func_202367_b() {
        return 12;
    }

    public static enum Type {
        NORMAL("normal"),
        MESA("mesa"),
        JUNGLE("jungle"),
        SNOW("snow"),
        ICE("ice"),
        DESERT("desert"),
        RED_DESERT("red_desert"),
        SAVANNA("savanna"),
        MUSHROOM("mushroom");

        private final String name;
        private static final Map<String, Type> nameMap;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type byName(String name) {
            return nameMap.get(name);
        }

        public static Type byIndex(int index) {
            return index >= 0 && index < Type.values().length ? Type.values()[index] : NORMAL;
        }

        static {
            nameMap = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, type -> type));
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureFeature, int chunkX, int chunkZ, MutableBoundingBox blockBox, int i, long l) {
            super(structureFeature, chunkX, chunkZ, blockBox, i, l);
        }

        @ParametersAreNonnullByDefault
        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome) {
            BetterMineshaftFeatureConfig featureConfig = (BetterMineshaftFeatureConfig)chunkGenerator.func_202087_b(biome, BMFeature.betterMineshaft);
            if (featureConfig == null) {
                featureConfig = new BetterMineshaftFeatureConfig(0.003, Type.NORMAL);
            }
            Direction direction = Direction.NORTH;
            SharedSeedRandom rand = new SharedSeedRandom();
            rand.func_202422_a(chunkX, chunkZ);
            int r = rand.nextInt(4);
            switch (r) {
                case 0: {
                    direction = Direction.NORTH;
                    break;
                }
                case 1: {
                    direction = Direction.SOUTH;
                    break;
                }
                case 2: {
                    direction = Direction.EAST;
                    break;
                }
                case 3: {
                    direction = Direction.WEST;
                }
            }
            int y = this.field_214631_d.nextInt(BMConfig.maxY - BMConfig.minY + 1) + BMConfig.minY;
            BlockPos.Mutable startingPos = new BlockPos.Mutable((chunkX << 4) + 2, y, (chunkZ << 4) + 2);
            VerticalEntrance entryPoint = new VerticalEntrance(0, -1, (Random)this.field_214631_d, startingPos, direction, featureConfig.type);
            this.field_75075_a.add(entryPoint);
            ((MineshaftPiece)entryPoint).func_74861_a(entryPoint, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

