/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.client.renderer.entity;

import com.markus1002.autumnity.client.renderer.entity.model.SnailModel;
import com.markus1002.autumnity.common.entity.passive.SnailEntity;
import com.markus1002.autumnity.core.util.Reference;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailRenderer
extends MobRenderer<SnailEntity, SnailModel<SnailEntity>> {
    private static final ResourceLocation SNAIL_TEXTURES = Reference.location("textures/entity/snail/snail.png");
    private static final ResourceLocation SNAKE_SNAIL_TEXTURES = Reference.location("textures/entity/snail/snake_snail.png");
    private static final ResourceLocation NAUTILUS_SNAIL_TEXTURES = Reference.location("textures/entity/snail/nautilus_snail.png");

    public SnailRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new SnailModel(), 0.5f);
    }

    public ResourceLocation getEntityTexture(SnailEntity entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_200200_C_().getString().toLowerCase());
        if (s != null) {
            if ("snake".equals(s) || "snake snail".equals(s) || "snakeblock".equals(s) || "snake block".equals(s)) {
                return SNAKE_SNAIL_TEXTURES;
            }
            if ("nautilus".equals(s) || "nautilus snail".equals(s)) {
                return NAUTILUS_SNAIL_TEXTURES;
            }
        }
        return SNAIL_TEXTURES;
    }

    protected void applyRotations(SnailEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        if (!((double)entityLiving.field_70721_aZ < 0.01)) {
            double d0 = entityLiving.getShakingAnimationScale(partialTicks);
            double d1 = entityLiving.getShakeTicks() > 0.0f ? 1.0 : -1.0;
            double d2 = Math.sin(6.3 * d0) * d1 * d0;
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(6.0f * (float)d2));
        }
    }
}

