/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.core.util;

import com.markus1002.autumnity.common.entity.passive.SnailEntity;
import com.markus1002.autumnity.core.registry.ModBiomes;
import com.markus1002.autumnity.core.registry.ModBlocks;
import com.markus1002.autumnity.core.registry.ModEffects;
import com.markus1002.autumnity.core.registry.ModItems;
import com.teamabnormals.abnormals_core.core.utils.TradeUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventHandler {
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(UUID.fromString("98D5CD1F-601F-47E6-BEEC-5997E1C4216F"), "Knockback modifier", 1.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public void onEffectRemap(RegistryEvent.MissingMappings<Effect> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (mapping.key.toString() != "autumnity:anti_healing") continue;
            mapping.remap((IForgeRegistryEntry)ModEffects.LIFE_STASIS);
            break;
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            Entity entity = event.getEntity();
            if (entity instanceof PillagerEntity) {
                ((PillagerEntity)entity).field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreatureEntity)entity), SnailEntity.class, true));
            } else if (entity instanceof MooshroomEntity) {
                ((MooshroomEntity)entity).field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)entity, SnailEntity.class, 16.0f, 1.25, 1.6, EntityPredicates.field_188444_d::test));
            }
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        LivingEntity livingentity = event.getEntityLiving();
        if ((livingentity instanceof ZombieEntity || livingentity instanceof AbstractSkeletonEntity) && livingentity.func_184582_a(EquipmentSlotType.HEAD).func_190926_b() && event.getWorld().func_226691_t_(new BlockPos((Entity)livingentity)) == ModBiomes.PUMPKIN_FIELDS.get() && event.getWorld().func_201674_k().nextFloat() < 0.05f) {
            livingentity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Blocks.field_196625_cS));
            ((MobEntity)livingentity).func_184642_a(EquipmentSlotType.HEAD, 0.0f);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(KNOCKBACK_MODIFIER);
        if (entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == ModItems.SNAIL_SHELL_CHESTPLATE.get() && entity.func_225608_bj_()) {
            entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(KNOCKBACK_MODIFIER);
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        if (event.getEntityLiving().func_70644_a(ModEffects.LIFE_STASIS)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWandererTradesEvent(WandererTradesEvent event) {
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade(((Block)ModBlocks.MAPLE_SAPLING.get()).func_199767_j(), 5, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade(((Block)ModBlocks.YELLOW_MAPLE_SAPLING.get()).func_199767_j(), 5, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade(((Block)ModBlocks.ORANGE_MAPLE_SAPLING.get()).func_199767_j(), 5, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade(((Block)ModBlocks.RED_MAPLE_SAPLING.get()).func_199767_j(), 5, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade(((Block)ModBlocks.SNAIL_SLIME.get()).func_199767_j(), 4, 1, 5, 1));
    }

    @SubscribeEvent
    public void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.field_221156_f) {
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Item)ModItems.FOUL_BERRIES.get(), 2, 16, 12, 10));
        }
    }
}

