/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class MineralMixBuilder
extends IEFinishedRecipe<MineralMixBuilder> {
    JsonArray oresArray = new JsonArray();
    JsonArray dimensionsArray = new JsonArray();

    private MineralMixBuilder() {
        super((IERecipeSerializer)MineralMix.SERIALIZER.get());
        this.addWriter(jsonObject -> jsonObject.add("ores", (JsonElement)this.oresArray));
        this.addWriter(jsonObject -> jsonObject.add("dimensions", (JsonElement)this.dimensionsArray));
    }

    public static MineralMixBuilder builder(DimensionType dimension) {
        return new MineralMixBuilder().addDimension(dimension);
    }

    public static MineralMixBuilder builder(ResourceLocation dimension) {
        return new MineralMixBuilder().addDimension(dimension);
    }

    public MineralMixBuilder setWeight(int weight) {
        return (MineralMixBuilder)this.addWriter(jsonObject -> jsonObject.addProperty("weight", (Number)weight));
    }

    public MineralMixBuilder setFailchance(float failChance) {
        return (MineralMixBuilder)this.addWriter(jsonObject -> jsonObject.addProperty("fail_chance", (Number)Float.valueOf(failChance)));
    }

    public MineralMixBuilder setBackground(ResourceLocation resourceLocation) {
        return (MineralMixBuilder)this.addWriter(jsonObject -> jsonObject.addProperty("sample_background", resourceLocation.toString()));
    }

    public MineralMixBuilder addDimension(DimensionType dimension) {
        return this.addDimension(DimensionType.func_212678_a((DimensionType)dimension));
    }

    public MineralMixBuilder addDimension(ResourceLocation dimension) {
        this.dimensionsArray.add((JsonElement)new JsonPrimitive(dimension.toString()));
        return this;
    }

    public MineralMixBuilder addOre(IItemProvider itemProvider, float chance) {
        return this.addOre(new ItemStack(itemProvider), chance);
    }

    public MineralMixBuilder addOre(ItemStack itemStack, float chance) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("chance", (Number)Float.valueOf(chance));
        jsonObject.add("output", (JsonElement)this.serializeItemStack(itemStack));
        this.oresArray.add((JsonElement)jsonObject);
        return this;
    }

    public MineralMixBuilder addOre(Tag<Item> tag, float chance) {
        return this.addOre(new IngredientWithSize(tag), chance, null);
    }

    public MineralMixBuilder addOre(Tag<Item> tag, float chance, ICondition condition) {
        return this.addOre(new IngredientWithSize(tag), chance, condition);
    }

    public MineralMixBuilder addOre(IngredientWithSize ingredient, float chance, ICondition condition) {
        JsonObject jsonObject = new JsonObject();
        if (condition != null) {
            JsonArray array = new JsonArray();
            array.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            jsonObject.add("conditions", (JsonElement)array);
        }
        jsonObject.addProperty("chance", (Number)Float.valueOf(chance));
        jsonObject.add("output", ingredient.serialize());
        this.oresArray.add((JsonElement)jsonObject);
        return this;
    }
}

