/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.utils.CombinedModelData;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ImmersiveConnectableTileEntity
extends IEBaseTileEntity
implements IImmersiveConnectable {
    protected GlobalWireNetwork globalNet;
    private static Map<BlockPos, Queue<Pair<LoadUnloadEvent, ImmersiveConnectableTileEntity>>> queuedEvents = new HashMap<BlockPos, Queue<Pair<LoadUnloadEvent, ImmersiveConnectableTileEntity>>>();
    private final Int2ObjectMap<LocalWireNetwork> cachedLocalNets = new Int2ObjectArrayMap();

    public ImmersiveConnectableTileEntity(TileEntityType<? extends ImmersiveConnectableTileEntity> type) {
        super(type);
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v();
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Override
    public void func_226984_a_(World worldIn, BlockPos pos) {
        super.func_226984_a_(worldIn, pos);
        this.globalNet = GlobalWireNetwork.getNetwork(worldIn);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == -1 || id == 255) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        if (id == 254) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        return new ConnectionPoint(this.field_174879_c, 0);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
    }

    public IEProperties.ConnectionModelData genConnBlockstate() {
        HashSet<Connection> ret = new HashSet<Connection>();
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            LocalWireNetwork local = this.globalNet.getLocalNet(cp);
            Collection<Connection> conns = local.getConnections(cp);
            if (conns == null) {
                WireLogger.logger.warn("Aborting and returning empty data: null connections at {}", (Object)cp);
                return new IEProperties.ConnectionModelData((Set<Connection>)ImmutableSet.of(), this.field_174879_c);
            }
            for (Connection c : conns) {
                IImmersiveConnectable otherConnector;
                ConnectionPoint other = c.getOtherEnd(cp);
                if (c.isInternal() || (otherConnector = this.globalNet.getLocalNet(other).getConnector(other)) == null || otherConnector.isProxy()) continue;
                c.generateCatenaryData(this.field_145850_b);
                ret.add(c);
            }
        }
        return new IEProperties.ConnectionModelData(ret, this.field_174879_c);
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new CombinedModelData(new SinglePropertyModelData<IEProperties.ConnectionModelData>(this.genConnBlockstate(), IEProperties.Model.CONNECTIONS), super.getModelData());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.queueEvent(LoadUnloadEvent.UNLOAD);
    }

    public void onLoad() {
        super.onLoad();
        this.queueEvent(LoadUnloadEvent.LOAD);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.queueEvent(LoadUnloadEvent.REMOVE);
    }

    private void queueEvent(LoadUnloadEvent ev) {
        if (this.field_145850_b != null) {
            if (!this.getWorldNonnull().field_72995_K) {
                ev.run(this);
            } else {
                Queue<Pair<LoadUnloadEvent, ImmersiveConnectableTileEntity>> queue = queuedEvents.get(this.field_174879_c);
                if (queue == null) {
                    ApiUtils.addFutureServerTask(this.getWorldNonnull(), () -> ImmersiveConnectableTileEntity.processEvents(this.field_174879_c), true);
                    queue = new ArrayDeque<Pair<LoadUnloadEvent, ImmersiveConnectableTileEntity>>();
                    queuedEvents.put(this.field_174879_c, queue);
                }
                queue.add((Pair<LoadUnloadEvent, ImmersiveConnectableTileEntity>)Pair.of((Object)((Object)ev), (Object)this));
                WireLogger.logger.info("Queuing {} at {} (tile {})", (Object)ev, (Object)this.func_174877_v(), (Object)this);
            }
        }
    }

    private static void processEvents(BlockPos pos) {
        ImmersiveConnectableTileEntity toUnload = null;
        ArrayList<Object> loadedInTick = new ArrayList<Object>();
        Queue<Pair<LoadUnloadEvent, ImmersiveConnectableTileEntity>> events = queuedEvents.get(pos);
        for (Pair pair : events) {
            switch ((LoadUnloadEvent)((Object)pair.getLeft())) {
                case LOAD: {
                    loadedInTick.add(pair.getRight());
                    break;
                }
                case UNLOAD: 
                case REMOVE: {
                    boolean wasNew = loadedInTick.remove(pair.getRight());
                    if (wasNew) break;
                    Preconditions.checkState((toUnload == null ? 1 : 0) != 0, (String)"Unloading two IICs at %s in the same tick: %s and %s, events %s", (Object)pair.getRight(), toUnload, events);
                    toUnload = (ImmersiveConnectableTileEntity)pair.getRight();
                }
            }
        }
        Preconditions.checkState((loadedInTick.size() < 2 ? 1 : 0) != 0, (String)"Too many IICs loaded at %s in one tick: %s, queue is %s", loadedInTick, events);
        if (toUnload != null) {
            if (!loadedInTick.isEmpty()) {
                LoadUnloadEvent.UNLOAD.run(toUnload);
            } else {
                LoadUnloadEvent.REMOVE.run(toUnload);
            }
        }
        if (!loadedInTick.isEmpty()) {
            LoadUnloadEvent.LOAD.run((ImmersiveConnectableTileEntity)loadedInTick.get(0));
        }
        queuedEvents.remove(pos);
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.field_174879_c, 0));
    }

    protected LocalWireNetwork getLocalNet(int cpIndex) {
        LocalWireNetwork ret = (LocalWireNetwork)this.cachedLocalNets.get(cpIndex);
        ConnectionPoint cp = new ConnectionPoint(this.func_174877_v(), cpIndex);
        if (ret == null || !ret.isValid(cp)) {
            ret = this.globalNet.getLocalNet(cp);
            this.cachedLocalNets.put(cpIndex, (Object)ret);
        }
        return ret;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    private static enum LoadUnloadEvent {
        LOAD(te -> te.globalNet.onConnectorLoad((IImmersiveConnectable)te, te.func_145831_w())),
        UNLOAD(te -> te.globalNet.onConnectorUnload(te.func_174877_v(), (IImmersiveConnectable)te)),
        REMOVE(te -> te.globalNet.removeConnector((IImmersiveConnectable)te));

        private final Consumer<ImmersiveConnectableTileEntity> run;

        private LoadUnloadEvent(Consumer<ImmersiveConnectableTileEntity> run) {
            this.run = run;
        }

        public void run(ImmersiveConnectableTileEntity tile) {
            WireLogger.logger.info("Running {} at {} (tile {})", (Object)this.name(), (Object)tile.func_174877_v(), (Object)tile);
            this.run.accept(tile);
        }

        public String toString() {
            return this.name();
        }
    }
}

