/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.font;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.EmptyGlyph;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IEFontRender
extends FontRenderer {
    private static final HashMap<Character, TexturedGlyph> unicodeReplacements = new HashMap();
    private static final ResourceLocation UNICODE = new ResourceLocation("immersiveengineering", "unicode");
    private static final ResourceLocation NORMAL = Minecraft.field_211502_b;
    public float customSpaceWidth = 4.0f;
    public boolean verticalBoldness = false;
    protected final TextureManager texManager;
    private final boolean unicode;

    public IEFontRender(boolean unicode, ResourceLocation id) {
        super(ClientUtils.mc().field_71446_o, new Font(ClientUtils.mc().field_71446_o, id));
        this.texManager = ClientUtils.mc().field_71446_o;
        this.unicode = unicode;
    }

    public ResourceLocation getBaseID() {
        return this.unicode ? UNICODE : NORMAL;
    }

    public float func_228081_c_(String text, float x, float y, int color, boolean isShadow, Matrix4f matrix, IRenderTypeBuffer buffer, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        float ret = this.renderStringAtPosImpl(text, x, y, color, isShadow, matrix, buffer, isTransparent, colorBackgroundIn, packedLight);
        if (this.verticalBoldness) {
            float yOffset = this.unicode ? 0.5f : 1.0f;
            this.renderStringAtPosImpl(text, x, y + yOffset, color, isShadow, matrix, buffer, isTransparent, colorBackgroundIn, packedLight);
        }
        return ret;
    }

    private float renderStringAtPosImpl(String text, float x, float y, int color, boolean isShadow, Matrix4f matrix, IRenderTypeBuffer buffer, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        float colorScale = isShadow ? 0.25f : 1.0f;
        float argRed = (float)(color >> 16 & 0xFF) / 255.0f * colorScale;
        float argGreen = (float)(color >> 8 & 0xFF) / 255.0f * colorScale;
        float argBlue = (float)(color & 0xFF) / 255.0f * colorScale;
        float currentRed = argRed;
        float currentGreen = argGreen;
        float currentBlue = argBlue;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        boolean obfuscated = false;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean strikethrough = false;
        ArrayList lineSegments = Lists.newArrayList();
        int resetColorAt = -1;
        FloatArrayList charPositions = new FloatArrayList(text.length());
        for (int i = 0; i < text.length(); ++i) {
            float lineShadowOffset;
            char currentChar = text.charAt(i);
            if (currentChar == '\u00a7' && i + 1 < text.length()) {
                TextFormatting newFormatting = TextFormatting.func_211165_a((char)text.charAt(i + 1));
                if (newFormatting != null) {
                    if (newFormatting.func_211166_f()) {
                        obfuscated = false;
                        bold = false;
                        strikethrough = false;
                        underline = false;
                        italic = false;
                        currentRed = argRed;
                        currentGreen = argGreen;
                        currentBlue = argBlue;
                    }
                    if (newFormatting.func_211163_e() != null) {
                        int j = newFormatting.func_211163_e();
                        currentRed = (float)(j >> 16 & 0xFF) / 255.0f * colorScale;
                        currentGreen = (float)(j >> 8 & 0xFF) / 255.0f * colorScale;
                        currentBlue = (float)(j & 0xFF) / 255.0f * colorScale;
                    } else if (newFormatting == TextFormatting.OBFUSCATED) {
                        obfuscated = true;
                    } else if (newFormatting == TextFormatting.BOLD) {
                        bold = true;
                    } else if (newFormatting == TextFormatting.STRIKETHROUGH) {
                        strikethrough = true;
                    } else if (newFormatting == TextFormatting.UNDERLINE) {
                        underline = true;
                    } else if (newFormatting == TextFormatting.ITALIC) {
                        italic = true;
                    }
                }
                ++i;
                continue;
            }
            if (text.substring(i).startsWith("<hexcol=")) {
                int end = text.indexOf(">", i);
                String s = text.substring(i, end + 1);
                int formatEnd = s.indexOf(":");
                if (formatEnd < 0) continue;
                String hex = s.substring("<hexcol=".length(), formatEnd);
                int hexColour = Integer.parseInt(hex, 16);
                resetColorAt = end;
                currentRed = (float)(hexColour >> 16 & 0xFF) / 255.0f * colorScale;
                currentGreen = (float)(hexColour >> 8 & 0xFF) / 255.0f * colorScale;
                currentBlue = (float)(hexColour & 0xFF) / 255.0f * colorScale;
                i += formatEnd;
                continue;
            }
            if (i == resetColorAt) {
                currentRed = argRed;
                currentGreen = argGreen;
                currentBlue = argBlue;
                continue;
            }
            IGlyph currentGlyph = this.field_211127_e.func_211184_b(currentChar);
            TexturedGlyph texturedglyph = obfuscated && currentChar != ' ' ? this.field_211127_e.func_211188_a(currentGlyph) : this.field_211127_e.func_211187_a(currentChar);
            TexturedGlyph replacement = unicodeReplacements.get(Character.valueOf(currentChar));
            if (replacement != null) {
                texturedglyph = replacement;
            }
            if (!(texturedglyph instanceof EmptyGlyph)) {
                float boldOffset = bold ? currentGlyph.func_223275_b_() : 0.0f;
                float shadowOffset = isShadow ? currentGlyph.func_223276_c_() : 0.0f;
                IVertexBuilder typeBuffer = buffer.getBuffer(texturedglyph.func_228163_a_(isTransparent));
                this.renderGlyph(currentChar, texturedglyph, bold, italic, boldOffset, x + shadowOffset, y + shadowOffset, matrix, typeBuffer, currentRed, currentGreen, currentBlue, alpha, packedLight);
            }
            float advance = this.getCharWidthIE(currentChar, bold);
            float f = lineShadowOffset = isShadow ? 1.0f : 0.0f;
            if (strikethrough) {
                lineSegments.add(new TexturedGlyph.Effect(x + lineShadowOffset - 1.0f, y + lineShadowOffset + 4.5f, x + lineShadowOffset + advance, y + lineShadowOffset + 4.5f - 1.0f, -0.01f, currentRed, currentGreen, currentBlue, alpha));
            }
            if (underline) {
                lineSegments.add(new TexturedGlyph.Effect(x + lineShadowOffset - 1.0f, y + lineShadowOffset + 9.0f, x + lineShadowOffset + advance, y + lineShadowOffset + 9.0f - 1.0f, -0.01f, currentRed, currentGreen, currentBlue, alpha));
            }
            charPositions.add(x);
            x += advance;
        }
        if (!lineSegments.isEmpty()) {
            TexturedGlyph texturedglyph1 = this.field_211127_e.func_228157_b_();
            IVertexBuilder ivertexbuilder1 = buffer.getBuffer(texturedglyph1.func_228163_a_(isTransparent));
            for (TexturedGlyph.Effect texturedglyph$effect : lineSegments) {
                texturedglyph1.func_228162_a_(texturedglyph$effect, matrix, ivertexbuilder1, packedLight);
            }
        }
        this.postStringRender(text, (FloatList)charPositions, buffer, matrix, y);
        return x;
    }

    protected void postStringRender(String text, FloatList charPositions, IRenderTypeBuffer buffer, Matrix4f baseTransform, float y) {
    }

    protected void renderGlyph(char orig, TexturedGlyph glyphIn, boolean boldIn, boolean italicIn, float boldOffsetIn, float xIn, float yIn, Matrix4f matrix, IVertexBuilder bufferIn, float redIn, float greenIn, float blueIn, float alphaIn, int packedLight) {
        glyphIn.func_225595_a_(italicIn, xIn, yIn, matrix, bufferIn, redIn, greenIn, blueIn, alphaIn, packedLight);
        if (boldIn) {
            glyphIn.func_225595_a_(italicIn, xIn + boldOffsetIn, yIn, matrix, bufferIn, redIn, greenIn, blueIn, alphaIn, packedLight);
        }
    }

    public float getCharWidthIE(char character, boolean bold) {
        if (character == ' ') {
            return this.customSpaceWidth;
        }
        return character == '\u00a7' ? 0.0f : this.field_211127_e.func_211184_b(character).func_223274_a_(bold);
    }

    public float func_211125_a(char character) {
        return this.getCharWidthIE(character, false);
    }

    public int func_78256_a(String text) {
        if (text == null) {
            return 0;
        }
        float length = 0.0f;
        boolean bold = false;
        for (int i = 0; i < text.length(); ++i) {
            if (text.substring(i).startsWith("<hexcol=")) {
                int end = text.indexOf(">", i);
                String s = text.substring(i, end + 1);
                int formatEnd = s.indexOf(":");
                if (formatEnd < 0) continue;
                i += formatEnd;
                continue;
            }
            char currentChar = text.charAt(i);
            if (currentChar == '\u00a7' && i < text.length() - 1) {
                TextFormatting textformatting;
                if ((textformatting = TextFormatting.func_211165_a((char)text.charAt(++i))) == TextFormatting.BOLD) {
                    bold = true;
                    continue;
                }
                if (textformatting == null || !textformatting.func_211166_f()) continue;
                bold = false;
                continue;
            }
            length += this.getCharWidthIE(currentChar, bold);
        }
        return MathHelper.func_76123_f((float)length);
    }

    public int func_78259_e(String str, int wrapWidth) {
        int currIndex;
        int strLength = str.length();
        float currentWidth = 0.0f;
        boolean bold = false;
        int lastSpace = -1;
        for (currIndex = 0; currIndex < strLength; ++currIndex) {
            char currentChar = str.charAt(currIndex);
            switch (currentChar) {
                case '\n': {
                    --currIndex;
                    break;
                }
                case ' ': {
                    lastSpace = currIndex;
                }
                default: {
                    currentWidth += this.getCharWidthIE(currentChar, bold);
                    break;
                }
                case '\u00a7': {
                    TextFormatting textformatting;
                    if (currIndex >= strLength - 1) break;
                    if ((textformatting = TextFormatting.func_211165_a((char)str.charAt(++currIndex))) == TextFormatting.BOLD) {
                        bold = true;
                        break;
                    }
                    if (textformatting == null || !textformatting.func_211166_f()) break;
                    bold = false;
                }
            }
            if (currentChar == '\n') {
                lastSpace = ++currIndex;
                break;
            }
            if (currentWidth > (float)wrapWidth) break;
        }
        return currIndex != strLength && lastSpace != -1 && lastSpace < currIndex ? lastSpace : currIndex;
    }

    public int getFontHeight() {
        return 9;
    }

    public int func_78267_b(String str, int maxLength) {
        return this.getFontHeight() * this.func_78271_c(str, maxLength).size();
    }

    static {
        unicodeReplacements.put(Character.valueOf((char)Integer.parseInt("260E", 16)), new TexturedGlyph(RenderType.func_228658_l_((ResourceLocation)new ResourceLocation("immersiveengineering", "textures/gui/hud_elements.png")), RenderType.func_228660_m_((ResourceLocation)new ResourceLocation("immersiveengineering", "textures/gui/hud_elements.png")), 0.5f, 0.75f, 0.5625f, 0.8125f, 0.0f, 7.99f, 0.0f, 7.99f));
    }
}

