/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.fx.IEParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class FluidSplashParticle
extends SpriteTexturedParticle {
    public FluidSplashParticle(Fluid fluid, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.field_187129_i *= 0.3;
        this.field_187130_j = Math.random() * 0.2 + 0.1;
        this.field_187131_k *= 0.3;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.func_187115_a(0.01f, 0.01f);
        this.field_70545_g = 0.06f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.field_70544_f = 0.375f;
        this.setFluidTexture(new FluidStack(fluid, 1000));
    }

    public void func_189213_a() {
        BlockPos blockpos;
        BlockState iblockstate;
        Material material;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_187130_j -= (double)this.field_70545_g;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.98;
        this.field_187130_j *= 0.98;
        this.field_187131_k *= 0.98;
        if (this.field_70547_e-- <= 0) {
            this.func_187112_i();
        }
        if (this.field_187132_l) {
            if (Math.random() < 0.5) {
                this.func_187112_i();
            }
            this.field_187129_i *= 0.7;
            this.field_187131_k *= 0.7;
        }
        if ((material = (iblockstate = this.field_187122_b.func_180495_p(blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h))).func_185904_a()).func_76224_d() || material.func_76220_a()) {
            double d0 = iblockstate.func_196954_c((IBlockReader)this.field_187122_b, blockpos).func_197758_c(Direction.Axis.Y);
            double d1 = (double)MathHelper.func_76128_c((double)this.field_187127_g) + d0;
            if (this.field_187127_g < d1) {
                this.func_187112_i();
            }
        }
    }

    public void setFluidTexture(FluidStack fluid) {
        TextureAtlasSprite sprite = ClientUtils.getSprite(fluid.getFluid().getAttributes().getStillTexture(fluid));
        if (sprite == null) {
            sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
        }
        this.func_217567_a(sprite);
        int argb = fluid.getFluid().getAttributes().getColor(fluid);
        this.field_82339_as = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.field_70552_h = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.field_70552_h = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.field_70552_h = (float)(argb & 0xFF) / 255.0f;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public static class DataDeserializer
    implements IParticleData.IDeserializer<Data> {
        public Data deserialize(ParticleType<Data> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            String name = reader.getString();
            Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name));
            return new Data(f);
        }

        public Data read(ParticleType<Data> particleTypeIn, PacketBuffer buffer) {
            String name = buffer.func_218666_n();
            Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name));
            return new Data(f);
        }
    }

    public static class Data
    implements IParticleData {
        private final Fluid fluid;

        public Data(Fluid fluid) {
            this.fluid = fluid;
        }

        public ParticleType<?> func_197554_b() {
            return IEParticles.FLUID_SPLASH;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.func_180714_a(this.fluid.getRegistryName().toString());
        }

        public String func_197555_a() {
            return this.fluid.getRegistryName().toString();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<Data> {
        @Nullable
        public Particle makeParticle(Data typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FluidSplashParticle(typeIn.fluid, worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

