/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.fx.IEParticles;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class FractalParticle
extends Particle {
    public static final Deque<FractalParticle> PARTICLE_FRACTAL_DEQUE = new ArrayDeque<FractalParticle>();
    public static final float[][] COLOUR_RED = new float[][]{{0.79f, 0.31f, 0.31f, 0.5f}, {1.0f, 0.97f, 0.87f, 0.75f}};
    public static final float[][] COLOUR_ORANGE = new float[][]{{Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.5f}, {1.0f, 0.97f, 0.87f, 0.75f}};
    public static final float[][] COLOUR_LIGHTNING = new float[][]{{0.3019608f, 0.2901961f, 0.59607846f, 0.75f}, {1.0f, 1.0f, 1.0f, 1.0f}};
    private Vec3d[] pointsList;
    private float[] colourOut;
    private float[] colourIn;

    public FractalParticle(World world, double x, double y, double z, double speedX, double speedY, double speedZ, Vec3d direction, double scale, int maxAge, int points, float[] colourOut, float[] colourIn) {
        super(world, x, y, z, speedX, speedY, speedZ);
        this.field_70547_e = maxAge;
        this.field_187129_i *= (double)0.009f;
        this.field_187130_j *= (double)0.009f;
        this.field_187131_k *= (double)0.009f;
        this.colourOut = colourOut;
        this.colourIn = colourIn;
        this.pointsList = new Vec3d[points];
        direction = direction.func_186678_a(scale);
        Vec3d startPos = direction.func_186678_a(-0.5);
        Vec3d end = direction.func_186678_a(0.5);
        Vec3d dist = end.func_178788_d(startPos);
        for (int i = 0; i < points; ++i) {
            Vec3d sub = startPos.func_72441_c(dist.field_72450_a / (double)points * (double)i, dist.field_72448_b / (double)points * (double)i, dist.field_72449_c / (double)points * (double)i);
            double fixPointDist = (i - points / 2) / (points / 2);
            double mod = scale * 1.0 - 0.45 * Math.abs(fixPointDist);
            double offX = (this.field_187136_p.nextDouble() - 0.5) * mod;
            double offY = (this.field_187136_p.nextDouble() - 0.5) * mod;
            double offZ = (this.field_187136_p.nextDouble() - 0.5) * mod;
            this.pointsList[i] = sub.func_72441_c(offX, offY, offZ);
        }
    }

    public FractalParticle(World world, double x, double y, double z, Vec3d direction, double scale, float[] colourOut, float[] colourIn) {
        this(world, x, y, z, 0.0, 0.0, 0.0, direction, scale, 10, 16, colourOut, colourIn);
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        PARTICLE_FRACTAL_DEQUE.add(this);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217605_e;
    }

    public List<Pair<RenderType, Consumer<IVertexBuilder>>> render(float partialTicks, MatrixStack matrixStack) {
        float mod = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        int iStartMut = 0;
        int iEndMut = this.pointsList.length;
        if ((double)mod >= 0.76) {
            float rem = (mod - 0.7599f) % 0.25f * 48.0f / 2.0f;
            iStartMut = (int)((double)iStartMut + Math.ceil(rem));
            iEndMut = (int)((double)iEndMut - Math.floor(rem));
        }
        int iStart = iStartMut;
        int iEnd = iEndMut;
        mod = 0.3f + mod * mod;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        matrixStack.func_227862_a_(mod, mod, mod);
        matrixStack.func_227863_a_(new Quaternion(0.0f, 180.0f * mod, 0.0f, true));
        Matrix4f transform = matrixStack.func_227866_c_().func_227870_a_();
        matrixStack.func_227865_b_();
        ArrayList<Pair<RenderType, Consumer<IVertexBuilder>>> ret = new ArrayList<Pair<RenderType, Consumer<IVertexBuilder>>>();
        LinePointProcessor putLinePoint = (buffer, i, color) -> {
            int correctIndex = iStart + (i - iStart) % (iEnd - iStart);
            Vec3d vecRender = this.pointsList[correctIndex];
            buffer.func_227888_a_(transform, (float)vecRender.field_72450_a, (float)vecRender.field_72448_b, (float)vecRender.field_72449_c).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
            if (i != iStart && i != iEnd) {
                buffer.func_227888_a_(transform, (float)vecRender.field_72450_a, (float)vecRender.field_72448_b, (float)vecRender.field_72449_c).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
            }
        };
        ret.add(Pair.of((Object)IERenderTypes.getLines(4.0f), buffer -> {
            for (int i = iStart; i <= iEnd; ++i) {
                putLinePoint.draw((IVertexBuilder)buffer, i, this.colourOut);
            }
        }));
        ret.add(Pair.of((Object)IERenderTypes.getLines(1.0f), buffer -> {
            for (int i = iEnd; i >= iStart; --i) {
                putLinePoint.draw((IVertexBuilder)buffer, i, this.colourIn);
            }
        }));
        ret.add(Pair.of((Object)IERenderTypes.getPoints(8.0f), buffer -> {
            for (int i = iStart; i < iEnd; ++i) {
                buffer.func_227888_a_(transform, (float)this.pointsList[i].field_72450_a, (float)this.pointsList[i].field_72448_b, (float)this.pointsList[i].field_72449_c).func_227885_a_(this.colourOut[0], this.colourOut[1], this.colourOut[2], this.colourOut[3]).func_181675_d();
            }
        }));
        ret.add(Pair.of((Object)IERenderTypes.getPoints(2.0f), buffer -> {
            for (int i = iEnd - 1; i >= iStart; --i) {
                buffer.func_227888_a_(transform, (float)this.pointsList[i].field_72450_a, (float)this.pointsList[i].field_72448_b, (float)this.pointsList[i].field_72449_c).func_227885_a_(this.colourIn[0], this.colourIn[1], this.colourIn[2], this.colourIn[3]).func_181675_d();
            }
        }));
        return ret;
    }

    public static class Factory
    implements IParticleFactory<Data> {
        @Nullable
        public Particle makeParticle(Data typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FractalParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.direction, typeIn.scale, typeIn.maxAge, typeIn.points, typeIn.colourOut, typeIn.colourIn);
        }
    }

    public static class DataDeserializer
    implements IParticleData.IDeserializer<Data> {
        public Data deserialize(ParticleType<Data> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            int i;
            double dX = reader.readDouble();
            reader.expect(' ');
            double dY = reader.readDouble();
            reader.expect(' ');
            double dZ = reader.readDouble();
            reader.expect(' ');
            double scale = reader.readDouble();
            reader.expect(' ');
            int maxAge = reader.readInt();
            reader.expect(' ');
            int points = reader.readInt();
            reader.expect(' ');
            float[] colourOut = new float[4];
            float[] colourIn = new float[4];
            for (i = 0; i < 4; ++i) {
                colourOut[i] = reader.readFloat();
                reader.expect(' ');
            }
            for (i = 0; i < 4; ++i) {
                colourIn[i] = reader.readFloat();
                reader.expect(' ');
            }
            return new Data(new Vec3d(dX, dY, dZ), scale, maxAge, points, colourOut, colourIn);
        }

        public Data read(ParticleType<Data> particleTypeIn, PacketBuffer buffer) {
            int i;
            Vec3d dir = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            double scale = buffer.readDouble();
            int maxAge = buffer.readInt();
            int points = buffer.readInt();
            float[] colourOut = new float[4];
            float[] colourIn = new float[4];
            for (i = 0; i < 4; ++i) {
                colourOut[i] = buffer.readFloat();
            }
            for (i = 0; i < 4; ++i) {
                colourIn[i] = buffer.readFloat();
            }
            return new Data(dir, scale, maxAge, points, colourOut, colourIn);
        }
    }

    public static class Data
    implements IParticleData {
        private final Vec3d direction;
        private final double scale;
        private final int maxAge;
        private final int points;
        private final float[] colourOut;
        private final float[] colourIn;

        public Data(Vec3d direction, double scale, int maxAge, int points, float[] colourOut, float[] colourIn) {
            this.direction = direction;
            this.scale = scale;
            this.maxAge = maxAge;
            this.points = points;
            this.colourOut = colourOut;
            this.colourIn = colourIn;
        }

        public ParticleType<?> func_197554_b() {
            return IEParticles.FRACTAL;
        }

        public void func_197553_a(PacketBuffer buffer) {
            int i;
            buffer.writeDouble(this.direction.field_72450_a).writeDouble(this.direction.field_72448_b).writeDouble(this.direction.field_72449_c);
            buffer.writeDouble(this.scale);
            buffer.writeInt(this.maxAge).writeInt(this.points);
            for (i = 0; i < 4; ++i) {
                buffer.writeFloat(this.colourOut[i]);
            }
            for (i = 0; i < 4; ++i) {
                buffer.writeFloat(this.colourIn[i]);
            }
        }

        public String func_197555_a() {
            int i;
            String ret = this.direction.field_72450_a + " " + this.direction.field_72448_b + " " + this.direction.field_72449_c + " " + this.scale + " " + this.maxAge + " " + this.points;
            for (i = 0; i < 4; ++i) {
                ret = ret + " " + this.colourOut[i];
            }
            for (i = 0; i < 4; ++i) {
                ret = ret + " " + this.colourIn[i];
            }
            return ret;
        }
    }

    private static interface LinePointProcessor {
        public void draw(IVertexBuilder var1, int var2, float[] var3);
    }
}

