/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;

public class GuiButtonIE
extends Button {
    protected final String texture;
    protected final int texU;
    protected final int texV;
    int[] hoverOffset;

    public GuiButtonIE(int x, int y, int w, int h, String name, String texture, int u, int v, IIEPressable handler) {
        super(x, y, w, h, name, (Button.IPressable)handler);
        this.texture = texture;
        this.texU = u;
        this.texV = v;
    }

    public GuiButtonIE setHoverOffset(int x, int y) {
        this.hoverOffset = new int[]{x, y};
        return this;
    }

    private boolean isPressable(double mouseX, double mouseY) {
        return this.active && this.visible && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientUtils.bindTexture(this.texture);
            FontRenderer fontrenderer = mc.field_71466_p;
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.isHovered = this.isPressable(mouseX, mouseY);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((int)770, (int)771);
            if (this.hoverOffset != null && this.isHovered) {
                this.blit(this.x, this.y, this.texU + this.hoverOffset[0], this.texV + this.hoverOffset[1], this.width, this.height);
            } else {
                this.blit(this.x, this.y, this.texU, this.texV, this.width, this.height);
            }
            if (!this.getMessage().isEmpty()) {
                int txtCol = 0xE0E0E0;
                if (!this.active) {
                    txtCol = 0xA0A0A0;
                } else if (this.isHovered) {
                    txtCol = -557004;
                }
                this.drawCenteredString(fontrenderer, this.getMessage(), this.x + this.width / 2, this.y + (this.height - 8) / 2, txtCol);
            }
        }
    }

    public void onPress() {
        this.onPress.onPress((Button)this);
    }

    public static interface IIEPressable<B extends GuiButtonIE>
    extends Button.IPressable {
        public void onIEPress(B var1);

        default public void onPress(Button var1) {
            Preconditions.checkArgument((boolean)(var1 instanceof GuiButtonIE));
            this.onIEPress((GuiButtonIE)var1);
        }
    }
}

