/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.Tree;
import com.electronwill.nightconfig.core.Config;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class IEManualInstance
extends ManualInstance {
    private final Set<ResourceLocation> hiddenEntries = new HashSet<ResourceLocation>();
    public final List<Function<String, Object>> configGetters = new ArrayList<Function<String, Object>>();
    private static final ResourceLocation SHADER_ENTRY = new ResourceLocation("immersiveengineering", "shader_list");

    public IEManualInstance() {
        super(new ResourceLocation("immersiveengineering", "textures/gui/manual.png"), 120, 148, new ResourceLocation("immersiveengineering", "manual"));
        this.configGetters.add(s -> {
            Config actualCfg = IEConfig.getRawConfig();
            if (!actualCfg.contains(s)) {
                return null;
            }
            return actualCfg.get(s);
        });
    }

    @Override
    public String getDefaultResourceDomain() {
        return "immersiveengineering";
    }

    @Override
    public String formatText(String s) {
        String[] segment;
        String rep;
        int end;
        int start;
        String splitKey = ";";
        s = s.replaceAll("<br>", "\n");
        int overflow = 0;
        while ((start = s.indexOf("<config")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            String result = this.formatConfigEntry(rep, splitKey);
            s = s.replaceFirst(rep, result);
        }
        overflow = 0;
        while ((start = s.indexOf("<dim")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            segment = rep.substring(0, rep.length() - 1).split(splitKey);
            if (segment.length < 2) break;
            ResourceLocation dimKey = new ResourceLocation(segment[1]);
            StringBuilder dimName = new StringBuilder();
            String[] stringArray = dimKey.func_110623_a().split("_");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String ss = stringArray[i];
                if ("the".equalsIgnoreCase(ss)) continue;
                dimName.append(Utils.toCamelCase(ss) + " ");
            }
            s = s.replaceFirst(rep, dimName.toString().trim());
        }
        overflow = 0;
        while ((start = s.indexOf("<keybind")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            segment = rep.substring(0, rep.length() - 1).split(splitKey);
            if (segment.length < 2) break;
            String result = "";
            for (KeyBinding kb : ClientUtils.mc().field_71474_y.field_74324_K) {
                if (!segment[1].equalsIgnoreCase(kb.func_151464_g())) continue;
                result = kb.func_197978_k();
                if (result == null || result.length() <= 1) break;
                result = Utils.toCamelCase(result);
                break;
            }
            s = s.replaceFirst(rep, result);
        }
        return s;
    }

    @Override
    public FontRenderer fontRenderer() {
        FontRenderer ret = ClientUtils.unicodeFontRender();
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            ret.func_78275_b(ClientUtils.mc().func_135016_M().func_135044_b());
        }
        return ret;
    }

    @Override
    public String getManualName() {
        return I18n.func_135052_a((String)"item.immersiveengineering.manual", (Object[])new Object[0]);
    }

    @Override
    public String formatCategoryName(ResourceLocation s) {
        return (this.improveReadability() ? TextFormatting.BOLD : "") + I18n.func_135052_a((String)("manual." + s.toString().replace(':', '.')), (Object[])new Object[0]);
    }

    @Override
    public String formatEntryName(String s) {
        return (this.improveReadability() ? TextFormatting.BOLD : "") + s;
    }

    @Override
    public String formatEntrySubtext(String s) {
        return s;
    }

    public void hideEntry(ResourceLocation name) {
        this.hiddenEntries.add(name);
    }

    @Override
    public boolean showNodeInList(Tree.AbstractNode<ResourceLocation, ManualEntry> node) {
        ResourceLocation nodeLoc;
        ResourceLocation resourceLocation = nodeLoc = node.isLeaf() ? node.getLeafData().getLocation() : node.getNodeData();
        if ("immersiveengineering".equals(nodeLoc.func_110624_b()) && nodeLoc.func_110623_a().startsWith(ManualHelper.CAT_UPDATE)) {
            return (Boolean)IEConfig.GENERAL.showUpdateNews.get();
        }
        return !nodeLoc.equals((Object)SHADER_ENTRY) && !this.hiddenEntries.contains(nodeLoc);
    }

    @Override
    public boolean showCategoryInList(String category) {
        return true;
    }

    @Override
    public String formatLink(ManualInstance.ManualLink link) {
        return TextFormatting.GOLD + "  -> " + link.getKey().getTitle() + ", " + (link.getPage() + 1);
    }

    @Override
    public void openEntry(ManualEntry entry) {
        if (SHADER_ENTRY.equals((Object)entry.getLocation())) {
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageShaderManual(MessageShaderManual.MessageType.SYNC, new ResourceLocation[0]));
        }
    }

    @Override
    public int getTitleColour() {
        return 16220212;
    }

    @Override
    public int getSubTitleColour() {
        return 16220212;
    }

    @Override
    public int getTextColour() {
        return this.improveReadability() ? 0 : 0x555555;
    }

    @Override
    public int getHighlightColour() {
        return 13926474;
    }

    @Override
    public int getPagenumberColour() {
        return 10260860;
    }

    @Override
    public boolean allowGuiRescale() {
        return (Boolean)IEConfig.GENERAL.adjustManualScale.get();
    }

    @Override
    public boolean improveReadability() {
        return (Boolean)IEConfig.GENERAL.badEyesight.get();
    }

    public String formatConfigEntry(String rep, String splitKey) {
        Function<String, Object> f;
        String[] segment = rep.substring(0, rep.length() - 1).split(splitKey);
        Preconditions.checkState((segment.length >= 3 ? 1 : 0) != 0, (String)"%s is not a valid config entry", (Object)rep);
        Object configValueObj = null;
        Iterator<Function<String, Object>> iterator = this.configGetters.iterator();
        while (iterator.hasNext() && (configValueObj = (f = iterator.next()).apply(segment[2])) == null) {
        }
        Preconditions.checkState((configValueObj != null ? 1 : 0) != 0, (String)"Config key %s does not exist", (Object)segment[2]);
        if (segment[1].equalsIgnoreCase("b")) {
            Preconditions.checkState((boolean)(configValueObj instanceof Boolean), (String)"Expected boolean value for %s, got %s", (Object)segment[2], (Object)configValueObj);
            boolean configValue = (Boolean)configValueObj;
            if (segment.length > 3) {
                return configValue ? segment[3] : (segment.length > 4 ? segment[4] : "");
            }
            return Boolean.toString(configValue);
        }
        if (segment[1].equalsIgnoreCase("i")) {
            Preconditions.checkState((boolean)(configValueObj instanceof Number), (String)"Expected number value for %s, got %s", (Object)segment[2], (Object)configValueObj);
            return Integer.toString(((Number)configValueObj).intValue());
        }
        if (segment[1].equalsIgnoreCase("iA")) {
            Preconditions.checkState((configValueObj instanceof List && ((List)configValueObj).stream().allMatch(n -> n instanceof Number) ? 1 : 0) != 0, (String)"Expected list of integer for %s, got %s", (Object)segment[2], (Object)configValueObj);
            List configList = (List)configValueObj;
            if (segment.length > 3) {
                try {
                    if (segment[3].startsWith("l")) {
                        int limiter = Integer.parseInt(segment[3].substring(1));
                        StringBuilder result = new StringBuilder();
                        for (int i = 0; i < limiter; ++i) {
                            result.append(i > 0 ? ", " : "").append(configList.get(i));
                        }
                        return result.toString();
                    }
                    int idx = Integer.parseInt(segment[3]);
                    return "" + configList.get(idx);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to parse " + segment[3] + " as integer");
                }
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < configList.size(); ++i) {
                result.append(i > 0 ? ", " : "").append(configList.get(i));
            }
            return result.toString();
        }
        if (segment[1].equalsIgnoreCase("d")) {
            Preconditions.checkState((boolean)(configValueObj instanceof Number), (String)"Expected double for %s, got %s", (Object)segment[2], (Object)configValueObj);
            return Double.toString(((Number)configValueObj).doubleValue());
        }
        if (segment[1].equalsIgnoreCase("str")) {
            Preconditions.checkState((boolean)(configValueObj instanceof String), (String)"Expected string for %s, got %s", (Object)segment[2], (Object)configValueObj);
            return (String)configValueObj;
        }
        throw new RuntimeException("Unknown config type: " + segment[1] + " (part of " + rep + ")");
    }
}

