/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManual;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class ShaderManualElement
extends SpecialManualElements {
    final ShaderRegistry.ShaderRegistryEntry shader;
    ItemStack shaderItem;
    ItemStack[] exampleItems;
    IngredientWithSize replicationCost;
    int example = 0;
    boolean unlocked;
    String name;
    String text;

    public ShaderManualElement(ManualInstance manual, ShaderRegistry.ShaderRegistryEntry shader) {
        super(manual);
        this.shader = shader;
    }

    @Override
    public int getPixelsTaken() {
        return 47;
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> buttons) {
        ClientPlayerEntity player = ManualUtils.mc().field_71439_g;
        UUID uuid = player.func_110124_au();
        this.unlocked = ShaderRegistry.receivedShaders.get((Object)uuid).contains(this.shader.getName());
        this.shaderItem = new ItemStack((IItemProvider)ShaderRegistry.itemShader);
        this.shaderItem.func_196082_o().func_74778_a("shader_name", this.shader.getName().toString());
        this.replicationCost = this.shader.replicationCost;
        if (this.unlocked) {
            ArrayList list = new ArrayList();
            for (ItemStack is : ShaderRegistry.itemExamples) {
                ItemStack s = is.func_77946_l();
                s.getCapability(CapabilityShader.SHADER_CAPABILITY).ifPresent(wrapper -> {
                    wrapper.setShaderItem(this.shaderItem);
                    list.add(s);
                });
            }
            this.exampleItems = list.toArray(new ItemStack[0]);
            this.example = 0;
            if (this.exampleItems.length > 1) {
                buttons.add(new GuiButtonManualNavigation(gui, x + 50, y, 10, 16, 0, btn -> {
                    --this.example;
                    if (this.example < 0) {
                        this.example = this.exampleItems.length - 1;
                    }
                }));
                buttons.add(new GuiButtonManualNavigation(gui, x + 100, y, 10, 16, 1, btn -> {
                    this.example = (this.example + 1) % this.exampleItems.length;
                }));
            }
        } else {
            this.exampleItems = null;
        }
        this.name = this.shaderItem.func_200301_q().func_211708_a(TextFormatting.BOLD).func_150254_d();
        StringTextComponent textAssembly = new StringTextComponent("");
        textAssembly.func_150257_a(new TranslationTextComponent("desc.immersiveengineering.info.shader.level", new Object[0]).func_211708_a(TextFormatting.BOLD));
        textAssembly.func_150257_a((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.rarity." + this.shader.rarity.name().toLowerCase(Locale.US), new Object[0]));
        if (this.unlocked) {
            String details;
            String set = this.shader.info_set == null || this.shader.info_set.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.set.%s", this.shader.info_set);
            String reference = this.shader.info_reference == null || this.shader.info_reference.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.reference.%s", this.shader.info_reference);
            String string = details = this.shader.info_details == null || this.shader.info_details.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.details.%s", this.shader.info_details);
            if (set != null) {
                textAssembly.func_150258_a("\n").func_150257_a(new TranslationTextComponent("desc.immersiveengineering.info.shader.set", new Object[0]).func_211708_a(TextFormatting.BOLD)).func_150258_a(" " + set);
            }
            if (reference != null) {
                textAssembly.func_150258_a("\n").func_150257_a(new TranslationTextComponent("desc.immersiveengineering.info.shader.reference", new Object[0]).func_211708_a(TextFormatting.BOLD)).func_150258_a("\n" + reference);
            }
            if (details != null) {
                textAssembly.func_150258_a("\n").func_150257_a(new TranslationTextComponent("desc.immersiveengineering.info.shader.details", new Object[0]).func_211708_a(TextFormatting.BOLD)).func_150258_a("\n" + details);
            }
            String cost = Integer.toString(this.replicationCost.getCount());
            if (!IngredientUtils.hasPlayerIngredient((PlayerEntity)ManualUtils.mc().field_71439_g, this.replicationCost) && !ManualUtils.mc().field_71439_g.field_71075_bZ.field_75098_d) {
                cost = TextFormatting.RED + cost;
            }
            buttons.add(new GuiButtonManual(gui, x + 50, y + 120, 70, 12, TextFormatting.BOLD + I18n.func_135052_a((String)"ie.manual.entry.shaderList.order", (Object[])new Object[0]) + " " + cost + "x   ", btn -> {
                if (IngredientUtils.hasPlayerIngredient((PlayerEntity)ManualUtils.mc().field_71439_g, this.replicationCost) || ManualUtils.mc().field_71439_g.field_71075_bZ.field_75098_d) {
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageShaderManual(MessageShaderManual.MessageType.SPAWN, this.shader.getName()));
                }
                gui.fullInit();
            }).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
        } else {
            textAssembly.func_150258_a("\n\n").func_150257_a((ITextComponent)new TranslationTextComponent("ie.manual.entry.shaderList.noInfo", new Object[0]));
            if (player.field_71075_bZ.field_75098_d) {
                buttons.add(new GuiButtonManual(gui, x + 10, y + 120, 100, 16, I18n.func_135052_a((String)"ie.manual.entry.shaderList.unlock", (Object[])new Object[0]), btn -> {
                    UUID playerId = ManualUtils.mc().field_71439_g.func_110124_au();
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageShaderManual(MessageShaderManual.MessageType.UNLOCK, this.shader.getName()));
                    ShaderRegistry.receivedShaders.put((Object)playerId, (Object)this.shader.getName());
                    gui.fullInit();
                }).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
            }
        }
        this.text = textAssembly.func_150254_d();
    }

    @Override
    public void render(ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        GL11.glEnable((int)32826);
        RenderHelper.func_227780_a_();
        float scale = 2.0f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        boolean examples = this.exampleItems != null && this.exampleItems.length > 0;
        ManualUtils.renderItem().func_180450_b(this.shaderItem, (int)((float)(x + 10 + (examples ? 0 : 34)) / scale), (int)((float)(y - 8) / scale));
        if (examples && this.example >= 0 && this.example < this.exampleItems.length) {
            ManualUtils.renderItem().func_180450_b(this.exampleItems[this.example], (int)((float)(x + 63) / scale), (int)((float)(y - 8) / scale));
        }
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        if (this.unlocked) {
            ManualUtils.renderItem().func_180450_b(this.replicationCost.getRandomizedExampleStack(ManualUtils.mc().field_71439_g.field_70173_aa), x + 102, y + 118);
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        int w = this.manual.fontRenderer().func_78256_a(this.name);
        this.manual.fontRenderer().func_211126_b(this.name, (float)(x + 60 - w / 2), (float)(y + 24), this.manual.getTextColour());
        if (this.text != null && !this.text.isEmpty()) {
            this.manual.fontRenderer().func_78279_b(this.text, x, y + 38, 120, this.manual.getTextColour());
        }
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public void recalculateCraftingRecipes() {
    }
}

