/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.client.models.obj.OBJHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.client.model.obj.OBJModel;

public class TextureCoordinateRemapper {
    private final List<Vec2f> texCoords;
    private final HashMap<Integer, Vec2f> backup;
    private final ShaderCase shaderCase;
    private final boolean flipV;
    private ShaderLayer shaderLayer;

    public TextureCoordinateRemapper(OBJModel model, ShaderCase shaderCase) {
        this.texCoords = OBJHelper.getTexCoords(model);
        this.shaderCase = shaderCase;
        this.backup = new HashMap();
        this.flipV = model.flipV;
    }

    public void setRenderPass(int pass) {
        if (this.shaderCase != null) {
            this.shaderLayer = this.shaderCase.getLayers()[pass];
        }
    }

    public boolean remapCoord(int[][] face) {
        if (this.shaderCase == null || this.texCoords.size() < 1) {
            return true;
        }
        double[] texBounds = this.shaderLayer.getTextureBounds();
        double[] cutBounds = this.shaderLayer.getCutoutBounds();
        if (texBounds == null && cutBounds == null) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            double dV;
            double dU;
            int texIndex;
            int[] index = face[Math.min(i, face.length - 1)];
            if (index.length < 2 || this.backup.containsKey(texIndex = index[1])) continue;
            Vec2f texCoord = this.texCoords.get(texIndex);
            this.backup.put(texIndex, texCoord);
            if (this.flipV) {
                texCoord = new Vec2f(texCoord.field_189982_i, 1.0f - texCoord.field_189983_j);
            }
            if (texBounds != null) {
                if (texBounds[0] > (double)texCoord.field_189982_i || (double)texCoord.field_189982_i > texBounds[2] || texBounds[1] > (double)texCoord.field_189983_j || (double)texCoord.field_189983_j > texBounds[3]) {
                    this.texCoords.set(texIndex, texCoord);
                    return false;
                }
                dU = texBounds[2] - texBounds[0];
                dV = texBounds[3] - texBounds[1];
                texCoord = new Vec2f((float)(((double)texCoord.field_189982_i - texBounds[0]) / dU), (float)(((double)texCoord.field_189983_j - texBounds[1]) / dV));
            }
            if (cutBounds != null) {
                dU = cutBounds[2] - cutBounds[0];
                dV = cutBounds[3] - cutBounds[1];
                texCoord = new Vec2f((float)(cutBounds[0] + dU * (double)texCoord.field_189982_i), (float)(cutBounds[1] + dV * (double)texCoord.field_189983_j));
            }
            if (this.flipV) {
                texCoord = new Vec2f(texCoord.field_189982_i, 1.0f - texCoord.field_189983_j);
            }
            this.texCoords.set(texIndex, texCoord);
        }
        return true;
    }

    public void resetCoords() {
        for (Map.Entry<Integer, Vec2f> entry : this.backup.entrySet()) {
            this.texCoords.set(entry.getKey(), entry.getValue());
        }
        this.backup.clear();
    }
}

