/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.Polygon;
import malte0811.modelsplitter.model.Vertex;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class PolygonUtils {
    private static int getOffset(VertexFormatElement.Usage usage, VertexFormatElement.Type type) {
        int offset = 0;
        for (VertexFormatElement e : DefaultVertexFormats.field_176600_a.func_227894_c_()) {
            if (e.func_177375_c() == usage && e.func_177367_b() == type) {
                return offset / 4;
            }
            offset += e.func_177368_f();
        }
        throw new IllegalStateException("Did not find element with usage " + usage.name() + " and type " + type.name());
    }

    public static Polygon<TextureAtlasSprite> toPolygon(BakedQuad quad) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(4);
        int posOffset = PolygonUtils.getOffset(VertexFormatElement.Usage.POSITION, VertexFormatElement.Type.FLOAT);
        int uvOffset = PolygonUtils.getOffset(VertexFormatElement.Usage.UV, VertexFormatElement.Type.FLOAT);
        int normalOffset = PolygonUtils.getOffset(VertexFormatElement.Usage.NORMAL, VertexFormatElement.Type.BYTE);
        for (int v = 0; v < 4; ++v) {
            int baseOffset = v * DefaultVertexFormats.field_176600_a.func_177338_f() / 4;
            int packedNormal = quad.func_178209_a()[normalOffset + baseOffset];
            Vec3d normalVec = new Vec3d((byte)packedNormal, (byte)(packedNormal >> 8), (byte)(packedNormal >> 16)).normalize();
            double[] uv = new double[]{Float.intBitsToFloat(quad.func_178209_a()[uvOffset + baseOffset]), Float.intBitsToFloat(quad.func_178209_a()[uvOffset + baseOffset + 1])};
            Vec3d pos = new Vec3d(Float.intBitsToFloat(quad.func_178209_a()[baseOffset + posOffset]), Float.intBitsToFloat(quad.func_178209_a()[baseOffset + posOffset + 1]), Float.intBitsToFloat(quad.func_178209_a()[baseOffset + posOffset + 2]));
            vertices.add(new Vertex(pos, normalVec, uv));
        }
        return new Polygon<TextureAtlasSprite>(vertices, quad.func_187508_a());
    }

    public static BakedQuad toBakedQuad(Polygon<TextureAtlasSprite> poly, IModelTransform transform, VertexFormat format) {
        Preconditions.checkArgument((poly.getPoints().size() == 4 ? 1 : 0) != 0);
        BakedQuadBuilder quadBuilder = new BakedQuadBuilder(poly.getTexture());
        TransformationMatrix rotation = transform.func_225615_b_().blockCenterToCorner();
        Vector3f normal = new Vector3f();
        for (Vertex v : poly.getPoints()) {
            ImmutableList elements = format.func_227894_c_();
            Vector4f pos = new Vector4f();
            pos.set(PolygonUtils.toArray(v.getPosition(), 4));
            normal.set(PolygonUtils.toArray(v.getNormal(), 3));
            rotation.transformPosition(pos);
            rotation.transformNormal(normal);
            pos.func_229375_f_();
            int elementsSize = elements.size();
            block8: for (int i = 0; i < elementsSize; ++i) {
                VertexFormatElement element = (VertexFormatElement)elements.get(i);
                switch (element.func_177375_c()) {
                    case POSITION: {
                        quadBuilder.put(i, new float[]{pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c()});
                        continue block8;
                    }
                    case NORMAL: {
                        quadBuilder.put(i, new float[]{normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()});
                        continue block8;
                    }
                    case COLOR: {
                        quadBuilder.put(i, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                        continue block8;
                    }
                    case UV: {
                        if (element.func_177367_b() == VertexFormatElement.Type.FLOAT) {
                            quadBuilder.put(i, new float[]{(float)v.getU(), (float)v.getV()});
                            continue block8;
                        }
                        quadBuilder.put(i, new float[]{0.0f, 0.0f});
                        continue block8;
                    }
                    case PADDING: {
                        quadBuilder.put(i, new float[]{0.0f});
                    }
                }
            }
        }
        quadBuilder.setQuadOrientation(Direction.func_176737_a((float)normal.func_195899_a(), (float)normal.func_195900_b(), (float)normal.func_195902_c()));
        return quadBuilder.build();
    }

    private static float[] toArray(Vec3d vec, int length) {
        int i;
        float[] ret = new float[length];
        for (i = 0; i < 3; ++i) {
            ret[i] = (float)vec.get(i);
        }
        for (i = 3; i < length; ++i) {
            ret[i] = 1.0f;
        }
        return ret;
    }
}

