/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.client.models.split.BakedBasicSplitModel;
import blusunrize.immersiveengineering.client.models.split.BakedDynamicSplitModel;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class UnbakedSplitModel
implements IModelGeometry<UnbakedSplitModel> {
    private final IModelGeometry<?> baseModel;
    private final Set<Vec3i> parts;
    private final boolean dynamic;

    public UnbakedSplitModel(IModelGeometry<?> baseModel, List<Vec3i> parts, boolean dynamic) {
        this.baseModel = baseModel;
        this.parts = new HashSet<Vec3i>(parts);
        this.dynamic = dynamic;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        IBakedModel bakedBase = this.baseModel.bake(owner, bakery, spriteGetter, (IModelTransform)ModelRotation.X0_Y0, overrides, modelLocation);
        if (this.dynamic) {
            return new BakedDynamicSplitModel((ICacheKeyProvider)bakedBase, this.parts, modelTransform);
        }
        return new BakedBasicSplitModel(bakedBase, this.parts, modelTransform);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.baseModel.getTextures(owner, modelGetter, missingTextureErrors);
    }
}

