/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.entities.RailgunShotEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RailgunShotRenderer
extends EntityRenderer<RailgunShotEntity> {
    private static final RailgunHandler.RailgunRenderColors DEFAULT_RENDER_COLORS = new RailgunHandler.RailgunRenderColors(0x686868, 0xA4A4A4, 0xA4A4A4, 0xA4A4A4, 0x686868);

    public RailgunShotRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(RailgunShotEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        RailgunHandler.IRailgunProjectile prop;
        double yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks - 90.0f;
        double pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        ItemStack ammo = entity.getAmmo();
        RailgunHandler.RailgunRenderColors colors = DEFAULT_RENDER_COLORS;
        if (!ammo.func_190926_b() && (prop = RailgunHandler.getProjectile(ammo)) instanceof RailgunHandler.StandardRailgunProjectile && ((RailgunHandler.StandardRailgunProjectile)prop).getColorMap() != null) {
            colors = ((RailgunHandler.StandardRailgunProjectile)prop).getColorMap();
        }
        RailgunShotRenderer.renderRailgunProjectile(yaw, pitch, colors, matrixStackIn, bufferIn, packedLightIn);
    }

    public static void renderRailgunProjectile(double yaw, double pitch, RailgunHandler.RailgunRenderColors colors, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int light) {
        int[] rgb;
        int i;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), (float)yaw, true));
        matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), (float)pitch, true));
        matrixStackIn.func_227862_a_(0.25f, 0.25f, 0.25f);
        float height = 0.1875f;
        float halfWidth = height / 2.0f;
        float length = 2.0f;
        int colWidth = colors.getGradientLength();
        int colLength = colors.getRingCount();
        float widthStep = height / (float)colWidth;
        float lengthStep = length / (float)colLength;
        matrixStackIn.func_227861_a_((double)(-length * 0.85f), 0.0, 0.0);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(bufferIn.getBuffer(IERenderTypes.POSITION_COLOR_LIGHTMAP), matrixStackIn);
        builder.setLight(light);
        for (i = 0; i < colWidth; ++i) {
            rgb = colors.getFrontColor(i);
            builder.func_225582_a_(0.0, height, -halfWidth + widthStep * (float)i).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(0.0, 0.0, -halfWidth + widthStep * (float)i).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(0.0, 0.0, -halfWidth + widthStep * (float)(i + 1)).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(0.0, height, -halfWidth + widthStep * (float)(i + 1)).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            rgb = colors.getBackColor(i);
            builder.func_225582_a_(length, 0.0, -halfWidth + widthStep * (float)i).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(length, height, -halfWidth + widthStep * (float)i).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(length, height, -halfWidth + widthStep * (float)(i + 1)).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(length, 0.0, -halfWidth + widthStep * (float)(i + 1)).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
        }
        for (i = 0; i < colLength; ++i) {
            rgb = colors.getRingColor(i, 0);
            builder.func_225582_a_(lengthStep * (float)i, 0.0, -halfWidth).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(lengthStep * (float)i, height, -halfWidth).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(lengthStep * (float)(i + 1), height, -halfWidth).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(lengthStep * (float)(i + 1), 0.0, -halfWidth).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            rgb = colors.getRingColor(i, colWidth - 1);
            builder.func_225582_a_(lengthStep * (float)i, height, halfWidth).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(lengthStep * (float)i, 0.0, halfWidth).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(lengthStep * (float)(i + 1), 0.0, halfWidth).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            builder.func_225582_a_(lengthStep * (float)(i + 1), height, halfWidth).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
        }
        for (i = 0; i < colLength; ++i) {
            for (int j = 0; j < colWidth; ++j) {
                rgb = colors.getRingColor(i, j);
                builder.func_225582_a_(lengthStep * (float)(i + 1), height, -halfWidth + widthStep * (float)j).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
                builder.func_225582_a_(lengthStep * (float)i, height, -halfWidth + widthStep * (float)j).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
                builder.func_225582_a_(lengthStep * (float)i, height, -halfWidth + widthStep * (float)(j + 1)).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
                builder.func_225582_a_(lengthStep * (float)(i + 1), height, -halfWidth + widthStep * (float)(j + 1)).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
                builder.func_225582_a_(lengthStep * (float)i, 0.0, -halfWidth + widthStep * (float)j).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
                builder.func_225582_a_(lengthStep * (float)(i + 1), 0.0, -halfWidth + widthStep * (float)j).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
                builder.func_225582_a_(lengthStep * (float)(i + 1), 0.0, -halfWidth + widthStep * (float)(j + 1)).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
                builder.func_225582_a_(lengthStep * (float)i, 0.0, -halfWidth + widthStep * (float)(j + 1)).func_225586_a_(rgb[0], rgb[1], rgb[2], 255).func_181675_d();
            }
        }
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(@Nonnull RailgunShotEntity p_110775_1_) {
        return new ResourceLocation("immersiveengineering:textures/models/white.png");
    }
}

