/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.metal.SheetmetalTankTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraftforge.fluids.FluidStack;

public class SheetmetalTankRenderer
extends TileEntityRenderer<SheetmetalTankTileEntity> {
    public SheetmetalTankRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(SheetmetalTankTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.formed || tile.isDummy() || !tile.getWorldNonnull().func_175667_e(tile.func_174877_v())) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        FluidStack fs = tile.tank.getFluid();
        matrixStack.func_227861_a_(0.0, 3.5, 0.0);
        float baseScale = 0.0625f;
        matrixStack.func_227862_a_(baseScale, -baseScale, baseScale);
        float xx = -0.5f;
        float zz = 1.496f;
        xx /= baseScale;
        zz /= baseScale;
        for (int i = 0; i < 4; ++i) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)xx, 0.0, (double)zz);
            Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
            IVertexBuilder builder = bufferIn.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
            builder.func_227888_a_(mat, -4.0f, -4.0f, 0.0f).func_225586_a_(34, 34, 34, 255).func_181675_d();
            builder.func_227888_a_(mat, -4.0f, 20.0f, 0.0f).func_225586_a_(34, 34, 34, 255).func_181675_d();
            builder.func_227888_a_(mat, 20.0f, 20.0f, 0.0f).func_225586_a_(34, 34, 34, 255).func_181675_d();
            builder.func_227888_a_(mat, 20.0f, -4.0f, 0.0f).func_225586_a_(34, 34, 34, 255).func_181675_d();
            if (!fs.isEmpty()) {
                float h = (float)fs.getAmount() / (float)tile.tank.getCapacity();
                matrixStack.func_227861_a_(0.0, 0.0, (double)0.004f);
                ClientUtils.drawRepeatedFluidSprite(bufferIn.getBuffer(RenderType.func_228639_c_()), matrixStack, fs, 0.0f, 0.0f + (1.0f - h) * 16.0f, 16.0f, h * 16.0f);
            }
            matrixStack.func_227865_b_();
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
        }
        matrixStack.func_227865_b_();
    }
}

