/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.TileRenderUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.SqueezerTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SqueezerRenderer
extends TileEntityRenderer<SqueezerTileEntity> {
    public static DynamicModel<Direction> PISTON;

    public SqueezerRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(SqueezerTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getWorldNonnull().func_175667_e(te.func_174877_v())) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = te.func_174877_v();
        BlockState state = te.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != IEBlocks.Multiblocks.squeezer) {
            return;
        }
        IBakedModel model = PISTON.get(te.getFacing());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        bufferIn = TileRenderUtils.mirror(te, matrixStack, bufferIn);
        IVertexBuilder buffer = bufferIn.getBuffer(RenderType.func_228639_c_());
        float piston = te.animation_piston;
        piston = piston * piston * (3.0f - 2.0f * piston);
        matrixStack.func_227861_a_(0.0, (double)piston, 0.0);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        blockRenderer.func_175019_b().renderModel((ILightReader)te.getWorldNonnull(), model, state, blockPos, matrixStack, buffer, true, te.func_145831_w().field_73012_v, 0L, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
    }
}

