/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.wooden.WindmillTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class WindmillRenderer
extends TileEntityRenderer<WindmillTileEntity> {
    private static List<BakedQuad>[] quads = new List[9];
    public static DynamicModel<Void> MODEL;

    public WindmillRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(WindmillTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getWorldNonnull().func_175667_e(tile.func_174877_v())) {
            return;
        }
        BlockPos blockPos = tile.func_174877_v();
        if (quads[tile.sails] == null) {
            BlockState state = tile.func_145831_w().func_180495_p(blockPos);
            if (state.func_177230_c() != IEBlocks.WoodenDevices.windmill) {
                return;
            }
            state = (BlockState)state.func_206870_a((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)Direction.NORTH);
            IBakedModel model = MODEL.get(null);
            ArrayList<String> parts = new ArrayList<String>();
            parts.add("base");
            for (int i = 1; i <= tile.sails; ++i) {
                parts.add("sail_" + i);
            }
            SinglePropertyModelData<IEProperties.IEObjState> data = new SinglePropertyModelData<IEProperties.IEObjState>(new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts)), IEProperties.Model.IE_OBJ_STATE);
            WindmillRenderer.quads[tile.sails] = model.getQuads(state, null, Utils.RAND, data);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        float dir = tile.getFacing() == Direction.SOUTH ? 0.0f : (tile.getFacing() == Direction.NORTH ? 180.0f : (tile.getFacing() == Direction.EAST ? 90.0f : -90.0f));
        float rot = 360.0f * (tile.rotation + (!tile.canTurn || tile.rotation == 0.0f ? 0.0f : partialTicks) * tile.perTick);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(tile.getFacing().func_176740_k() == Direction.Axis.X ? 1.0f : 0.0f, 0.0f, tile.getFacing().func_176740_k() == Direction.Axis.Z ? 1.0f : 0.0f), rot, true));
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), dir, true));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228643_e_());
        ClientUtils.renderModelTESRFast(quads[tile.sails], builder, matrixStack, combinedLightIn);
        matrixStack.func_227865_b_();
    }

    public static void reset() {
        Arrays.fill(quads, null);
    }
}

