/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldSavedData;

public class IESaveData
extends WorldSavedData {
    private static IESaveData INSTANCE;
    public static final String dataName = "ImmersiveEngineering-SaveData";

    public IESaveData() {
        super(dataName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT tag;
        int i;
        ListNBT dimensionList = nbt.func_150295_c("mineralVeins", 10);
        Multimap<DimensionType, MineralVein> multimap = ExcavatorHandler.getMineralVeinList();
        synchronized (multimap) {
            ExcavatorHandler.getMineralVeinList().clear();
            for (i = 0; i < dimensionList.size(); ++i) {
                CompoundNBT dimTag = dimensionList.func_150305_b(i);
                ResourceLocation rl = new ResourceLocation(dimTag.func_74779_i("dimension"));
                DimensionType dimensionType = DimensionType.func_193417_a((ResourceLocation)rl);
                if (dimensionType == null) continue;
                ListNBT mineralList = dimTag.func_150295_c("veins", 10);
                ExcavatorHandler.getMineralVeinList().putAll((Object)dimensionType, (Iterable)mineralList.stream().map(inbt -> MineralVein.readFromNBT((CompoundNBT)inbt)).collect(Collectors.toList()));
            }
        }
        if (nbt.func_150297_b("mineralDepletion", 9)) {
            ListNBT oldList = nbt.func_150295_c("mineralDepletion", 10);
            for (i = 0; i < oldList.size(); ++i) {
                tag = oldList.func_150305_b(i);
                CompoundNBT mineralInfo = tag.func_74775_l("info");
                if (!mineralInfo.func_150297_b("mineral", 8)) continue;
                ResourceLocation mineral = new ResourceLocation(mineralInfo.func_74779_i("mineral"));
                DimensionChunkCoords oldCoords = DimensionChunkCoords.readFromNBT(tag);
                int depletion = mineralInfo.func_74762_e("depletion");
                ColumnPos convertedPos = new ColumnPos(oldCoords.func_180334_c() + 8, oldCoords.func_180333_d() + 8);
                MineralVein convertedVein = new MineralVein(convertedPos, mineral, 8);
                convertedVein.setDepletion(depletion);
                ExcavatorHandler.getMineralVeinList().put((Object)oldCoords.dimension, (Object)convertedVein);
            }
        }
        ListNBT receivedShaderList = nbt.func_150295_c("receivedShaderList", 10);
        for (i = 0; i < receivedShaderList.size(); ++i) {
            tag = receivedShaderList.func_150305_b(i);
            UUID player = tag.func_186857_a("player");
            ShaderRegistry.receivedShaders.get((Object)player).clear();
            ListNBT playerReceived = tag.func_150295_c("received", 8);
            for (int j = 0; j < playerReceived.size(); ++j) {
                String s = playerReceived.func_150307_f(j);
                if (s.isEmpty()) continue;
                ShaderRegistry.receivedShaders.put((Object)player, (Object)new ResourceLocation(s));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT nbt) {
        ListNBT dimensionList = new ListNBT();
        Multimap<DimensionType, MineralVein> multimap = ExcavatorHandler.getMineralVeinList();
        synchronized (multimap) {
            for (DimensionType dimension : ExcavatorHandler.getMineralVeinList().keySet()) {
                CompoundNBT dimTag = new CompoundNBT();
                dimTag.func_74778_a("dimension", dimension.getRegistryName().toString());
                ListNBT mineralList = new ListNBT();
                for (MineralVein mineralVein : ExcavatorHandler.getMineralVeinList().get((Object)dimension)) {
                    mineralList.add((Object)mineralVein.writeToNBT());
                }
                dimTag.func_218657_a("veins", (INBT)mineralList);
                dimensionList.add((Object)dimTag);
            }
        }
        nbt.func_218657_a("mineralVeins", (INBT)dimensionList);
        ListNBT receivedShaderList = new ListNBT();
        for (UUID player : ShaderRegistry.receivedShaders.keySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a("player", player);
            ListNBT playerReceived = new ListNBT();
            for (ResourceLocation shader : ShaderRegistry.receivedShaders.get((Object)player)) {
                if (shader == null) continue;
                playerReceived.add((Object)StringNBT.func_229705_a_((String)shader.toString()));
            }
            tag.func_218657_a("received", (INBT)playerReceived);
            receivedShaderList.add((Object)tag);
        }
        nbt.func_218657_a("receivedShaderList", (INBT)receivedShaderList);
        return nbt;
    }

    public static void setDirty() {
        if (INSTANCE != null) {
            INSTANCE.func_76185_a();
        }
    }

    public static void setInstance(IESaveData in) {
        INSTANCE = in;
    }
}

