/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ArcFurnaceTileEntity
extends PoweredMultiblockTileEntity<ArcFurnaceTileEntity, ArcFurnaceRecipe>
implements IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds {
    public static final int FIRST_ELECTRODE_SLOT = 23;
    public static final int ELECTRODE_COUNT = 3;
    private static final int SLAG_SLOT = 22;
    private static final int FIRST_OUT_SLOT = 16;
    private static final int OUT_SLOT_COUNT = 6;
    private static final BlockPos SLAG_OUT_POS = new BlockPos(2, 0, 0);
    private static final BlockPos MAIN_OUT_POS = new BlockPos(2, 0, 4);
    private static final int[] OUTPUT_SLOTS = new int[6];
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)26, (Object)ItemStack.field_190927_a);
    public int pouringMetal = 0;
    private CapabilityReference<IItemHandler> output = CapabilityReference.forTileEntity(this, () -> new DirectionalBlockPos(this.getBlockPosForPos(MAIN_OUT_POS).func_177967_a(this.getFacing(), -1), this.getFacing().func_176734_d()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private CapabilityReference<IItemHandler> slagOut = CapabilityReference.forTileEntity(this, () -> new DirectionalBlockPos(this.getBlockPosForPos(SLAG_OUT_POS).func_177972_a(this.getFacing()), this.getFacing().func_176734_d()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> COLLISION_SHAPES;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES;
    private LazyOptional<IItemHandler> inputHandler = this.registerConstantCap(new IEInventoryHandler(12, this, 0, true, false){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return stack;
            }
            stack = stack.func_77946_l();
            ArrayList<Integer> possibleSlots = new ArrayList<Integer>(12);
            for (int i = 0; i < 12; ++i) {
                ItemStack here = (ItemStack)ArcFurnaceTileEntity.this.inventory.get(i);
                if (here.func_190926_b()) {
                    if (!simulate) {
                        ArcFurnaceTileEntity.this.inventory.set(i, (Object)stack);
                    }
                    return ItemStack.field_190927_a;
                }
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)here) || here.func_190916_E() >= here.func_77976_d()) continue;
                possibleSlots.add(i);
            }
            possibleSlots.sort(Comparator.comparingInt(a -> ((ItemStack)ArcFurnaceTileEntity.this.inventory.get(a.intValue())).func_190916_E()));
            Iterator iterator = possibleSlots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ItemStack here = (ItemStack)ArcFurnaceTileEntity.this.inventory.get(i);
                int fillCount = Math.min(here.func_77976_d() - here.func_190916_E(), stack.func_190916_E());
                if (!simulate) {
                    here.func_190917_f(fillCount);
                }
                stack.func_190918_g(fillCount);
                if (!stack.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
            return stack;
        }
    });
    private LazyOptional<IItemHandler> additiveHandler = this.registerConstantCap(new IEInventoryHandler(4, (IIEInventory)this, 12, true, false));
    private LazyOptional<IItemHandler> outputHandler = this.registerConstantCap(new IEInventoryHandler(6, (IIEInventory)this, 16, false, true));
    private LazyOptional<IItemHandler> slagHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 22, false, true));
    private static final Set<BlockPos> specialGuiPositions;

    public ArcFurnaceTileEntity() {
        super(IEMultiblocks.ARC_FURNACE, 64000, true, (TileEntityType)IETileTypes.ARC_FURNACE.get());
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 26);
        } else {
            byte electrodeStatus = nbt.func_74771_c("electrodeStatus");
            for (int i = 0; i < 3; ++i) {
                boolean hasElectrodeClient;
                boolean hasElectrodeServer = (electrodeStatus & 1) != 0;
                int slot = 23 + i;
                boolean bl = hasElectrodeClient = !((ItemStack)this.inventory.get(slot)).func_190926_b();
                if (hasElectrodeServer && !hasElectrodeClient) {
                    this.inventory.set(slot, (Object)new ItemStack((IItemProvider)IEItems.Misc.graphiteElectrode));
                } else if (!hasElectrodeServer && hasElectrodeClient) {
                    this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                }
                electrodeStatus = (byte)(electrodeStatus >>> 1);
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
        } else {
            byte packed = 0;
            byte mask = 1;
            for (int i = 0; i < 3; ++i) {
                if (!((ItemStack)this.inventory.get(23 + i)).func_190926_b()) {
                    packed = (byte)(packed + mask);
                }
                mask = (byte)(mask * 2);
            }
            nbt.func_74774_a("electrodeStatus", packed);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.pouringMetal > 0) {
                --this.pouringMetal;
            }
            if (this.shouldRenderAsActive()) {
                for (int i = 0; i < 4; ++i) {
                    if (Utils.RAND.nextInt(6) == 0) {
                        ImmersiveEngineering.proxy.spawnSparkFX(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 - 0.25 * (double)this.getFacing().func_82601_c(), (double)this.func_174877_v().func_177956_o() + 2.9, (double)this.func_174877_v().func_177952_p() + 0.5 - 0.25 * (double)this.getFacing().func_82599_e(), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.025, Utils.RAND.nextDouble() * 0.05 - 0.025);
                    }
                    if (Utils.RAND.nextInt(6) == 0) {
                        ImmersiveEngineering.proxy.spawnSparkFX(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (this.getFacing() == Direction.EAST ? -0.25 : 0.25), (double)this.func_174877_v().func_177956_o() + 2.9, (double)this.func_174877_v().func_177952_p() + 0.5 + (this.getFacing() == Direction.SOUTH ? 0.25 : -0.25), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.025, Utils.RAND.nextDouble() * 0.05 - 0.025);
                    }
                    if (Utils.RAND.nextInt(6) != 0) continue;
                    ImmersiveEngineering.proxy.spawnSparkFX(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (this.getFacing() == Direction.WEST ? 0.25 : -0.25), (double)this.func_174877_v().func_177956_o() + 2.9, (double)this.func_174877_v().func_177952_p() + 0.5 + (this.getFacing() == Direction.NORTH ? -0.25 : 0.25), Utils.RAND.nextDouble() * 0.05 - 0.025, 0.025, Utils.RAND.nextDouble() * 0.05 - 0.025);
                }
            }
        } else if (!this.isRSDisabled() && this.energyStorage.getEnergyStored() > 0) {
            if (this.tickedProcesses > 0) {
                for (int i = 23; i < 26; ++i) {
                    if (!((ItemStack)this.inventory.get(i)).func_96631_a(1, Utils.RAND, null)) continue;
                    this.inventory.set(i, (Object)ItemStack.field_190927_a);
                }
            }
            if (this.processQueue.size() < this.getProcessQueueMaxLength()) {
                HashMap<Integer, Integer> usedInvSlots = new HashMap<Integer, Integer>();
                for (PoweredMultiblockTileEntity.MultiblockProcess process : this.processQueue) {
                    if (!(process instanceof PoweredMultiblockTileEntity.MultiblockProcessInMachine)) continue;
                    int[] inputSlots = ((PoweredMultiblockTileEntity.MultiblockProcessInMachine)process).getInputSlots();
                    int[] inputAmounts = ((PoweredMultiblockTileEntity.MultiblockProcessInMachine)process).getInputAmounts();
                    if (inputAmounts == null) continue;
                    for (int i = 0; i < inputSlots.length; ++i) {
                        if (inputAmounts[i] <= 0) continue;
                        if (usedInvSlots.containsKey(inputSlots[i])) {
                            usedInvSlots.put(inputSlots[i], (Integer)usedInvSlots.get(inputSlots[i]) + inputAmounts[i]);
                            continue;
                        }
                        usedInvSlots.put(inputSlots[i], inputAmounts[i]);
                    }
                }
                NonNullList additives = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
                for (int i = 0; i < 4; ++i) {
                    if (((ItemStack)this.inventory.get(12 + i)).func_190926_b()) continue;
                    additives.set(i, (Object)((ItemStack)this.inventory.get(12 + i)).func_77946_l());
                    if (!usedInvSlots.containsKey(12 + i)) continue;
                    ((ItemStack)additives.get(i)).func_190918_g(((Integer)usedInvSlots.get(12 + i)).intValue());
                }
                for (int slot = 0; slot < 12; ++slot) {
                    MultiblockProcessArcFurnace process;
                    ArcFurnaceRecipe recipe;
                    ItemStack stack;
                    if (usedInvSlots.containsKey(slot) || (stack = (ItemStack)this.getInventory().get(slot)).func_190926_b() || stack.func_190916_E() <= 0 || (recipe = ArcFurnaceRecipe.findRecipe(stack, (NonNullList<ItemStack>)additives)) == null || !this.addProcessToQueue(process = new MultiblockProcessArcFurnace(recipe, slot, 12, 13, 14, 15), true)) continue;
                    this.addProcessToQueue(process, false);
                    int[] consumedAdditives = recipe.getConsumedAdditives((NonNullList<ItemStack>)additives, true);
                    if (consumedAdditives == null) continue;
                    process.setInputAmounts(recipe.input.getCount(), consumedAdditives[0], consumedAdditives[1], consumedAdditives[2], consumedAdditives[3]);
                }
            }
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                if (this.output.isPresent()) {
                    for (int j : OUTPUT_SLOTS) {
                        if (((ItemStack)this.inventory.get(j)).func_190926_b()) continue;
                        ItemStack stack = Utils.copyStackWithAmount((ItemStack)this.inventory.get(j), 1);
                        if (!(stack = Utils.insertStackIntoInventory(this.output, stack, false)).func_190926_b()) continue;
                        ((ItemStack)this.inventory.get(j)).func_190918_g(1);
                        if (((ItemStack)this.inventory.get(j)).func_190916_E() > 0) continue;
                        this.inventory.set(j, (Object)ItemStack.field_190927_a);
                    }
                }
                if (!((ItemStack)this.inventory.get(22)).func_190926_b() && this.slagOut.isPresent()) {
                    int out = Math.min(((ItemStack)this.inventory.get(22)).func_190916_E(), 16);
                    ItemStack stack = Utils.copyStackWithAmount((ItemStack)this.inventory.get(22), out);
                    if (!(stack = Utils.insertStackIntoInventory(this.slagOut, stack, false)).func_190926_b()) {
                        out -= stack.func_190916_E();
                    }
                    ((ItemStack)this.inventory.get(22)).func_190918_g(out);
                    if (((ItemStack)this.inventory.get(22)).func_190916_E() <= 0) {
                        this.inventory.set(22, (Object)ItemStack.field_190927_a);
                    }
                }
            }
        }
    }

    @Override
    public boolean func_145842_c(int id, int type) {
        if (id == 0) {
            this.pouringMetal = type;
        }
        return super.func_145842_c(id, type);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - (this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 1)), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - (this.getFacing().func_176740_k() == Direction.Axis.X ? 2 : 1)), (double)(this.func_174877_v().func_177958_n() + (this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 2)), (double)(this.func_174877_v().func_177956_o() + 3), (double)(this.func_174877_v().func_177952_p() + (this.getFacing().func_176740_k() == Direction.Axis.X ? 3 : 2)));
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape(ISelectionContext ctx) {
        return CachedShapesWithTransform.get(COLLISION_SHAPES, this);
    }

    private static List<AxisAlignedBB> getCollisionShape(BlockPos posInMultiblock) {
        if (ImmutableSet.of((Object)new BlockPos(3, 0, 4), (Object)new BlockPos(1, 0, 4)).contains((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5625));
        }
        if (posInMultiblock.func_177956_o() == 0 && posInMultiblock.func_177952_p() > 0 && !posInMultiblock.equals((Object)new BlockPos(2, 0, 4))) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (new BlockPos(0, 1, 4).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        if (new MutableBoundingBox(1, 1, 1, 3, 1, 2).func_175898_b((Vec3i)posInMultiblock)) {
            AxisAlignedBB aabb = posInMultiblock.func_177958_n() == 2 ? new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0) : Utils.flipBox(false, posInMultiblock.func_177958_n() == 3, new AxisAlignedBB(0.125, 0.5, 0.125, 1.0, 1.0, 0.875));
            if (posInMultiblock.func_177952_p() == 2) {
                aabb = aabb.func_72317_d(0.0, 0.0, 0.875);
            }
            return ImmutableList.of((Object)aabb);
        }
        if (ImmutableSet.of((Object)new BlockPos(4, 1, 1), (Object)new BlockPos(0, 1, 1)).contains((Object)posInMultiblock)) {
            return Utils.flipBoxes(false, posInMultiblock.func_177958_n() == 4, new AxisAlignedBB(0.125, 0.125, 0.0, 0.375, 0.375, 1.0));
        }
        if (posInMultiblock.func_177952_p() == 0 && posInMultiblock.func_177956_o() == 1 && posInMultiblock.func_177958_n() >= 1 && posInMultiblock.func_177958_n() <= 3) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0));
        }
        if (new BlockPos(2, 3, 0).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625));
        }
        if (new BlockPos(2, 4, 0).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.9375, 1.0));
        }
        if (new BlockPos(2, 4, 1).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 0.9375, 1.0));
        }
        if (new BlockPos(2, 4, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 0.875));
        }
        if (ImmutableSet.of((Object)new BlockPos(3, 2, 4), (Object)new BlockPos(1, 2, 4), (Object)new BlockPos(3, 3, 0), (Object)new BlockPos(1, 3, 0), (Object)new BlockPos(3, 4, 0), (Object)new BlockPos(1, 4, 0), (Object[])new BlockPos[0]).contains((Object)posInMultiblock)) {
            return Utils.flipBoxes(false, posInMultiblock.func_177958_n() == 3, new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable ISelectionContext ctx) {
        return CachedShapesWithTransform.get(SHAPES, this);
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        if (new BlockPos(0, 0, 4).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AxisAlignedBB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875), (Object)new AxisAlignedBB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
        }
        if (posInMultiblock.func_177952_p() == 0 && posInMultiblock.func_177956_o() == 1 && posInMultiblock.func_177958_n() >= 1 && posInMultiblock.func_177958_n() <= 3) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), (Object)new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25));
        }
        if (posInMultiblock.func_177958_n() % 4 == 0 && posInMultiblock.func_177952_p() <= 2) {
            double maxX;
            ArrayList list = posInMultiblock.func_177956_o() == 0 ? Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)}) : new ArrayList(2);
            boolean flip = posInMultiblock.func_177958_n() == 4;
            double minX = !flip ? 0.5 : 0.0;
            double d = maxX = flip ? 0.5 : 1.0;
            if (posInMultiblock.func_177958_n() != 3) {
                list.add(new AxisAlignedBB(minX, posInMultiblock.func_177956_o() == 0 ? 0.5 : 0.0, 0.0, maxX, 1.0, 1.0));
            }
            if (posInMultiblock.func_177956_o() == 0) {
                int move = 4 - posInMultiblock.func_177952_p() - 2;
                minX = !flip ? 0.125 : 0.625;
                maxX = !flip ? 0.375 : 0.875;
                AxisAlignedBB aabb = new AxisAlignedBB(minX, 0.6875, -1.625, maxX, 0.9375, 0.625);
                aabb = aabb.func_72317_d(0.0, 0.0, (double)move);
                list.add(aabb);
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                aabb = new AxisAlignedBB(minX, 0.6875, 0.375, maxX, 0.9375, 0.625);
                aabb = aabb.func_72317_d(0.0, 0.0, (double)move);
                list.add(aabb);
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                aabb = new AxisAlignedBB(minX, 0.6875, -1.625, maxX, 0.9375, -1.375);
                aabb = aabb.func_72317_d(0.0, 0.0, (double)move);
                list.add(aabb);
            } else if (posInMultiblock.func_177956_o() == 1) {
                int move = 4 - posInMultiblock.func_177952_p() - 2;
                minX = !flip ? 0.125 : 0.625;
                maxX = !flip ? 0.375 : 0.875;
                AxisAlignedBB aabb = new AxisAlignedBB(minX, 0.125, -1.625, maxX, 0.375, 0.625);
                aabb = aabb.func_72317_d(0.0, 0.0, (double)move);
                list.add(aabb);
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                aabb = new AxisAlignedBB(minX, 0.125, 0.375, maxX, 0.375, 0.625);
                aabb = aabb.func_72317_d(0.0, 0.0, (double)move);
                if (posInMultiblock.func_177958_n() == 0) {
                    aabb = aabb.func_72317_d(0.0, 0.6875, 0.0);
                }
                list.add(aabb);
                if (posInMultiblock.func_177958_n() == 0) {
                    minX = !flip ? 0.125 : 0.625;
                    maxX = !flip ? 0.375 : 0.875;
                    aabb = new AxisAlignedBB(minX, 0.375, 0.375, maxX, 1.0625, 0.625);
                    aabb = aabb.func_72317_d(0.0, 0.0, (double)move);
                    list.add(aabb);
                }
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                aabb = new AxisAlignedBB(minX, 0.125, -1.625, maxX, 0.375, -1.375);
                aabb = aabb.func_72317_d(0.0, 0.0, (double)move);
                list.add(aabb);
            } else if (ImmutableSet.of((Object)new BlockPos(4, 2, 2), (Object)new BlockPos(0, 2, 2)).contains((Object)posInMultiblock)) {
                minX = !flip ? 0.375 : 0.5;
                maxX = !flip ? 0.5 : 0.625;
                list.add(new AxisAlignedBB(minX, 0.25, 0.25, maxX, 0.75, 0.75));
            }
            return list;
        }
        return ArcFurnaceTileEntity.getCollisionShape(posInMultiblock);
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(1, 1, 0), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(3, 1, 0));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 4));
    }

    @Override
    public int getComparatorInputOverride() {
        ArcFurnaceTileEntity master;
        if (new BlockPos(2, 4, 2).equals((Object)this.posInMultiblock) && (master = (ArcFurnaceTileEntity)this.master()) != null) {
            float f = 0.0f;
            for (int i = 23; i < 26; ++i) {
                if (((ItemStack)master.inventory.get(i)).func_190926_b()) continue;
                f += 1.0f - (float)((ItemStack)master.inventory.get(i)).func_77952_i() / (float)((ItemStack)master.inventory.get(i)).func_77958_k();
            }
            return MathHelper.func_76141_d((float)(Math.max(f / 3.0f, 0.0f) * 15.0f));
        }
        return super.getComparatorInputOverride();
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean shouldRenderAsActive() {
        return this.hasElectrodes() && super.shouldRenderAsActive();
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<ArcFurnaceRecipe> process) {
        if (!this.hasElectrodes()) {
            return false;
        }
        if (process.recipe != null && !((ArcFurnaceRecipe)process.recipe).slag.func_190926_b()) {
            if (((ItemStack)this.inventory.get(22)).func_190926_b()) {
                return true;
            }
            return ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(22)), (ItemStack)((ArcFurnaceRecipe)process.recipe).slag) && ((ItemStack)this.inventory.get(22)).func_190916_E() + ((ArcFurnaceRecipe)process.recipe).slag.func_190916_E() <= this.getSlotLimit(22);
        }
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output, output, false)).func_190926_b()) {
            BlockPos pos = this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(this.getFacing(), -2);
            Utils.dropStackAtPos(this.field_145850_b, pos, output, this.getFacing());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<ArcFurnaceRecipe> process) {
        if (!((ArcFurnaceRecipe)process.recipe).slag.func_190926_b()) {
            if (((ItemStack)this.inventory.get(22)).func_190926_b()) {
                this.inventory.set(22, (Object)((ArcFurnaceRecipe)process.recipe).slag.func_77946_l());
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(22)), (ItemStack)((ArcFurnaceRecipe)process.recipe).slag) || ((ItemStack)this.inventory.get(22)).func_190916_E() + ((ArcFurnaceRecipe)process.recipe).slag.func_190916_E() > this.getSlotLimit(22)) {
                ((ItemStack)this.inventory.get(22)).func_190917_f(((ArcFurnaceRecipe)process.recipe).slag.func_190916_E());
            }
        }
    }

    @Override
    public int getMaxProcessPerTick() {
        return 12;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 12;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<ArcFurnaceRecipe> process) {
        return 0.0f;
    }

    @Override
    public int getComparatedSize() {
        return 12;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot > 22 ? 1 : 64;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            ArcFurnaceTileEntity master = (ArcFurnaceTileEntity)this.master();
            if (master == null) {
                return LazyOptional.empty();
            }
            if (this.posInMultiblock == MAIN_OUT_POS) {
                return master.outputHandler.cast();
            }
            if (this.posInMultiblock == SLAG_OUT_POS) {
                return master.slagHandler.cast();
            }
            if (new BlockPos(1, 3, 2).equals((Object)this.posInMultiblock)) {
                return master.inputHandler.cast();
            }
            if (new BlockPos(3, 3, 2).equals((Object)this.posInMultiblock)) {
                return master.additiveHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ArcFurnaceRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected ArcFurnaceRecipe getRecipeForId(ResourceLocation id) {
        return ArcFurnaceRecipe.recipeList.get(id);
    }

    @Override
    @Nullable
    protected PoweredMultiblockTileEntity.MultiblockProcess<ArcFurnaceRecipe> loadProcessFromNBT(CompoundNBT tag) {
        String id = tag.func_74779_i("recipe");
        ArcFurnaceRecipe recipe = this.getRecipeForId(new ResourceLocation(id));
        if (recipe != null) {
            MultiblockProcessArcFurnace process = new MultiblockProcessArcFurnace(recipe, tag.func_74759_k("process_inputSlots"));
            if (tag.func_150297_b("process_inputAmounts", 11)) {
                process.setInputAmounts(tag.func_74759_k("process_inputAmounts"));
            }
            return process;
        }
        return null;
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return this.formed && (specialGuiPositions.contains(this.posInMultiblock) || this.posInMultiblock.func_177956_o() > 0 && this.posInMultiblock.func_177958_n() > 0 && this.posInMultiblock.func_177958_n() < 4 && this.posInMultiblock.func_177952_p() == 4 || !this.isDummy());
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)((Object)this.master());
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return false;
    }

    public boolean hasElectrodes() {
        for (int i = 23; i < 26; ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            ArcFurnaceTileEntity.OUTPUT_SLOTS[i] = 16 + i;
        }
        COLLISION_SHAPES = CachedShapesWithTransform.createForMultiblock(ArcFurnaceTileEntity::getCollisionShape);
        SHAPES = CachedShapesWithTransform.createForMultiblock(ArcFurnaceTileEntity::getShape);
        specialGuiPositions = ImmutableSet.of((Object)new BlockPos(2, 0, 4), (Object)new BlockPos(0, 1, 4));
    }

    public static class MultiblockProcessArcFurnace
    extends PoweredMultiblockTileEntity.MultiblockProcessInMachine<ArcFurnaceRecipe> {
        public MultiblockProcessArcFurnace(ArcFurnaceRecipe recipe, int ... inputSlots) {
            super(recipe, inputSlots);
        }

        protected NonNullList<ItemStack> getRecipeItemOutputs(PoweredMultiblockTileEntity<?, ArcFurnaceRecipe> multiblock) {
            ItemStack input = (ItemStack)multiblock.getInventory().get(this.inputSlots[0]);
            NonNullList additives = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < 4; ++i) {
                additives.set(i, (Object)(!((ItemStack)multiblock.getInventory().get(12 + i)).func_190926_b() ? ((ItemStack)multiblock.getInventory().get(12 + i)).func_77946_l() : ItemStack.field_190927_a));
            }
            return ((ArcFurnaceRecipe)this.recipe).getOutputs(input, (NonNullList<ItemStack>)additives);
        }

        @Override
        protected void processFinish(PoweredMultiblockTileEntity<?, ArcFurnaceRecipe> te) {
            super.processFinish(te);
            te.getWorldNonnull().func_175641_c(te.func_174877_v(), te.func_195044_w().func_177230_c(), 0, 40);
        }
    }
}

