/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChuteTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IAdvancedHasObjProperty,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds {
    private static final String NBT_POS = "immersiveengineering:chutePos";
    private static final String NBT_TIME = "immersiveengineering:chuteTime";
    private static final String NBT_GLITCH = "immersiveengineering:chuteGlitched";
    private boolean diagonal = false;
    static final Map<Direction, AxisAlignedBB> AABB_SIDES = new EnumMap<Direction, AxisAlignedBB>(Direction.class);
    static final AxisAlignedBB AABB_DOWN;
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES;
    static final VoxelShape selectionShape;
    public static HashMap<String, IEProperties.IEObjState> cachedOBJStates;

    public ChuteTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.CHUTE.get()));
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return !entity.func_225608_bj_();
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        boolean contact = false;
        Direction facing = this.getFacing();
        if (!this.diagonal) {
            contact = entity.func_226278_cu_() - (double)this.func_174877_v().func_177956_o() <= 0.125;
        } else if (facing == Direction.NORTH) {
            contact = entity.func_226281_cx_() - (double)this.func_174877_v().func_177952_p() <= 0.125;
        } else if (facing == Direction.SOUTH) {
            contact = entity.func_226281_cx_() - (double)this.func_174877_v().func_177952_p() >= 0.875;
        } else if (facing == Direction.WEST) {
            contact = entity.func_226277_ct_() - (double)this.func_174877_v().func_177958_n() <= 0.125;
        } else if (facing == Direction.EAST) {
            boolean bl = contact = entity.func_226277_ct_() - (double)this.func_174877_v().func_177958_n() >= 0.875;
        }
        if (this.diagonal && entity.func_226278_cu_() - (double)this.func_174877_v().func_177956_o() <= 0.625) {
            boolean glitched;
            boolean opposedChute;
            BlockPos target = this.func_174877_v().func_177972_a(facing);
            TileEntity targetTile = world.func_175625_s(target);
            boolean bl = opposedChute = targetTile instanceof ChuteTileEntity && ((ChuteTileEntity)targetTile).diagonal;
            if (opposedChute) {
                return;
            }
            long time = world.func_82737_E();
            long nbt_pos = this.func_174877_v().func_218275_a();
            boolean prevent = entity.getPersistentData().func_74764_b(NBT_POS) && nbt_pos == entity.getPersistentData().func_74763_f(NBT_POS) && time - entity.getPersistentData().func_74763_f(NBT_TIME) < 20L;
            boolean bl2 = glitched = entity.getPersistentData().func_74764_b(NBT_GLITCH) && time - entity.getPersistentData().func_74763_f(NBT_GLITCH) < 1200L;
            if ((double)entity.func_213311_cf() > 0.75 || (double)entity.func_213302_cg() > 0.75) {
                if (world.func_180495_p(target).func_215696_m((IBlockReader)world, target)) {
                    return;
                }
                if (!glitched) {
                    Vec3d oldPos = entity.func_213303_ch();
                    double py = entity.func_213302_cg() > 1.0f ? (double)this.func_174877_v().func_177956_o() + 0.125 : entity.func_226278_cu_();
                    entity.func_70107_b((double)target.func_177958_n() + 0.5, py, (double)target.func_177952_p() + 0.5);
                    if (entity.func_70094_T()) {
                        entity.func_70107_b(oldPos.field_72450_a, oldPos.field_72448_b, oldPos.field_72449_c);
                        entity.getPersistentData().func_74772_a(NBT_GLITCH, time);
                    }
                }
            } else {
                double mY = entity.func_213322_ci().field_72448_b;
                if (mY == 0.0) {
                    mY = 0.015;
                }
                entity.func_213293_j((double)facing.func_82601_c(), mY, (double)facing.func_82599_e());
            }
            if (!(contact || prevent || glitched)) {
                world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), IESounds.chute, SoundCategory.BLOCKS, 0.6f + 0.4f * world.field_73012_v.nextFloat(), 0.5f + 0.5f * world.field_73012_v.nextFloat());
                entity.getPersistentData().func_74772_a(NBT_POS, nbt_pos);
                entity.getPersistentData().func_74772_a(NBT_TIME, time);
            }
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            itemEntity.func_174867_a(10);
            if (!contact) {
                if (itemEntity.field_70292_b > itemEntity.lifespan - 1200) {
                    itemEntity.field_70292_b = itemEntity.lifespan - 1200;
                }
            } else {
                BlockPos invPos = this.diagonal ? this.func_174877_v().func_177972_a(facing) : this.func_174877_v().func_177977_b();
                TileEntity inventoryTile = world.func_175625_s(invPos);
                if (!world.field_72995_K && inventoryTile != null && !(inventoryTile instanceof ConveyorHandler.IConveyorTile)) {
                    LazyOptional<IItemHandler> cap = ApiUtils.findItemHandlerAtPos(world, invPos, this.getFacing().func_176734_d(), true);
                    cap.ifPresent(itemHandler -> {
                        ItemStack stack = itemEntity.func_92059_d();
                        ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack.func_77946_l(), (boolean)true);
                        if (temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E()) {
                            temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                            if (temp.func_190926_b()) {
                                itemEntity.func_70106_y();
                            } else if (temp.func_190916_E() < stack.func_190916_E()) {
                                itemEntity.func_92058_a(temp);
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.diagonal = nbt.func_74767_n("diagonal");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74757_a("diagonal", this.diagonal);
    }

    @Override
    public VoxelShape getCollisionShape(ISelectionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(this));
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable ISelectionContext ctx) {
        return selectionShape;
    }

    @Override
    public IEProperties.IEObjState getIEObjState(BlockState state) {
        String key = this.getRenderCacheKey();
        return ChuteTileEntity.getStateFromKey(key);
    }

    private String getRenderCacheKey() {
        if (this.diagonal) {
            return "diagonal:" + this.getFacing().name();
        }
        String s = "base";
        for (Direction dir : Direction.field_176754_o) {
            if (this.isInwardConveyor(dir)) continue;
            s = s + ":" + dir.name().toLowerCase();
        }
        return s;
    }

    public static IEProperties.IEObjState getStateFromKey(String key) {
        if (!cachedOBJStates.containsKey(key)) {
            String[] split = key.split(":");
            if ("diagonal".equals(split[0])) {
                Direction dir = Direction.valueOf((String)split[1]).func_176734_d();
                Matrix4f matrix = new Matrix4(dir).toMatrix4f();
                cachedOBJStates.put(key, new IEProperties.IEObjState(IEProperties.VisibilityList.show("diagonal"), new TransformationMatrix(matrix)));
            } else {
                cachedOBJStates.put(key, new IEProperties.IEObjState(IEProperties.VisibilityList.show(split)));
            }
        }
        return cachedOBJStates.get(key);
    }

    protected boolean isInwardConveyor(Direction f) {
        ConveyorHandler.IConveyorBelt sub;
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
        if (te instanceof ConveyorHandler.IConveyorTile) {
            sub = ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype();
            if (sub != null) {
                for (Direction f2 : sub.sigTransportDirections()) {
                    if (f != f2.func_176734_d()) continue;
                    return true;
                }
            }
        } else if (te instanceof ChuteTileEntity) {
            return ((ChuteTileEntity)te).diagonal && ((ChuteTileEntity)te).getFacing() == f.func_176734_d();
        }
        if ((te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -1, 0).func_177972_a(f))) instanceof ConveyorHandler.IConveyorTile && (sub = ((ConveyorHandler.IConveyorTile)te).getConveyorSubtype()) != null) {
            int b = 0;
            for (Direction f2 : sub.sigTransportDirections()) {
                if (f == f2.func_176734_d()) {
                    ++b;
                } else if (Direction.UP == f2) {
                    ++b;
                }
                if (b != 2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Hand hand, Vec3d hitVec) {
        if (player.func_225608_bj_()) {
            if (!this.field_145850_b.field_72995_K) {
                this.diagonal = !this.diagonal;
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    static {
        AABB_SIDES.put(Direction.NORTH, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
        AABB_SIDES.put(Direction.SOUTH, new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
        AABB_SIDES.put(Direction.WEST, new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
        AABB_SIDES.put(Direction.EAST, new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
        AABB_DOWN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        SHAPES = new CachedVoxelShapes<BoundingBoxKey>(rec$ -> ((BoundingBoxKey)rec$).getBoxes());
        selectionShape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        cachedOBJStates = new HashMap();
    }

    private static class BoundingBoxKey {
        private final boolean diagonal;
        private final Set<Direction> sidesToAdd;

        private BoundingBoxKey(ChuteTileEntity te) {
            this.diagonal = te.diagonal;
            this.sidesToAdd = EnumSet.noneOf(Direction.class);
            for (Direction dir : Direction.field_176754_o) {
                if (te.isInwardConveyor(dir) || this.diagonal && dir == te.getFacing()) continue;
                this.sidesToAdd.add(dir);
            }
        }

        private List<AxisAlignedBB> getBoxes() {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            for (Direction d : this.sidesToAdd) {
                list.add(AABB_SIDES.get(d));
            }
            for (Direction sideA : Direction.field_176754_o) {
                Direction sideB = sideA.func_176746_e();
                if (this.sidesToAdd.contains(sideA) || this.sidesToAdd.contains(sideB)) continue;
                AxisAlignedBB boxA = AABB_SIDES.get(sideA);
                AxisAlignedBB boxB = AABB_SIDES.get(sideB);
                list.add(boxA.func_191500_a(boxB));
            }
            if (this.diagonal) {
                list.add(AABB_DOWN);
            }
            return list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxKey that = (BoundingBoxKey)o;
            return this.diagonal == that.diagonal && this.sidesToAdd.equals(that.sidesToAdd);
        }

        public int hashCode() {
            return Objects.hash(this.diagonal, this.sidesToAdd);
        }
    }
}

