/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.dimension.DimensionType;

public class ElectricLanternTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.ISpawnInterdiction,
ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
EnergyTransferHandler.EnergyConnector {
    public int energyStorage = 0;
    private int energyDraw;
    private int maximumStorage;
    private boolean interdictionList;

    public ElectricLanternTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)IETileTypes.ELECTRIC_LANTERN.get()));
        this.energyDraw = (Integer)IEConfig.MACHINES.lantern_energyDraw.get();
        this.maximumStorage = (Integer)IEConfig.MACHINES.lantern_maximumStorage.get();
        this.interdictionList = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.interdictionList && ((Boolean)IEConfig.MACHINES.lantern_spawnPrevent.get()).booleanValue()) {
            Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = EventHandler.interdictionTiles;
            synchronized (map) {
                Set tileForDim = EventHandler.interdictionTiles.computeIfAbsent(this.field_145850_b.func_201675_m().func_186058_p(), k -> new HashSet());
                tileForDim.add(this);
            }
            this.interdictionList = true;
        }
        boolean activeBeforeTick = this.getIsActive();
        if (this.energyStorage >= this.energyDraw) {
            this.energyStorage -= this.energyDraw;
            if (!activeBeforeTick) {
                this.setActive(true);
            }
        } else if (activeBeforeTick) {
            this.setActive(false);
        }
        if (this.getIsActive() != activeBeforeTick) {
            this.checkLight();
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.getIsActive() ? 1024.0 : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_145843_s() {
        Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = EventHandler.interdictionTiles;
        synchronized (map) {
            EventHandler.interdictionTiles.remove(this);
        }
        super.func_145843_s();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChunkUnloaded() {
        Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = EventHandler.interdictionTiles;
        synchronized (map) {
            EventHandler.interdictionTiles.remove(this);
        }
        super.onChunkUnloaded();
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage = nbt.func_74762_e("energyStorage");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("energyStorage", this.energyStorage);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 1) {
            this.markContainingBlockForUpdate(null);
            this.checkLight();
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "LV".equals(cableType.getCategory());
    }

    @Override
    public Vec3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        boolean flipped;
        BlockPos other = con.getOtherEnd(here).getPosition();
        int xDif = other.func_177958_n() - this.field_174879_c.func_177958_n();
        int zDif = other.func_177952_p() - this.field_174879_c.func_177952_p();
        boolean bl = flipped = this.getFacing() == Direction.UP;
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return new Vec3d(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5), flipped ? 0.9375 : 0.0625, 0.5);
        }
        return new Vec3d(0.5, flipped ? 0.9375 : 0.0625, zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5));
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_TOP_DOWN;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.FIXED_DOWN;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Hand hand, Vec3d hitVec) {
        if (!this.field_145850_b.field_72995_K) {
            this.setFacing(this.getFacing().func_176734_d());
        }
        return true;
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return true;
    }

    @Override
    public int getRequestedEnergy() {
        return this.maximumStorage - this.energyStorage;
    }

    @Override
    public void insertEnergy(int amount) {
        this.energyStorage += amount;
    }
}

