/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.items.CapabilityItemHandler;

public class ToolboxTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction {
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)23, (Object)ItemStack.field_190927_a);
    public ITextComponent name;
    private ListNBT enchantments;
    private static final VoxelShape boundsZ = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.625, (double)0.75);
    private static final VoxelShape boundsX = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.625, (double)0.875);

    public ToolboxTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.TOOLBOX.get()));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        if (nbt.func_150297_b("name", 8)) {
            this.name = ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("name"));
        }
        if (nbt.func_150297_b("enchantments", 9)) {
            this.enchantments = nbt.func_150295_c("enchantments", 10);
        }
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 23);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        if (this.name != null) {
            nbt.func_74778_a("name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        if (this.enchantments != null) {
            nbt.func_218657_a("enchantments", (INBT)this.enchantments);
        }
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.func_225608_bj_()) {
            if (!this.field_145850_b.field_72995_K) {
                ItemEntity entityitem = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.getPickBlock(player, this.func_195044_w(), (RayTraceResult)new BlockRayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, this.field_174879_c, false)));
                entityitem.func_174869_p();
                this.field_145850_b.func_217377_a(this.func_174877_v(), false);
                this.field_145850_b.func_217376_c((Entity)entityitem);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        ItemStack stack = new ItemStack((IItemProvider)IEItems.Tools.toolbox);
        ((InternalStorageItem)IEItems.Tools.toolbox).setContainedItems(stack, this.inventory);
        if (this.name != null) {
            stack.func_200302_a(this.name);
        }
        if (this.enchantments != null) {
            stack.func_196082_o().func_218657_a("ench", (INBT)this.enchantments);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.func_77973_b() instanceof InternalStorageItem) {
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(inv -> {
                this.inventory = NonNullList.func_191197_a((int)inv.getSlots(), (Object)ItemStack.field_190927_a);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.inventory.set(i, (Object)inv.getStackInSlot(i));
                }
            });
            if (stack.func_82837_s()) {
                this.name = stack.func_200301_q();
            }
            this.enchantments = stack.func_77986_q();
        }
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return this.getFacing().func_176740_k() == Direction.Axis.Z ? boundsZ : boundsX;
    }
}

