/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TransformerHVTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class TransformerTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IMirrorAble,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IModelOffsetProvider {
    private static final int RIGHT_INDEX = 0;
    private static final int LEFT_INDEX = 1;
    private WireType leftType;
    private WireType rightType;
    public int dummy = 0;
    protected Set<String> acceptableLowerWires = ImmutableSet.of((Object)"LV");
    boolean cachedMirrored = false;
    private VoxelShape shape = null;

    public TransformerTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)IETileTypes.TRANSFORMER.get()));
    }

    public TransformerTileEntity(TileEntityType<? extends TransformerTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.leftType != null) {
            nbt.func_74778_a("leftType", this.leftType.getUniqueName());
        }
        if (this.rightType != null) {
            nbt.func_74778_a("rightType", this.rightType.getUniqueName());
        }
        nbt.func_74768_a("dummy", this.dummy);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.leftType = nbt.func_74764_b("leftType") ? WireUtils.getWireTypeFromNBT(nbt, "leftType") : null;
        this.rightType = nbt.func_74764_b("rightType") ? WireUtils.getWireTypeFromNBT(nbt, "rightType") : null;
        this.dummy = nbt.func_74762_e("dummy");
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v().func_177982_a(0, -this.dummy, 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if (this.dummy == 2) {
            TileEntity master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0));
            return master instanceof TransformerTileEntity && ((TransformerTileEntity)master).canConnectCable(cableType, target, new Vec3i(0, 2, 0));
        }
        switch (target.getIndex()) {
            case 1: {
                return this.canAttach(cableType, this.leftType, this.rightType);
            }
            case 0: {
                return this.canAttach(cableType, this.rightType, this.leftType);
            }
        }
        return false;
    }

    private boolean canAttach(WireType toAttach, @Nullable WireType atConn, @Nullable WireType other) {
        boolean isOtherHigher;
        if (atConn != null) {
            return false;
        }
        String higherCat = this.getHigherWiretype();
        String attachCat = toAttach.getCategory();
        if (other == null) {
            return higherCat.equals(attachCat) || this.acceptableLowerWires.contains(attachCat);
        }
        boolean isHigher = higherCat.equals(toAttach.getCategory());
        if (isHigher ^ (isOtherHigher = higherCat.equals(other.getCategory()))) {
            if (isHigher) {
                return true;
            }
            return this.acceptableLowerWires.contains(attachCat);
        }
        return false;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        if (this.dummy != 0) {
            TileEntity master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0));
            if (master instanceof TransformerTileEntity) {
                ((TransformerTileEntity)master).connectCable(cableType, target, other, otherTarget);
            }
            return;
        }
        switch (target.getIndex()) {
            case 1: {
                this.leftType = cableType;
                break;
            }
            case 0: {
                this.rightType = cableType;
            }
        }
        this.updateMirrorState();
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        WireType type;
        WireType wireType = type = connection != null ? connection.type : null;
        if (type == null) {
            this.rightType = null;
            this.leftType = null;
        } else {
            switch (attachedPoint.getIndex()) {
                case 1: {
                    this.leftType = null;
                    break;
                }
                case 0: {
                    this.rightType = null;
                }
            }
        }
        this.updateMirrorState();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public Vec3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        return this.getConnectionOffset(con, con.getEndFor(this.field_174879_c).getIndex() == 0);
    }

    private Vec3d getConnectionOffset(Connection con, boolean right) {
        double offset;
        double conRadius = con.type.getRenderDiameter() / 2.0;
        double d = offset = this.getHigherWiretype().equals(con.type.getCategory()) ? (double)this.getHigherOffset() : (double)this.getLowerOffset();
        if (this.getFacing() == Direction.NORTH) {
            return new Vec3d(right ? 0.8125 : 0.1875, 2.0 + offset - conRadius, 0.5);
        }
        if (this.getFacing() == Direction.SOUTH) {
            return new Vec3d(right ? 0.1875 : 0.8125, 2.0 + offset - conRadius, 0.5);
        }
        if (this.getFacing() == Direction.WEST) {
            return new Vec3d(0.5, 2.0 + offset - conRadius, right ? 0.1875 : 0.8125);
        }
        if (this.getFacing() == Direction.EAST) {
            return new Vec3d(0.5, 2.0 + offset - conRadius, right ? 0.8125 : 0.1875);
        }
        return new Vec3d(0.5, 0.5, 0.5);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo target, Vec3i offset) {
        if (offset.func_177956_o() != 2) {
            return null;
        }
        if (this.getFacing() == Direction.NORTH) {
            if ((double)target.hitX < 0.5) {
                return new ConnectionPoint(this.field_174879_c, 1);
            }
            return new ConnectionPoint(this.field_174879_c, 0);
        }
        if (this.getFacing() == Direction.SOUTH) {
            if ((double)target.hitX < 0.5) {
                return new ConnectionPoint(this.field_174879_c, 0);
            }
            return new ConnectionPoint(this.field_174879_c, 1);
        }
        if (this.getFacing() == Direction.WEST) {
            if ((double)target.hitZ < 0.5) {
                return new ConnectionPoint(this.field_174879_c, 0);
            }
            return new ConnectionPoint(this.field_174879_c, 1);
        }
        if (this.getFacing() == Direction.EAST) {
            if ((double)target.hitZ < 0.5) {
                return new ConnectionPoint(this.field_174879_c, 1);
            }
            return new ConnectionPoint(this.field_174879_c, 0);
        }
        return null;
    }

    private void updateMirrorState() {
        if (this.dummy != 0) {
            TileEntity master = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(this.dummy));
            if (master instanceof TransformerTileEntity) {
                ((TransformerTileEntity)master).updateMirrorState();
            }
        } else if (this.rightType != null || this.leftType != null) {
            String higher = this.getHigherWiretype();
            boolean intendedState = this.rightType != null && higher.equals(this.rightType.getCategory()) || this.leftType != null && !higher.equals(this.leftType.getCategory());
            for (int i = 0; i < 3; ++i) {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i));
                if (!(te instanceof TransformerTileEntity)) continue;
                ((TransformerTileEntity)te).setMirrored(intendedState);
            }
        }
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.func_174877_v().func_177979_c(this.dummy);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        state = (BlockState)state.func_206870_a((IProperty)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        int i = 1;
        while (i <= 2) {
            BlockPos dummyPos = this.field_174879_c.func_177981_b(i);
            this.field_145850_b.func_175656_a(dummyPos, IEBaseBlock.applyLocationalWaterlogging(state, this.field_145850_b, dummyPos));
            ((TransformerTileEntity)this.field_145850_b.func_175625_s((BlockPos)dummyPos)).dummy = i++;
            ((TransformerTileEntity)this.field_145850_b.func_175625_s(dummyPos)).setFacing(this.getFacing());
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 2; ++i) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0), false);
        }
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape(ISelectionContext ctx) {
        if (this.dummy == 2) {
            return VoxelShapes.func_197873_a((double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0.0 : 0.3125), (double)0.0, (double)(this.getFacing().func_176740_k() == Direction.Axis.X ? 0.0 : 0.3125), (double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? 1.0 : 0.6875), (double)(this instanceof TransformerHVTileEntity ? 0.75 : 0.5625), (double)(this.getFacing().func_176740_k() == Direction.Axis.X ? 1.0 : 0.6875));
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable ISelectionContext ctx) {
        boolean mirrored = this.getIsMirrored();
        if (this.dummy == 2 && (this.shape == null || this.cachedMirrored != mirrored)) {
            double offsetB;
            double offsetA = mirrored ? (double)this.getHigherOffset() : (double)this.getLowerOffset();
            double d = offsetB = mirrored ? (double)this.getLowerOffset() : (double)this.getHigherOffset();
            if (this.getFacing() == Direction.NORTH) {
                this.shape = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.3125, (double)0.375, (double)offsetB, (double)0.6875), (VoxelShape)VoxelShapes.func_197873_a((double)0.625, (double)0.0, (double)0.3125, (double)1.0, (double)offsetA, (double)0.6875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (this.getFacing() == Direction.SOUTH) {
                this.shape = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.3125, (double)0.375, (double)offsetA, (double)0.6875), (VoxelShape)VoxelShapes.func_197873_a((double)0.625, (double)0.0, (double)0.3125, (double)1.0, (double)offsetB, (double)0.6875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (this.getFacing() == Direction.WEST) {
                this.shape = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.0, (double)0.6875, (double)offsetA, (double)0.375), (VoxelShape)VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.625, (double)0.6875, (double)offsetB, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (this.getFacing() == Direction.EAST) {
                this.shape = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.0, (double)0.6875, (double)offsetB, (double)0.375), (VoxelShape)VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.625, (double)0.6875, (double)offsetA, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            this.cachedMirrored = mirrored;
        } else if (this.dummy != 2) {
            this.shape = VoxelShapes.func_197868_b();
        }
        return this.shape;
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)this.field_174879_c.func_177981_b(2));
    }

    protected float getLowerOffset() {
        return 0.5f;
    }

    protected float getHigherOffset() {
        return 0.5625f;
    }

    public String getHigherWiretype() {
        return "MV";
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        if (this.isDummy()) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)new ConnectionPoint(this.field_174879_c, 0), (Object)new ConnectionPoint(this.field_174879_c, 1));
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        if (this.isDummy()) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)new Connection(this.field_174879_c, 1, 0));
    }

    @Override
    public BlockPos getModelOffset(BlockState state) {
        return new BlockPos(0, this.dummy, 0);
    }
}

