/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;

public class StaticTemplateManager {
    public static Optional<InputStream> getModResource(ResourcePackType type, ResourceLocation name) {
        if (IEDataGenerator.EXISTING_HELPER != null) {
            try {
                int slash = name.func_110623_a().indexOf(47);
                String prefix = name.func_110623_a().substring(0, slash);
                ResourceLocation shortLoc = new ResourceLocation(name.func_110624_b(), name.func_110623_a().substring(slash + 1));
                return Optional.of(IEDataGenerator.EXISTING_HELPER.getResource(shortLoc, type, "", prefix).func_199027_b());
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return ModList.get().getMods().stream().map(ModInfo::getModId).map(ResourcePackLoader::getResourcePackFor).filter(Optional::isPresent).map(Optional::get).filter(mfrp -> mfrp.func_195764_b(type, name)).map(mfrp -> StaticTemplateManager.getInputStreamOrThrow(type, name, mfrp)).findAny();
    }

    private static InputStream getInputStreamOrThrow(ResourcePackType type, ResourceLocation name, ModFileResourcePack source) {
        try {
            return source.func_195761_a(type, name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Template loadStaticTemplate(ResourceLocation loc) throws IOException {
        String path = "structures/" + loc.func_110623_a() + ".nbt";
        Optional<InputStream> optStream = StaticTemplateManager.getModResource(ResourcePackType.SERVER_DATA, new ResourceLocation(loc.func_110624_b(), path));
        if (optStream.isPresent()) {
            return StaticTemplateManager.loadTemplate(optStream.get());
        }
        throw new RuntimeException("Mod resource not found: " + loc);
    }

    public static Template loadTemplate(InputStream inputStreamIn) throws IOException {
        CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a((InputStream)inputStreamIn);
        Template template = new Template();
        template.func_186256_b(compoundnbt);
        return template;
    }
}

