/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.plant;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.plant.EnumHempGrowth;
import blusunrize.immersiveengineering.common.items.IEItems;
import java.util.EnumMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.PlantType;

public class HempBlock
extends BushBlock
implements IGrowable {
    public final String name;
    public static final EnumProperty<EnumHempGrowth> GROWTH = EnumProperty.func_177709_a((String)"growth", EnumHempGrowth.class);
    private static final EnumMap<EnumHempGrowth, VoxelShape> shapes = new EnumMap(EnumHempGrowth.class);

    public HempBlock(String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_222472_s).func_200942_a().func_200943_b(0.0f).func_200944_c());
        this.name = name;
        this.setRegistryName("immersiveengineering", name);
        IEContent.registeredIEBlocks.add((Block)this);
        IEContent.registeredIEItems.add((Item)new BlockItemIE((Block)this));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{GROWTH});
    }

    public EnumHempGrowth getMinGrowth(EnumHempGrowth current) {
        if (current == EnumHempGrowth.TOP0) {
            return EnumHempGrowth.TOP0;
        }
        return EnumHempGrowth.BOTTOM0;
    }

    public static EnumHempGrowth getMaxGrowth(EnumHempGrowth current) {
        if (current == EnumHempGrowth.TOP0) {
            return EnumHempGrowth.TOP0;
        }
        return EnumHempGrowth.BOTTOM4;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        boolean b = super.func_196260_a(state, world, pos);
        if (state.func_177229_b(GROWTH) == EnumHempGrowth.TOP0) {
            BlockState stateBelow = world.func_180495_p(pos.func_177977_b());
            b = stateBelow.func_177230_c().equals((Object)this) && stateBelow.func_177229_b(GROWTH) == HempBlock.getMaxGrowth(EnumHempGrowth.BOTTOM0);
        }
        return b;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.Crop;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shapes.getOrDefault(state.func_177229_b(GROWTH), VoxelShapes.func_197868_b());
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world.func_180495_p(pos).func_177229_b(GROWTH) != EnumHempGrowth.TOP0 && world instanceof World) {
            ((World)world).func_195593_d(pos.func_177982_a(0, 1, 0), (Block)this);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int light = world.func_201696_r(pos);
        if (light >= 12) {
            EnumHempGrowth growth = (EnumHempGrowth)((Object)state.func_177229_b(GROWTH));
            if (growth == EnumHempGrowth.TOP0) {
                return;
            }
            float speed = this.getGrowthSpeed((World)world, pos, state, light);
            if (random.nextInt((int)(50.0f / speed) + 1) == 0) {
                if (HempBlock.getMaxGrowth(growth) != growth) {
                    world.func_175656_a(pos, (BlockState)state.func_206870_a(GROWTH, (Comparable)((Object)growth.next())));
                }
                if (growth == HempBlock.getMaxGrowth(growth) && world.func_175623_d(pos.func_177982_a(0, 1, 0))) {
                    world.func_175656_a(pos.func_177982_a(0, 1, 0), (BlockState)state.func_206870_a(GROWTH, (Comparable)((Object)EnumHempGrowth.TOP0)));
                }
            }
        }
    }

    private float getGrowthSpeed(World world, BlockPos pos, BlockState state, int light) {
        BlockState soil;
        float growth = 0.125f * (float)(light - 11);
        if (world.func_175710_j(pos)) {
            growth += 2.0f;
        }
        if ((soil = world.func_180495_p(pos.func_177982_a(0, -1, 0))).func_177230_c().isFertile(soil, (IBlockReader)world, pos.func_177982_a(0, -1, 0))) {
            growth *= 1.5f;
        }
        return 1.0f + growth;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        EnumHempGrowth growth = (EnumHempGrowth)((Object)state.func_177229_b(GROWTH));
        if (growth != HempBlock.getMaxGrowth(growth)) {
            return true;
        }
        return growth == EnumHempGrowth.BOTTOM4 && world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() != this;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return this.func_176473_a((IBlockReader)world, pos, world.func_180495_p(pos), world.field_72995_K);
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        EnumHempGrowth growth = (EnumHempGrowth)((Object)state.func_177229_b(GROWTH));
        if (growth != HempBlock.getMaxGrowth(growth)) {
            int span = HempBlock.getMaxGrowth(growth).ordinal() - growth.ordinal();
            EnumHempGrowth newGrowth = growth;
            int growBy = this.RANDOM.nextInt(span) + 1;
            for (int i = 0; i < growBy; ++i) {
                newGrowth = newGrowth.next();
            }
            world.func_175656_a(pos, (BlockState)state.func_206870_a(GROWTH, (Comparable)((Object)newGrowth)));
            growth = newGrowth;
        }
        if (growth == EnumHempGrowth.BOTTOM4 && world.func_175623_d(pos.func_177982_a(0, 1, 0))) {
            world.func_175656_a(pos.func_177982_a(0, 1, 0), (BlockState)state.func_206870_a(GROWTH, (Comparable)((Object)EnumHempGrowth.TOP0)));
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)IEItems.Misc.hempSeeds);
    }

    static {
        shapes.put(EnumHempGrowth.BOTTOM0, VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0)));
        shapes.put(EnumHempGrowth.BOTTOM1, VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)));
        shapes.put(EnumHempGrowth.BOTTOM2, VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)));
    }
}

