/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.loot.LootContext;

public class CoresampleTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IBlockBounds {
    public ItemStack coresample = ItemStack.field_190927_a;
    private String[] overlay = null;
    private static final VoxelShape AABB_CORESAMPLE_X = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.28125, (double)1.0, (double)1.0, (double)0.71875);
    private static final VoxelShape AABB_CORESAMPLE_Z = VoxelShapes.func_197873_a((double)0.28125, (double)0.0, (double)0.0, (double)0.71875, (double)1.0, (double)1.0);

    public CoresampleTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.CORE_SAMPLE.get()));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.coresample = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("coresample"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_218657_a("coresample", (INBT)this.coresample.func_77955_b(new CompoundNBT()));
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return true;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        ColumnPos coords = CoresampleItem.getCoords(this.coresample);
        if (player.func_225608_bj_()) {
            if (!this.field_145850_b.field_72995_K) {
                ItemEntity entityitem = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.coresample);
                entityitem.func_174869_p();
                this.field_145850_b.func_217377_a(this.field_174879_c, false);
                this.field_145850_b.func_217376_c((Entity)entityitem);
            }
            return true;
        }
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151098_aY && coords != null) {
            MapData mapData;
            if (!this.field_145850_b.field_72995_K && (mapData = FilledMapItem.func_195950_a((ItemStack)heldItem, (World)player.func_130014_f_())) != null) {
                if (mapData.field_76200_c != DimensionType.func_193417_a((ResourceLocation)CoresampleItem.getDimenson(this.coresample))) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.mapDimension", new Object[0]));
                    return true;
                }
                String ident = "ie:coresample_" + coords.toString();
                CompoundNBT mapTagCompound = heldItem.func_196082_o();
                ListNBT nbttaglist = mapTagCompound.func_150295_c("Decorations", 10);
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    CompoundNBT tagCompound = (CompoundNBT)nbttaglist.get(i);
                    if (!ident.equalsIgnoreCase(tagCompound.func_74779_i("id"))) continue;
                    nbttaglist.remove(i);
                    mapTagCompound.func_218657_a("Decorations", (INBT)nbttaglist);
                    mapData.field_76203_h.remove(ident);
                    return true;
                }
                double sampleX = (double)coords.field_219439_a + 0.5;
                double sampleZ = (double)coords.field_219440_b + 0.5;
                int mapScale = 1 << mapData.field_76197_d;
                float distX = (float)(sampleX - (double)mapData.field_76201_a) / (float)mapScale;
                float distZ = (float)(sampleZ - (double)mapData.field_76199_b) / (float)mapScale;
                if (distX >= -63.0f && distX <= 63.0f && distZ >= -63.0f && distZ <= 63.0f) {
                    CompoundNBT tagCompound = new CompoundNBT();
                    tagCompound.func_74778_a("id", ident);
                    tagCompound.func_74774_a("type", MapDecoration.Type.TARGET_POINT.func_191163_a());
                    tagCompound.func_74780_a("x", sampleX);
                    tagCompound.func_74780_a("z", sampleZ);
                    tagCompound.func_74780_a("rot", 180.0);
                    tagCompound.func_218657_a("minerals", (INBT)CoresampleItem.getSimplifiedMineralList(this.coresample));
                    nbttaglist.add((Object)tagCompound);
                    mapTagCompound.func_218657_a("Decorations", (INBT)nbttaglist);
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.mapFail", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        if (this.coresample.func_82837_s()) {
            return this.coresample.func_200301_q();
        }
        return new TranslationTextComponent("item.immersiveengineering.coresample.name", new Object[0]);
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        return ImmutableList.of((Object)this.coresample);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        this.coresample = stack.func_77946_l();
    }

    @Override
    public String[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (this.overlay == null) {
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
            CoresampleItem.getCoresampleInfo(this.coresample, list, TextFormatting.WHITE, this.field_145850_b, false, false);
            this.overlay = (String[])list.stream().map(ITextComponent::func_150254_d).toArray(String[]::new);
        }
        return this.overlay;
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return this.getFacing().func_176740_k() == Direction.Axis.Z ? AABB_CORESAMPLE_Z : AABB_CORESAMPLE_X;
    }
}

