/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WindmillTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IReadOnPlacement,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHasObjProperty,
IEBlockInterfaces.IBlockBounds {
    public float prevRotation = 0.0f;
    public float rotation = 0.0f;
    public float turnSpeed = 0.0f;
    public float perTick = 0.0f;
    public int sails = 0;
    public boolean canTurn = false;
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;
    private static final CachedVoxelShapes<Direction> SHAPES = new CachedVoxelShapes<Direction>(WindmillTileEntity::getShape);

    public WindmillTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.WINDMILL.get()));
    }

    public void func_73660_a() {
        TileEntity tileEntity;
        if (this.field_145850_b.func_82737_E() % 128L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x7F)) {
            this.canTurn = this.checkArea();
        }
        if (!this.canTurn) {
            return;
        }
        double mod = 5.0E-5;
        if (!this.field_145850_b.func_72896_J()) {
            mod *= 0.75;
        }
        if (!this.field_145850_b.func_72911_I()) {
            mod *= 0.66;
        }
        this.prevRotation = (float)((double)this.turnSpeed * (mod *= (double)this.getSpeedModifier()));
        this.rotation = (float)((double)this.rotation + (double)this.turnSpeed * mod);
        this.rotation %= 1.0f;
        this.perTick = (float)((double)this.turnSpeed * mod);
        if (!this.field_145850_b.field_72995_K && (tileEntity = Utils.getExistingTileEntity(this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing().func_176734_d()))) instanceof IRotationAcceptor) {
            IRotationAcceptor dynamo = (IRotationAcceptor)tileEntity;
            double power = (double)this.turnSpeed * mod * 800.0;
            dynamo.inputRotation(Math.abs(power), this.getFacing().func_176734_d());
        }
    }

    protected float getSpeedModifier() {
        return 0.5f + (float)this.sails * 0.125f;
    }

    public boolean checkArea() {
        Direction facing = this.getFacing();
        if (facing.func_176740_k() == Direction.Axis.Y) {
            return false;
        }
        this.turnSpeed = 0.0f;
        for (int hh = -4; hh <= 4; ++hh) {
            int r = Math.abs(hh) == 4 ? 1 : (Math.abs(hh) == 3 ? 2 : (Math.abs(hh) == 2 ? 3 : 4));
            for (int ww = -r; ww <= r; ++ww) {
                if (hh == 0 && ww == 0 || this.field_145850_b.func_175623_d(this.func_174877_v().func_177967_a(facing.func_176746_e(), ww).func_177981_b(hh))) continue;
                return false;
            }
        }
        int blocked = 0;
        for (int hh = -4; hh <= 4; ++hh) {
            int r = Math.abs(hh) == 4 ? 1 : (Math.abs(hh) == 3 ? 2 : (Math.abs(hh) == 2 ? 3 : 4));
            for (int ww = -r; ww <= r; ++ww) {
                for (int dd = 1; dd < 8; ++dd) {
                    BlockPos pos = this.func_174877_v().func_177981_b(hh).func_177967_a(facing, dd).func_177967_a(facing.func_176746_e(), ww);
                    if (!this.field_145850_b.isAreaLoaded(pos, 1) || this.field_145850_b.func_175623_d(pos)) {
                        this.turnSpeed += 1.0f;
                        continue;
                    }
                    if (this.field_145850_b.func_175625_s(pos) instanceof WindmillTileEntity) {
                        blocked += 20;
                        this.turnSpeed -= 179.0f;
                        continue;
                    }
                    ++blocked;
                }
            }
            if (blocked <= 100) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.sails = nbt.func_74762_e("sails");
        this.rotation = nbt.func_74760_g("rotation");
        this.turnSpeed = nbt.func_74760_g("turnSpeed");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74768_a("sails", this.sails);
        nbt.func_74776_a("rotation", this.rotation);
        nbt.func_74776_a("turnSpeed", this.turnSpeed);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            Direction facing = this.getFacing();
            this.renderAABB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - (facing.func_176740_k() == Direction.Axis.Z ? 6 : 0)), (double)(this.func_174877_v().func_177956_o() - 6), (double)(this.func_174877_v().func_177952_p() - (facing.func_176740_k() == Direction.Axis.Z ? 0 : 6)), (double)(this.func_174877_v().func_177958_n() + (facing.func_176740_k() == Direction.Axis.Z ? 7 : 0)), (double)(this.func_174877_v().func_177956_o() + 7), (double)(this.func_174877_v().func_177952_p() + (facing.func_176740_k() == Direction.Axis.Z ? 0 : 7)));
        }
        return this.renderAABB;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public IEProperties.VisibilityList compileDisplayList(BlockState state) {
        return IEProperties.VisibilityList.hideAll();
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.sails < 8 && heldItem.func_77973_b() == IEItems.Ingredients.windmillSail) {
            ++this.sails;
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "sails")) {
            this.sails = ItemNBTHelper.getInt(stack, "sails");
        }
    }

    private static List<AxisAlignedBB> getShape(Direction key) {
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{key.func_176740_k() == Direction.Axis.Z ? new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 1.0) : new AxisAlignedBB(0.0, 0.0625, 0.0625, 1.0, 0.9375, 0.9375)});
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return SHAPES.get(this.getFacing());
    }
}

