/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.common.crafting.IngredientSerializerFluidStack;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class IngredientFluidStack
extends Ingredient {
    private final FluidTagInput fluidTagInput;
    ItemStack[] cachedStacks;

    public IngredientFluidStack(FluidTagInput fluidTagInput) {
        super(Stream.empty());
        this.fluidTagInput = fluidTagInput;
    }

    public IngredientFluidStack(Tag<Fluid> tag, int amount) {
        this(new FluidTagInput(tag.func_199886_b(), amount));
    }

    public FluidTagInput getFluidTagInput() {
        return this.fluidTagInput;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])this.fluidTagInput.getMatchingFluidStacks().stream().map(FluidUtil::getFilledBucket).toArray(ItemStack[]::new);
        }
        return this.cachedStacks;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.fluidTagInput.test((FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse((Object)FluidStack.EMPTY));
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientSerializerFluidStack.INSTANCE;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject ret = (JsonObject)this.fluidTagInput.serialize();
        ret.addProperty("type", IngredientSerializerFluidStack.NAME.toString());
        return ret;
    }

    public boolean isSimple() {
        return false;
    }
}

