/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IngredientMultiTag
extends Ingredient {
    private List<Tag<Item>> tags = new ArrayList<Tag<Item>>();
    private IntList itemIds = null;
    private ItemStack[] array = null;

    public IngredientMultiTag(ResourceLocation ... tags) {
        super(Stream.empty());
        for (int i = 0; i < tags.length; ++i) {
            this.tags.add((Tag<Item>)ItemTags.func_199903_a().func_199915_b(tags[i]));
        }
    }

    private int totalSize() {
        int i = 0;
        for (Tag<Item> list : this.tags) {
            i += list.func_199885_a().size();
        }
        return i;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.array == null || this.array.length != this.totalSize()) {
            NonNullList lst = NonNullList.func_191196_a();
            for (Tag<Item> list : this.tags) {
                for (Item stack : list.func_199885_a()) {
                    stack.getItem().func_150895_a(ItemGroup.field_78027_g, lst);
                }
            }
            this.array = (ItemStack[])lst.toArray((Object[])new ItemStack[0]);
        }
        return this.array;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public IntList func_194139_b() {
        if (this.itemIds == null || this.itemIds.size() != this.totalSize()) {
            this.itemIds = new IntArrayList(this.totalSize());
            for (Tag<Item> list : this.tags) {
                for (Item item : list.func_199885_a()) {
                    this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)new ItemStack((IItemProvider)item)));
                }
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        for (Tag<Item> list : this.tags) {
            if (!list.func_199685_a_((Object)input.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    protected void invalidate() {
        this.itemIds = null;
    }
}

