/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class MetalPressPackingRecipes {
    public static Map<ResourceLocation, ICraftingRecipe> CRAFTING_RECIPE_MAP;
    private static final HashMap<ComparableItemStack, RecipeDelegate> PACKING_CACHE;
    private static final HashMap<ComparableItemStack, RecipeDelegate> UNPACKING_CACHE;

    public static MetalPressRecipe get2x2PackingContainer() {
        return new MetalPressContainerRecipe(new ResourceLocation("immersiveengineering", "metalpress/packing2x2"), IEItems.Molds.moldPacking4){

            @Override
            public boolean matches(ItemStack mold, ItemStack input, World world) {
                return input.func_190916_E() >= 4 && super.matches(mold, input, world);
            }

            @Override
            protected MetalPressRecipe getRecipeFunction(ItemStack input, World world) {
                return MetalPressPackingRecipes.getPackingCached(input, world, 2);
            }
        };
    }

    public static MetalPressRecipe get3x3PackingContainer() {
        return new MetalPressContainerRecipe(new ResourceLocation("immersiveengineering", "metalpress/packing3x3"), IEItems.Molds.moldPacking9){

            @Override
            public boolean matches(ItemStack mold, ItemStack input, World world) {
                return input.func_190916_E() >= 9 && super.matches(mold, input, world);
            }

            @Override
            protected MetalPressRecipe getRecipeFunction(ItemStack input, World world) {
                return MetalPressPackingRecipes.getPackingCached(input, world, 3);
            }
        };
    }

    public static MetalPressRecipe getUnpackingContainer() {
        return new MetalPressContainerRecipe(new ResourceLocation("immersiveengineering", "metalpress/unpacking"), IEItems.Molds.moldUnpacking){

            @Override
            protected MetalPressRecipe getRecipeFunction(ItemStack input, World world) {
                return MetalPressPackingRecipes.getUnpackingCached(input, world);
            }
        };
    }

    public static RecipeDelegate getRecipeDelegate(ResourceLocation id) {
        if (!id.toString().startsWith("immersiveengineering:metalpress/packing_") && !id.toString().startsWith("immersiveengineering:metalpress/unpacking_")) {
            return null;
        }
        boolean packing = id.toString().startsWith("immersiveengineering:metalpress/packing_");
        String recipeId = packing ? id.toString().substring("immersiveengineering:metalpress/packing_".length()) : id.toString().substring("immersiveengineering:metalpress/unpacking_".length());
        ICraftingRecipe recipe = CRAFTING_RECIPE_MAP.get(new ResourceLocation(recipeId = recipeId.replaceFirst("\\.\\.", ":")));
        if (recipe == null) {
            return null;
        }
        NonNullList ingredients = recipe.func_192400_c();
        if (packing && ingredients.size() != 4 && ingredients.size() != 9) {
            return null;
        }
        if (!packing && ingredients.size() != 1) {
            return null;
        }
        ItemStack input = ((Ingredient)ingredients.get(0)).func_193365_a()[0];
        if (packing) {
            return RecipeDelegate.getPacking((Pair<ICraftingRecipe, ItemStack>)Pair.of((Object)recipe, (Object)recipe.func_77571_b()), input, ingredients.size() == 9);
        }
        return RecipeDelegate.getUnpacking((Pair<ICraftingRecipe, ItemStack>)Pair.of((Object)recipe, (Object)recipe.func_77571_b()), input);
    }

    public static Pair<ICraftingRecipe, ItemStack> getPackedOutput(int gridSize, int totalAmount, ItemStack stack, World world) {
        CraftingInventory invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(gridSize, gridSize, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)totalAmount, (Object)stack.func_77946_l()));
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)invC, world).map(recipe -> Pair.of((Object)recipe, (Object)recipe.func_77572_b((IInventory)invC))).orElse(null);
    }

    private static RecipeDelegate getUnpackingCached(ItemStack input, World world) {
        ComparableItemStack comp = new ComparableItemStack(input, false);
        if (UNPACKING_CACHE.containsKey(comp)) {
            return UNPACKING_CACHE.get(comp);
        }
        comp.copy();
        Pair<ICraftingRecipe, ItemStack> out = MetalPressPackingRecipes.getPackedOutput(1, 1, input, world);
        if (out == null) {
            return null;
        }
        ItemStack outStack = (ItemStack)out.getRight();
        int count = outStack.func_190916_E();
        if (count != 4 && count != 9) {
            UNPACKING_CACHE.put(comp, null);
            return null;
        }
        Pair<ICraftingRecipe, ItemStack> rePacked = MetalPressPackingRecipes.getPackedOutput(count == 4 ? 2 : 3, count, outStack, world);
        if (rePacked == null || ((ItemStack)rePacked.getRight()).func_190926_b() || !ItemStack.func_77989_b((ItemStack)input, (ItemStack)((ItemStack)rePacked.getRight()))) {
            UNPACKING_CACHE.put(comp, null);
            return null;
        }
        RecipeDelegate delegate = RecipeDelegate.getUnpacking(out, Utils.copyStackWithAmount(input, 1));
        UNPACKING_CACHE.put(comp, delegate);
        return delegate;
    }

    private static RecipeDelegate getPackingCached(ItemStack input, World world, int gridSize) {
        ComparableItemStack comp = new ComparableItemStack(input, false);
        if (PACKING_CACHE.containsKey(comp)) {
            return PACKING_CACHE.get(comp);
        }
        int totalSize = gridSize * gridSize;
        comp.copy();
        Pair<ICraftingRecipe, ItemStack> out = MetalPressPackingRecipes.getPackedOutput(gridSize, totalSize, input, world);
        if (out == null) {
            return null;
        }
        ItemStack outStack = (ItemStack)out.getRight();
        if (outStack.func_190926_b()) {
            PACKING_CACHE.put(comp, null);
            return null;
        }
        RecipeDelegate delegate = RecipeDelegate.getPacking(out, Utils.copyStackWithAmount(input, totalSize), gridSize == 3);
        PACKING_CACHE.put(comp, delegate);
        return delegate;
    }

    static {
        PACKING_CACHE = new HashMap();
        UNPACKING_CACHE = new HashMap();
    }

    public static class RecipeDelegate
    extends MetalPressRecipe {
        private RecipeDelegate(String id, ItemStack output, ItemStack input, Item mold) {
            super(new ResourceLocation("immersiveengineering", id), output, IngredientWithSize.of(input), new ComparableItemStack(new ItemStack((IItemProvider)mold)), 3200);
        }

        public static RecipeDelegate getPacking(Pair<ICraftingRecipe, ItemStack> originalRecipe, ItemStack input, boolean big) {
            ItemStack output = (ItemStack)originalRecipe.getRight();
            ResourceLocation originalId = ((ICraftingRecipe)originalRecipe.getLeft()).func_199560_c();
            String id = "metalpress/packing_" + originalId.func_110624_b() + ".." + originalId.func_110623_a();
            return new RecipeDelegate(id, output, input, big ? IEItems.Molds.moldPacking9 : IEItems.Molds.moldPacking4);
        }

        public static RecipeDelegate getUnpacking(Pair<ICraftingRecipe, ItemStack> originalRecipe, ItemStack input) {
            ItemStack output = (ItemStack)originalRecipe.getRight();
            ResourceLocation originalId = ((ICraftingRecipe)originalRecipe.getLeft()).func_199560_c();
            String id = "metalpress/unpacking_" + originalId.func_110624_b() + ".." + originalId.func_110623_a();
            return new RecipeDelegate(id, output, input, IEItems.Molds.moldUnpacking);
        }

        @Override
        public boolean listInJEI() {
            return false;
        }
    }

    public static abstract class MetalPressContainerRecipe
    extends MetalPressRecipe {
        public MetalPressContainerRecipe(ResourceLocation id, Item mold) {
            super(id, ItemStack.field_190927_a, new IngredientWithSize(Ingredient.field_193370_a), new ComparableItemStack(new ItemStack((IItemProvider)mold)), 3200);
        }

        @Override
        public boolean listInJEI() {
            return false;
        }

        @Override
        public boolean matches(ItemStack mold, ItemStack input, World world) {
            return this.getRecipeFunction(input, world) != null;
        }

        @Override
        public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input, World world) {
            return this.getRecipeFunction(input, world);
        }

        protected abstract MetalPressRecipe getRecipeFunction(ItemStack var1, World var2);
    }
}

