/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingThreadHandler;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class RecipeReloadListener
implements IResourceManagerReloadListener {
    public void func_195410_a(IResourceManager resourceManager) {
        if (EffectiveSide.get().isServer()) {
            RecipeManager recipeManager = ServerLifecycleHooks.getCurrentServer().func_199529_aN();
            this.startArcRecyclingRecipeGen(recipeManager);
            RecipeReloadListener.buildRecipeLists(recipeManager);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRecipesUpdated(RecipesUpdatedEvent event) {
        RecipeReloadListener.buildRecipeLists(event.getRecipeManager());
    }

    static void buildRecipeLists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        ArcRecyclingThreadHandler recyclingHandler = new ArcRecyclingThreadHandler(recipes);
        recyclingHandler.start();
        AlloyRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, AlloyRecipe.class, AlloyRecipe.TYPE);
        BlastFurnaceRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BlastFurnaceRecipe.class, BlastFurnaceRecipe.TYPE);
        BlastFurnaceFuel.blastFuels = RecipeReloadListener.filterRecipes(recipes, BlastFurnaceFuel.class, BlastFurnaceFuel.TYPE);
        CokeOvenRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, CokeOvenRecipe.class, CokeOvenRecipe.TYPE);
        ClocheRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, ClocheRecipe.class, ClocheRecipe.TYPE);
        ClocheFertilizer.fertilizerList = RecipeReloadListener.filterRecipes(recipes, ClocheFertilizer.class, ClocheFertilizer.TYPE);
        BlueprintCraftingRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BlueprintCraftingRecipe.class, BlueprintCraftingRecipe.TYPE);
        BlueprintCraftingRecipe.updateRecipeCategories();
        MetalPressRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, MetalPressRecipe.class, MetalPressRecipe.TYPE);
        MetalPressRecipe unpackingRecipe = MetalPressPackingRecipes.getUnpackingContainer();
        MetalPressRecipe packingRecipe2x2 = MetalPressPackingRecipes.get2x2PackingContainer();
        MetalPressRecipe packingRecipe3x3 = MetalPressPackingRecipes.get3x3PackingContainer();
        MetalPressRecipe.recipeList.put(unpackingRecipe.func_199560_c(), unpackingRecipe);
        MetalPressRecipe.recipeList.put(packingRecipe2x2.func_199560_c(), packingRecipe2x2);
        MetalPressRecipe.recipeList.put(packingRecipe3x3.func_199560_c(), packingRecipe3x3);
        MetalPressPackingRecipes.CRAFTING_RECIPE_MAP = RecipeReloadListener.filterRecipes(recipes, ICraftingRecipe.class, IRecipeType.field_222149_a);
        MetalPressRecipe.updateRecipesByMold();
        BottlingMachineRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, BottlingMachineRecipe.class, BottlingMachineRecipe.TYPE);
        CrusherRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, CrusherRecipe.class, CrusherRecipe.TYPE);
        FermenterRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, FermenterRecipe.class, FermenterRecipe.TYPE);
        SqueezerRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, SqueezerRecipe.class, SqueezerRecipe.TYPE);
        RefineryRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, RefineryRecipe.class, RefineryRecipe.TYPE);
        MixerRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, MixerRecipe.class, MixerRecipe.TYPE);
        MineralMix.mineralList = RecipeReloadListener.filterRecipes(recipes, MineralMix.class, MineralMix.TYPE);
        ArcFurnaceRecipe.recipeList = RecipeReloadListener.filterRecipes(recipes, ArcFurnaceRecipe.class, ArcFurnaceRecipe.TYPE);
    }

    private void startArcRecyclingRecipeGen(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        new ArcRecyclingThreadHandler(recipes).start();
    }

    static <R extends IRecipe<?>> Map<ResourceLocation, R> filterRecipes(Collection<IRecipe<?>> recipes, Class<R> recipeClass, IRecipeType<R> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.func_222127_g() == recipeType).flatMap(r -> {
            if (r instanceof GeneratedListRecipe) {
                return ((GeneratedListRecipe)r).getSubRecipes().stream();
            }
            return Stream.of(r);
        }).map(recipeClass::cast).collect(Collectors.toMap(recipe -> recipe.func_199560_c(), recipe -> recipe));
    }
}

