/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.common.crafting.IngredientFluidStack;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TurnAndCopyRecipe
extends ShapedRecipe {
    protected NonNullList<Ingredient> ingredientsQuarterTurn;
    protected NonNullList<Ingredient> ingredientsEighthTurn;
    protected int[] nbtCopyTargetSlot = null;
    protected Pattern nbtCopyPredicate = null;
    protected int lastMatch = 0;
    protected int lastStartX = 0;
    protected int lastStartY = 0;
    private static int[] eighthTurnMap = new int[]{3, -1, -1, 3, 0, -3, 1, 1, -3};

    public TurnAndCopyRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingr, ItemStack output) {
        super(id, group, width, height, ingr, output);
    }

    public void allowQuarterTurn() {
        this.ingredientsQuarterTurn = NonNullList.func_191197_a((int)this.func_192400_c().size(), (Object)Ingredient.field_193370_a);
        int maxH = this.getRecipeHeight() - 1;
        for (int h = 0; h < this.getRecipeHeight(); ++h) {
            for (int w = 0; w < this.getRecipeWidth(); ++w) {
                this.ingredientsQuarterTurn.set(w * this.getRecipeHeight() + (maxH - h), this.func_192400_c().get(h * this.getRecipeWidth() + w));
            }
        }
    }

    public void allowEighthTurn() {
        if (this.getRecipeWidth() != 3 || this.getRecipeHeight() != 3) {
            return;
        }
        this.ingredientsEighthTurn = NonNullList.func_191197_a((int)this.func_192400_c().size(), (Object)Ingredient.field_193370_a);
        int maxH = this.getRecipeHeight() - 1;
        for (int h = 0; h < this.getRecipeHeight(); ++h) {
            for (int w = 0; w < this.getRecipeWidth(); ++w) {
                int i = h * this.getRecipeWidth() + w;
                this.ingredientsEighthTurn.set(i + eighthTurnMap[i], this.func_192400_c().get(i));
            }
        }
    }

    public void setNBTCopyTargetRecipe(int ... slot) {
        this.nbtCopyTargetSlot = slot;
    }

    public void setNBTCopyPredicate(String pattern) {
        this.nbtCopyPredicate = Pattern.compile(pattern);
    }

    @Nonnull
    public ItemStack func_77572_b(CraftingInventory matrix) {
        if (this.nbtCopyTargetSlot != null) {
            ItemStack out = this.func_77571_b().func_77946_l();
            CompoundNBT tag = out.func_196082_o();
            for (int targetSlot : this.nbtCopyTargetSlot) {
                ItemStack s = matrix.func_70301_a(targetSlot);
                if (s.func_190926_b() || !s.func_77942_o()) continue;
                tag = ItemNBTHelper.combineTags(tag, s.func_196082_o(), this.nbtCopyPredicate);
            }
            out.func_77982_d(tag);
            return out;
        }
        return super.func_77572_b(matrix);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remains = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int yy = 0; yy < this.getRecipeHeight(); ++yy) {
            for (int xx = 0; xx < this.getRecipeWidth(); ++xx) {
                NonNullList matchedIngr;
                int i = this.getRecipeWidth() * yy + xx;
                int transposedI = inv.func_174922_i() * (yy + this.lastStartY) + (xx + this.lastStartX);
                ItemStack s = inv.func_70301_a(transposedI);
                Object object = this.lastMatch == 1 ? this.ingredientsQuarterTurn : (matchedIngr = this.lastMatch == 2 ? this.ingredientsEighthTurn : this.func_192400_c());
                if (matchedIngr.get(i) instanceof IngredientFluidStack) {
                    LazyOptional handlerLazy = FluidUtil.getFluidHandler((ItemStack)(s.func_190916_E() > 1 ? Utils.copyStackWithAmount(s, 1) : s));
                    handlerLazy.ifPresent(handler -> {
                        FluidTagInput fluid = ((IngredientFluidStack)((Object)((Object)matchedIngr.get(i)))).getFluidTagInput();
                        handler.drain(fluid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        remains.set(transposedI, (Object)handler.getContainer().func_77946_l());
                    });
                    if (handlerLazy.isPresent()) continue;
                    remains.set(transposedI, (Object)ForgeHooks.getContainerItem((ItemStack)s));
                    continue;
                }
                remains.set(transposedI, (Object)ForgeHooks.getContainerItem((ItemStack)s));
            }
        }
        return remains;
    }

    public boolean func_77573_a(CraftingInventory inv, int startX, int startY, boolean mirror) {
        if (this.checkMatchDo(inv, (NonNullList<Ingredient>)this.func_192400_c(), startX, startY, mirror, false)) {
            this.lastMatch = 0;
            this.lastStartX = startX;
            this.lastStartY = startY;
            return true;
        }
        if (this.ingredientsQuarterTurn != null && this.checkMatchDo(inv, this.ingredientsQuarterTurn, startX, startY, mirror, true)) {
            this.lastMatch = 1;
            this.lastStartX = startX;
            this.lastStartY = startY;
            return true;
        }
        if (this.ingredientsEighthTurn != null && this.checkMatchDo(inv, this.ingredientsEighthTurn, startX, startY, mirror, false)) {
            this.lastMatch = 2;
            this.lastStartX = startX;
            this.lastStartY = startY;
            return true;
        }
        return false;
    }

    private boolean checkMatchDo(CraftingInventory inv, NonNullList<Ingredient> ingredients, int startX, int startY, boolean mirror, boolean rotate) {
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                ItemStack slot;
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.field_193370_a;
                if (!rotate) {
                    if (subX >= 0 && subY >= 0 && subX < this.getRecipeWidth() && subY < this.getRecipeHeight()) {
                        target = mirror ? (Ingredient)ingredients.get(this.getRecipeWidth() - subX - 1 + subY * this.getRecipeWidth()) : (Ingredient)ingredients.get(subX + subY * this.getRecipeWidth());
                    }
                } else if (subX >= 0 && subY >= 0 && subX < this.getRecipeHeight() && subY < this.getRecipeWidth()) {
                    target = mirror ? (Ingredient)ingredients.get(this.getRecipeHeight() - subX - 1 + subY * this.getRecipeWidth()) : (Ingredient)ingredients.get(subY + subX * this.getRecipeHeight());
                }
                if (target.test(slot = inv.func_70301_a(x + y * inv.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.TURN_AND_COPY_SERIALIZER.get();
    }

    public boolean isQuarterTurn() {
        return this.ingredientsQuarterTurn != null;
    }

    public boolean isEightTurn() {
        return this.ingredientsEighthTurn != null;
    }

    public int[] getCopyTargets() {
        return this.nbtCopyTargetSlot;
    }

    public boolean hasCopyPredicate() {
        return this.nbtCopyPredicate != null;
    }

    public String getBufferPredicate() {
        return this.nbtCopyPredicate.pattern();
    }
}

