/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.AlloyRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.ArcFurnaceRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.BlastFurnaceFuelBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.BlastFurnaceRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.BlueprintCraftingRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.BottlingMachineRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.ClocheFertilizerBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.ClocheRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.CokeOvenRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.CrusherRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.FermenterRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.MetalPressRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.MineralMixBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.MixerRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.RefineryRecipeBuilder;
import blusunrize.immersiveengineering.api.crafting.builders.SqueezerRecipeBuilder;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.MetalLadderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.CoveredConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.DropConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.DropCoveredConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ExtractConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ExtractCoveredConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.RedstoneConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.SplitConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.SplitCoveredConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.VerticalConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.VerticalCoveredConveyor;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.crafting.HammerCrushingRecipeBuilder;
import blusunrize.immersiveengineering.common.crafting.IEConfigConditionSerializer;
import blusunrize.immersiveengineering.common.crafting.IngredientFluidStack;
import blusunrize.immersiveengineering.common.crafting.RevolverAssemblyRecipeBuilder;
import blusunrize.immersiveengineering.common.crafting.TurnAndCopyRecipeBuilder;
import blusunrize.immersiveengineering.common.crafting.serializers.GeneratedListRecipeBuilder;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.data.resources.RecipeMetals;
import blusunrize.immersiveengineering.common.data.resources.RecipeOres;
import blusunrize.immersiveengineering.common.data.resources.SecondaryOutput;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.ToolUpgradeItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Recipes
extends RecipeProvider {
    private final Path ADV_ROOT;
    private final HashMap<String, Integer> PATH_COUNT = new HashMap();
    private final int standardSmeltingTime = 200;
    private final int blastDivider = 2;

    public Recipes(DataGenerator gen) {
        super(gen);
        this.ADV_ROOT = gen.func_200391_b().resolve("data/minecraft/advancements/recipes/root.json");
    }

    protected void func_208310_b(DirectoryCache cache, JsonObject json, Path path) {
        if (path.equals(this.ADV_ROOT)) {
            return;
        }
        super.func_208310_b(cache, json, path);
    }

    protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> out) {
        for (EnumMetals enumMetals : EnumMetals.values()) {
            IETags.MetalTags tags = IETags.getTagsFor(enumMetals);
            Item nugget = IEItems.Metals.nuggets.get((Object)enumMetals);
            Item ingot = IEItems.Metals.ingots.get((Object)enumMetals);
            Item plate = IEItems.Metals.plates.get((Object)enumMetals);
            Item dust = IEItems.Metals.dusts.get((Object)enumMetals);
            Block block = IEBlocks.Metals.storage.get((Object)enumMetals);
            Block sheetMetal = IEBlocks.Metals.sheetmetal.get((Object)enumMetals);
            if (!enumMetals.isVanillaMetal()) {
                this.add3x3Conversion((IItemProvider)ingot, (IItemProvider)nugget, tags.nugget, out);
                this.add3x3Conversion((IItemProvider)block, (IItemProvider)ingot, tags.ingot, out);
                if (IEBlocks.Metals.ores.containsKey((Object)enumMetals)) {
                    Block ore = IEBlocks.Metals.ores.get((Object)enumMetals);
                    this.addStandardSmeltingBlastingRecipe((IItemProvider)ore, (IItemProvider)ingot, enumMetals.smeltingXP, out);
                }
            }
            this.addStandardSmeltingBlastingRecipe((IItemProvider)dust, (IItemProvider)ingot, 0.0f, out, "_from_dust");
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)plate).func_203221_a(IETags.getTagsFor((EnumMetals)enumMetals).ingot).func_200487_b((IItemProvider)IEItems.Tools.hammer).func_200483_a("has_" + enumMetals.tagName() + "_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)enumMetals).ingot)).func_200485_a(out, this.toRL("plate_" + enumMetals.tagName() + "_hammering"));
            ShapedRecipeBuilder.func_200468_a((IItemProvider)sheetMetal, (int)4).func_200472_a(" p ").func_200472_a("p p").func_200472_a(" p ").func_200469_a(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)enumMetals).plate).func_200465_a("has_" + this.toPath((IItemProvider)plate), (ICriterionInstance)this.func_200403_a((IItemProvider)plate)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)sheetMetal)));
        }
        this.addStandardSmeltingBlastingRecipe((IItemProvider)IEItems.Ingredients.dustHopGraphite, (IItemProvider)IEItems.Ingredients.ingotHopGraphite, 0.5f, out);
        this.addStandardSmeltingBlastingRecipe((IItemProvider)IEItems.Tools.steelAxe, (IItemProvider)IEItems.Metals.nuggets.get((Object)EnumMetals.STEEL), 0.1f, out, "_recycle_axe");
        this.addStandardSmeltingBlastingRecipe((IItemProvider)IEItems.Tools.steelPick, (IItemProvider)IEItems.Metals.nuggets.get((Object)EnumMetals.STEEL), 0.1f, out, "_recycle_pick");
        this.addStandardSmeltingBlastingRecipe((IItemProvider)IEItems.Tools.steelShovel, (IItemProvider)IEItems.Metals.nuggets.get((Object)EnumMetals.STEEL), 0.1f, out, "_recycle_shovel");
        this.addStandardSmeltingBlastingRecipe((IItemProvider)IEItems.Tools.steelSword, (IItemProvider)IEItems.Metals.nuggets.get((Object)EnumMetals.STEEL), 0.1f, out, "_recycle_sword");
        for (EnumMetals enumMetals : EquipmentSlotType.values()) {
            if (enumMetals.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
            this.addStandardSmeltingBlastingRecipe((IItemProvider)IEItems.Tools.steelArmor.get((Object)enumMetals), (IItemProvider)IEItems.Metals.nuggets.get((Object)EnumMetals.STEEL), 0.1f, out, "_recycle_steel_" + enumMetals.func_188450_d());
            this.addStandardSmeltingBlastingRecipe((IItemProvider)IEItems.Misc.faradaySuit.get((Object)enumMetals), (IItemProvider)IEItems.Metals.nuggets.get((Object)EnumMetals.ALUMINUM), 0.1f, out, "_recycle_faraday_" + enumMetals.func_188450_d());
        }
        for (Map.Entry entry : IEBlocks.toSlab.entrySet()) {
            this.addSlab((IItemProvider)entry.getKey(), (IItemProvider)entry.getValue(), out);
        }
        this.recipesStoneDecorations(out);
        this.recipesWoodenDecorations(out);
        this.recipesWoodenDevices(out);
        this.recipesMetalDecorations(out);
        this.recipesMetalDevices(out);
        this.recipesConnectors(out);
        this.recipesConveyors(out);
        this.recipesCloth(out);
        this.recipesTools(out);
        this.recipesIngredients(out);
        this.recipesVanilla(out);
        this.recipesWeapons(out);
        this.recipesMisc(out);
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)RecipeSerializers.SPEEDLOADER_LOAD.get())).func_200499_a(out, "immersiveengineering:speedloader_load");
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)RecipeSerializers.FLARE_BULLET_COLOR.get())).func_200499_a(out, "immersiveengineering:flare_bullet_color");
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)RecipeSerializers.POTION_BULLET_FILL.get())).func_200499_a(out, "immersiveengineering:potion_bullet_fill");
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)RecipeSerializers.POWERPACK_SERIALIZER.get())).func_200499_a(out, "immersiveengineering:powerpack_attach");
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)RecipeSerializers.EARMUFF_SERIALIZER.get())).func_200499_a(out, "immersiveengineering:earmuffs_attach");
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)RecipeSerializers.JERRYCAN_REFILL.get())).func_200499_a(out, "immersiveengineering:jerrycan_refill");
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)RecipeSerializers.REVOLVER_CYCLE_SERIALIZER.get())).func_200499_a(out, "immersiveengineering:revolver_cycle");
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)RecipeSerializers.IE_REPAIR.get())).func_200499_a(out, "immersiveengineering:ie_item_repair");
        GeneratedListRecipeBuilder.build(out, IEDataGenerator.rl("arc_recycling_list"));
        GeneratedListRecipeBuilder.build(out, IEDataGenerator.rl("mixer_potion_list"));
        GeneratedListRecipeBuilder.build(out, IEDataGenerator.rl("potion_bottling_list"));
        this.addRGBRecipe(out, this.toRL("curtain_colour"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.Cloth.curtain}), "colour");
        this.recipesBlast(out);
        this.recipesCoke(out);
        this.recipesCloche(out);
        this.recipesBlueprint(out);
        this.recipesMultiblockMachines(out);
        this.mineralMixes(out);
    }

    private void recipesBlast(@Nonnull Consumer<IFinishedRecipe> out) {
        ((BlastFurnaceFuelBuilder)BlastFurnaceFuelBuilder.builder(IETags.coalCoke).setTime(1200)).build(out, this.toRL("blastfurnace/fuel_coke"));
        ((BlastFurnaceFuelBuilder)BlastFurnaceFuelBuilder.builder(IETags.getItemTag(IETags.coalCokeBlock)).setTime(12000)).build(out, this.toRL("blastfurnace/fuel_coke_block"));
        ((BlastFurnaceFuelBuilder)BlastFurnaceFuelBuilder.builder(IETags.charCoal).setTime(300)).build(out, this.toRL("blastfurnace/fuel_charcoal"));
        ((BlastFurnaceFuelBuilder)((BlastFurnaceFuelBuilder)BlastFurnaceFuelBuilder.builder(IETags.getItemTag(IETags.charCoalBlocks)).addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(IETags.charCoalBlocks.func_199886_b())))).setTime(3000)).build(out, this.toRL("blastfurnace/fuel_charcoal_block"));
        ((BlastFurnaceRecipeBuilder)((BlastFurnaceRecipeBuilder)BlastFurnaceRecipeBuilder.builder(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, 1).addInput((Tag<Item>)Tags.Items.INGOTS_IRON)).addSlag(IETags.slag, 1).setTime(1200)).build(out, this.toRL("blastfurnace/steel"));
        ((BlastFurnaceRecipeBuilder)((BlastFurnaceRecipeBuilder)BlastFurnaceRecipeBuilder.builder(IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).storage), 1).addInput((Tag<Item>)Tags.Items.STORAGE_BLOCKS_IRON)).addSlag(IETags.slag, 9).setTime(10800)).build(out, this.toRL("blastfurnace/steel_block"));
    }

    private void recipesCoke(@Nonnull Consumer<IFinishedRecipe> out) {
        ((CokeOvenRecipeBuilder)((CokeOvenRecipeBuilder)CokeOvenRecipeBuilder.builder(IETags.coalCoke, 1).addInput(new IItemProvider[]{Items.field_151044_h})).setOil(500).setTime(1800)).build(out, this.toRL("cokeoven/coke"));
        ((CokeOvenRecipeBuilder)((CokeOvenRecipeBuilder)CokeOvenRecipeBuilder.builder(IETags.getItemTag(IETags.coalCokeBlock), 1).addInput(new IItemProvider[]{Blocks.field_150402_ci})).setOil(5000).setTime(16200)).build(out, this.toRL("cokeoven/coke_block"));
        ((CokeOvenRecipeBuilder)((CokeOvenRecipeBuilder)CokeOvenRecipeBuilder.builder(Items.field_196155_l).addInput((Tag<Item>)ItemTags.field_200038_h)).setOil(250).setTime(900)).build(out, this.toRL("cokeoven/charcoal"));
    }

    private void recipesCloche(@Nonnull Consumer<IFinishedRecipe> out) {
        ((ClocheFertilizerBuilder)ClocheFertilizerBuilder.builder(1.25f).addInput(new IItemProvider[]{Items.field_196106_bc})).build(out, this.toRL("fertilizer/bone_meal"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151015_O, 2)).addResult(new ItemStack((IItemProvider)Items.field_151014_N, 1))).addInput(new IItemProvider[]{Items.field_151014_N})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(640)).setRender(new ClocheRenderFunction.ClocheRenderReference("crop", Blocks.field_150464_aj)).build(out, this.toRL("cloche/wheat"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151174_bG, 2)).addInput(new IItemProvider[]{Items.field_151174_bG})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(800)).setRender(new ClocheRenderFunction.ClocheRenderReference("crop", Blocks.field_150469_bN)).build(out, this.toRL("cloche/potato"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151172_bF, 2)).addInput(new IItemProvider[]{Items.field_151172_bF})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(800)).setRender(new ClocheRenderFunction.ClocheRenderReference("crop", Blocks.field_150459_bM)).build(out, this.toRL("cloche/carrot"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_185164_cV, 2)).addResult(new ItemStack((IItemProvider)Items.field_185163_cU, 1))).addInput(new IItemProvider[]{Items.field_185163_cU})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(800)).setRender(new ClocheRenderFunction.ClocheRenderReference("crop", Blocks.field_185773_cZ)).build(out, this.toRL("cloche/beetroot"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151075_bm, 2)).addInput(new IItemProvider[]{Items.field_151075_bm})).addSoil((IItemProvider)Blocks.field_150425_aM).setTime(800)).setRender(new ClocheRenderFunction.ClocheRenderReference("crop", Blocks.field_150388_bm)).build(out, this.toRL("cloche/nether_wart"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_222112_pR, 2)).addInput(new IItemProvider[]{Items.field_222112_pR})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(560)).setRender(new ClocheRenderFunction.ClocheRenderReference("crop", Blocks.field_222434_lW)).build(out, this.toRL("cloche/sweet_berries"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(Items.field_221687_cF).addInput(new IItemProvider[]{Items.field_151080_bb})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(800)).setRender(new ClocheRenderFunction.ClocheRenderReference("stem", Blocks.field_150423_aK)).build(out, this.toRL("cloche/pumpkin"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(Items.field_221794_dg).addInput(new IItemProvider[]{Items.field_151081_bc})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(800)).setRender(new ClocheRenderFunction.ClocheRenderReference("stem", Blocks.field_150440_ba)).build(out, this.toRL("cloche/melon"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(Items.field_222065_kN).addInput(new IItemProvider[]{Items.field_222065_kN})).addSoil((IItemProvider)Blocks.field_150354_m).setTime(560)).setRender(new ClocheRenderFunction.ClocheRenderReference("stacking", Blocks.field_196608_cF)).build(out, this.toRL("cloche/sugar_cane"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(Items.field_221774_cw).addInput(new IItemProvider[]{Items.field_221774_cw})).addSoil((IItemProvider)Blocks.field_150354_m).setTime(560)).setRender(new ClocheRenderFunction.ClocheRenderReference("stacking", Blocks.field_150434_aF)).build(out, this.toRL("cloche/cactus"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(Items.field_222068_kQ).addInput(new IItemProvider[]{Items.field_222068_kQ})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(560)).setRender(new ClocheRenderFunction.ClocheRenderReference("stacking", Blocks.field_222405_kQ)).build(out, this.toRL("cloche/bamboo"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(Items.field_185161_cS).addInput(new IItemProvider[]{Items.field_221663_bT})).addSoil((IItemProvider)Blocks.field_150377_bs).setTime(480)).setRender(new ClocheRenderFunction.ClocheRenderReference("chorus", Blocks.field_185766_cS)).build(out, this.toRL("cloche/chorus_fruit"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(IEItems.Ingredients.hempFiber).addResult(new ItemStack((IItemProvider)IEItems.Misc.hempSeeds, 2))).addInput(new IItemProvider[]{IEItems.Misc.hempSeeds})).addSoil((IItemProvider)Blocks.field_150346_d).setTime(800)).setRender(new ClocheRenderFunction.ClocheRenderReference("hemp", IEBlocks.Misc.hempPlant)).build(out, this.toRL("cloche/hemp"));
        Ingredient shroomSoil = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150391_bh, Blocks.field_196661_l});
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(Items.field_221694_bi).addInput(new IItemProvider[]{Items.field_221694_bi})).addSoil(shroomSoil).setTime(480)).setRender(new ClocheRenderFunction.ClocheRenderReference("generic", Blocks.field_150337_Q)).build(out, this.toRL("cloche/red_mushroom"));
        ((ClocheRecipeBuilder)((ClocheRecipeBuilder)ClocheRecipeBuilder.builder(Items.field_221692_bh).addInput(new IItemProvider[]{Items.field_221692_bh})).addSoil(shroomSoil).setTime(480)).setRender(new ClocheRenderFunction.ClocheRenderReference("generic", Blocks.field_150338_P)).build(out, this.toRL("cloche/brown_mushroom"));
    }

    private void recipesBlueprint(@Nonnull Consumer<IFinishedRecipe> out) {
        Item[] molds;
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("components", new ItemStack((IItemProvider)IEItems.Ingredients.componentIron)).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate, 2))).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot))).build(out, this.toRL("blueprint/component_iron"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("components", new ItemStack((IItemProvider)IEItems.Ingredients.componentSteel)).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate, 2))).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot))).build(out, this.toRL("blueprint/component_steel"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("components", new ItemStack((IItemProvider)IEItems.Ingredients.electronTube, 3)).addInput((Tag<Item>)Tags.Items.GLASS)).addInput(IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).plate)).addInput(IETags.copperWire)).addInput((Tag<Item>)Tags.Items.DUSTS_REDSTONE)).build(out, this.toRL("blueprint/electron_tube"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("components", new ItemStack((IItemProvider)IEItems.Ingredients.circuitBoard)).addInput(new IItemProvider[]{IEBlocks.StoneDecoration.insulatingGlass})).addInput(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).plate)).addInput(new ItemStack((IItemProvider)IEItems.Ingredients.electronTube, 2))).build(out, this.toRL("blueprint/circuit_board"));
        for (Item mold : molds = new Item[]{IEItems.Molds.moldPlate, IEItems.Molds.moldGear, IEItems.Molds.moldRod, IEItems.Molds.moldBulletCasing, IEItems.Molds.moldWire, IEItems.Molds.moldPacking4, IEItems.Molds.moldPacking9, IEItems.Molds.moldUnpacking}) {
            ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("molds", mold).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate, 3))).addInput(new IItemProvider[]{IEItems.Tools.wirecutter})).build(out, this.toRL("blueprint/" + this.toPath((IItemProvider)mold)));
        }
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("bullet", BulletHandler.getBulletItem(BulletItem.CASULL)).addInput(BulletHandler.emptyCasing)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).nugget, 2))).build(out, this.toRL("blueprint/bullet_casull"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("bullet", BulletHandler.getBulletItem(BulletItem.ARMOR_PIERCING)).addInput(BulletHandler.emptyCasing)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).nugget, 2))).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.CONSTANTAN).nugget, 2))).build(out, this.toRL("blueprint/bullet_armorpiercing"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("bullet", BulletHandler.getBulletItem(BulletItem.SILVER)).addInput(BulletHandler.emptyCasing)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).nugget, 2))).addInput(IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).nugget)).build(out, this.toRL("blueprint/bullet_silver"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("bullet", BulletHandler.getBulletItem(BulletItem.BUCKSHOT)).addInput(BulletHandler.emptyShell)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).dust, 2))).build(out, this.toRL("blueprint/bullet_buckshot"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("specialBullet", BulletHandler.getBulletItem(BulletItem.HIGH_EXPLOSIVE)).addInput(BulletHandler.emptyCasing)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IItemProvider[]{Items.field_221649_bM})).build(out, this.toRL("blueprint/bullet_explosive"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("specialBullet", BulletHandler.getBulletItem(BulletItem.DRAGONS_BREATH)).addInput(BulletHandler.emptyShell)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust, 4))).build(out, this.toRL("blueprint/bullet_dragonsbreath"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("specialBullet", BulletHandler.getBulletItem(BulletItem.POTION)).addInput(BulletHandler.emptyCasing)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IItemProvider[]{Items.field_151069_bo})).build(out, this.toRL("blueprint/bullet_potion"));
        ItemStack flare = BulletHandler.getBulletStack(BulletItem.FLARE);
        ItemNBTHelper.putInt(flare, "flareColour", 13381126);
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("specialBullet", flare.func_77946_l()).addInput(BulletHandler.emptyShell)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust)).addInput((Tag<Item>)Tags.Items.DYES_RED)).build(out, this.toRL("blueprint/bullet_flare_red"));
        ItemNBTHelper.putInt(flare, "flareColour", 2925323);
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("specialBullet", flare.func_77946_l()).addInput(BulletHandler.emptyShell)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust)).addInput((Tag<Item>)Tags.Items.DYES_GREEN)).build(out, this.toRL("blueprint/bullet_flare_green"));
        ItemNBTHelper.putInt(flare, "flareColour", 0xFFFF82);
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("specialBullet", flare.func_77946_l()).addInput(BulletHandler.emptyShell)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust)).addInput((Tag<Item>)Tags.Items.DYES_YELLOW)).build(out, this.toRL("blueprint/bullet_flare_yellow"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("specialBullet", BulletHandler.getBulletItem(BulletItem.HOMING)).addInput(BulletHandler.emptyCasing)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IngredientWithSize(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).nugget, 2))).addInput(new IItemProvider[]{Items.field_151061_bv})).build(out, this.toRL("blueprint/bullet_homing"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("specialBullet", BulletHandler.getBulletItem(BulletItem.WOLFPACK)).addInput(BulletHandler.emptyShell)).addInput((Tag<Item>)Tags.Items.GUNPOWDER)).addInput(new IngredientWithSize(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{BulletHandler.getBulletItem(BulletItem.HOMING)}), 4))).build(out, this.toRL("blueprint/bullet_wolfpack"));
        ((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder("electrode", IEItems.Misc.graphiteElectrode).addInput(new IngredientWithSize(IETags.hopGraphiteIngot, 4))).build(out, this.toRL("blueprint/electrode"));
    }

    private void recipesMultiblockMachines(@Nonnull Consumer<IFinishedRecipe> out) {
        CrusherRecipeBuilder crusherBuilder;
        SecondaryOutput[] secondaryOutputs;
        for (RecipeMetals recipeMetals : RecipeMetals.values()) {
            ArcFurnaceRecipeBuilder arcBuilder;
            if (recipeMetals.getOre() != null) {
                secondaryOutputs = recipeMetals.getSecondaryOutputs();
                HammerCrushingRecipeBuilder hammerBuilder = HammerCrushingRecipeBuilder.builder(recipeMetals.getDust());
                if (!recipeMetals.isNative()) {
                    ((HammerCrushingRecipeBuilder)hammerBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getDust()))).addCondition(Recipes.getTagCondition(recipeMetals.getOre()));
                }
                ((HammerCrushingRecipeBuilder)hammerBuilder.addInput(recipeMetals.getOre())).build(out, this.toRL("crafting/hammercrushing_" + recipeMetals.getName()));
                crusherBuilder = CrusherRecipeBuilder.builder(recipeMetals.getDust(), 2);
                if (!recipeMetals.isNative()) {
                    ((CrusherRecipeBuilder)crusherBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getDust()))).addCondition(Recipes.getTagCondition(recipeMetals.getOre()));
                }
                if (secondaryOutputs != null) {
                    for (SecondaryOutput secondaryOutput : secondaryOutputs) {
                        crusherBuilder.addSecondary(secondaryOutput.getItem(), secondaryOutput.getChance(), secondaryOutput.getConditions());
                    }
                }
                ((CrusherRecipeBuilder)((CrusherRecipeBuilder)crusherBuilder.addInput(recipeMetals.getOre())).setEnergy(6000)).build(out, this.toRL("crusher/ore_" + recipeMetals.getName()));
                crusherBuilder = CrusherRecipeBuilder.builder(recipeMetals.getDust(), 1);
                if (!recipeMetals.isNative()) {
                    ((CrusherRecipeBuilder)crusherBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getDust()))).addCondition(Recipes.getTagCondition(recipeMetals.getIngot()));
                }
                ((CrusherRecipeBuilder)((CrusherRecipeBuilder)crusherBuilder.addInput(recipeMetals.getIngot())).setEnergy(3000)).build(out, this.toRL("crusher/ingot_" + recipeMetals.getName()));
                arcBuilder = ArcFurnaceRecipeBuilder.builder(recipeMetals.getIngot(), 2);
                if (!recipeMetals.isNative()) {
                    ((ArcFurnaceRecipeBuilder)arcBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getIngot()))).addCondition(Recipes.getTagCondition(recipeMetals.getOre()));
                }
                ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)arcBuilder.addIngredient("input", recipeMetals.getOre())).addSlag(IETags.slag, 1).setTime(200)).setEnergy(102400)).build(out, this.toRL("arcfurnace/ore_" + recipeMetals.getName()));
                arcBuilder = ArcFurnaceRecipeBuilder.builder(recipeMetals.getIngot(), 1);
                if (!recipeMetals.isNative()) {
                    ((ArcFurnaceRecipeBuilder)arcBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getIngot()))).addCondition(Recipes.getTagCondition(recipeMetals.getDust()));
                }
                ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)arcBuilder.addIngredient("input", recipeMetals.getDust())).setTime(100)).setEnergy(51200)).build(out, this.toRL("arcfurnace/dust_" + recipeMetals.getName()));
            }
            ItemTags.Wrapper plate = new ItemTags.Wrapper(IETags.getPlate(recipeMetals.getName()));
            MetalPressRecipeBuilder pressBuilder = MetalPressRecipeBuilder.builder(IEItems.Molds.moldPlate, (Tag<Item>)plate, 1);
            if (!recipeMetals.isNative()) {
                ((MetalPressRecipeBuilder)pressBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getIngot()))).addCondition(Recipes.getTagCondition(plate));
            }
            ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)pressBuilder.addInput(recipeMetals.getIngot())).setEnergy(2400)).build(out, this.toRL("metalpress/plate_" + recipeMetals.getName()));
            ItemTags.Wrapper gear = new ItemTags.Wrapper(IETags.getGear(recipeMetals.getName()));
            pressBuilder = MetalPressRecipeBuilder.builder(IEItems.Molds.moldGear, (Tag<Item>)gear, 1);
            if (!recipeMetals.isNative()) {
                pressBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getIngot()));
            }
            ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)pressBuilder.addCondition(Recipes.getTagCondition(gear))).addInput(new IngredientWithSize(recipeMetals.getIngot(), 4))).setEnergy(2400)).build(out, this.toRL("metalpress/gear_" + recipeMetals.getName()));
            ItemTags.Wrapper rods = new ItemTags.Wrapper(IETags.getRod(recipeMetals.getName()));
            pressBuilder = MetalPressRecipeBuilder.builder(IEItems.Molds.moldRod, (Tag<Item>)rods, 2);
            if (!recipeMetals.isNative()) {
                pressBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getIngot()));
            }
            ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)pressBuilder.addCondition(Recipes.getTagCondition(rods))).addInput(recipeMetals.getIngot())).setEnergy(2400)).build(out, this.toRL("metalpress/rod_" + recipeMetals.getName()));
            ItemTags.Wrapper wire = new ItemTags.Wrapper(IETags.getWire(recipeMetals.getName()));
            pressBuilder = MetalPressRecipeBuilder.builder(IEItems.Molds.moldWire, (Tag<Item>)wire, 2);
            if (!recipeMetals.isNative()) {
                pressBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getIngot()));
            }
            ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)pressBuilder.addCondition(Recipes.getTagCondition(wire))).addInput(recipeMetals.getIngot())).setEnergy(2400)).build(out, this.toRL("metalpress/wire_" + recipeMetals.getName()));
            RecipeMetals.AlloyProperties alloy = recipeMetals.getAlloyProperties();
            if (alloy == null) continue;
            IngredientWithSize[] ingredients = alloy.getAlloyIngredients();
            if (alloy.isSimple()) {
                AlloyRecipeBuilder alloyBuilder = AlloyRecipeBuilder.builder(recipeMetals.getIngot(), alloy.getOutputSize());
                if (!recipeMetals.isNative()) {
                    alloyBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getIngot()));
                }
                for (ICondition condition : alloy.getConditions()) {
                    alloyBuilder.addCondition(condition);
                }
                for (IngredientWithSize ingr : ingredients) {
                    alloyBuilder.addInput(ingr);
                }
                alloyBuilder.build(out, this.toRL("alloysmelter/" + recipeMetals.getName()));
            }
            arcBuilder = ArcFurnaceRecipeBuilder.builder(recipeMetals.getIngot(), alloy.getOutputSize());
            if (!recipeMetals.isNative()) {
                arcBuilder.addCondition(Recipes.getTagCondition(recipeMetals.getIngot()));
            }
            for (ICondition condition : alloy.getConditions()) {
                arcBuilder.addCondition(condition);
            }
            arcBuilder.addIngredient("input", ingredients[0]);
            for (int i = 1; i < ingredients.length; ++i) {
                arcBuilder.addInput(ingredients[i]);
            }
            ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)arcBuilder.setTime(100)).setEnergy(51200)).build(out, this.toRL("arcfurnace/alloy_" + recipeMetals.getName()));
        }
        for (Enum enum_ : RecipeOres.values()) {
            secondaryOutputs = ((RecipeOres)enum_).getSecondaryOutputs();
            crusherBuilder = CrusherRecipeBuilder.builder(((RecipeOres)enum_).getOutput());
            if (!((RecipeOres)enum_).isNative()) {
                crusherBuilder.addCondition(Recipes.getTagCondition(((RecipeOres)enum_).getOre()));
            }
            if (secondaryOutputs != null) {
                for (SecondaryOutput secondaryOutput : secondaryOutputs) {
                    crusherBuilder.addSecondary(secondaryOutput.getItem(), secondaryOutput.getChance(), secondaryOutput.getConditions());
                }
            }
            ((CrusherRecipeBuilder)((CrusherRecipeBuilder)crusherBuilder.addInput(((RecipeOres)enum_).getOre())).setEnergy(6000)).build(out, this.toRL("crusher/ore_" + ((RecipeOres)enum_).getName()));
        }
        ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder(IEItems.Molds.moldBulletCasing, new ItemStack((IItemProvider)IEItems.Ingredients.emptyCasing, 2)).addInput(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).setEnergy(2400)).build(out, this.toRL("metalpress/bullet_casing"));
        ItemStack electrode = new ItemStack((IItemProvider)IEItems.Misc.graphiteElectrode);
        electrode.func_196085_b((Integer)IEConfig.MACHINES.arcfurnace_electrodeDamage.get() / 2);
        ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder(IEItems.Molds.moldRod, electrode).addInput(new IngredientWithSize(IETags.hopGraphiteIngot, 4))).setEnergy(4800)).build(out, this.toRL("metalpress/electrode"));
        ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder(IEItems.Molds.moldUnpacking, new ItemStack((IItemProvider)Items.field_151127_ba, 9)).addInput(new IItemProvider[]{Items.field_221794_dg})).setEnergy(3200)).build(out, this.toRL("metalpress/melon"));
        ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, 1).addIngredient("input", (Tag<Item>)Tags.Items.INGOTS_IRON)).addInput(IETags.coalCokeDust)).addSlag(IETags.slag, 1).setTime(400)).setEnergy(204800)).build(out, this.toRL("arcfurnace/steel"));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder(Items.field_221648_al).addInput(new IItemProvider[]{Items.field_221646_ak})).addFluidTag((Tag<Fluid>)FluidTags.field_206959_a, 1000)).build(out, this.toRL("bottling/sponge"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(Items.field_221550_C).addInput((Tag<Item>)Tags.Items.COBBLESTONE)).setEnergy(1600)).build(out, this.toRL("crusher/cobblestone"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(Items.field_221548_A).addSecondary((IItemProvider)Items.field_151145_ak, 0.1f).addInput((Tag<Item>)Tags.Items.GRAVEL)).setEnergy(1600)).build(out, this.toRL("crusher/gravel"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(Items.field_221548_A).addInput(IETags.slag)).setEnergy(1600)).build(out, this.toRL("crusher/slag"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(Items.field_221548_A).addInput((Tag<Item>)Tags.Items.GLASS)).setEnergy(3200)).build(out, this.toRL("crusher/glass"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_221548_A, 2)).addSecondary(IETags.saltpeterDust, 0.5f).addInput((Tag<Item>)Tags.Items.SANDSTONE)).setEnergy(3200)).build(out, this.toRL("crusher/sandstone"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151119_aD, 4)).addInput(IETags.getItemTag(IETags.clayBlock))).setEnergy(1600)).build(out, this.toRL("crusher/clay"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151128_bU, 4)).addInput((Tag<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ)).setEnergy(3200)).build(out, this.toRL("crusher/quartz"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151114_aO, 4)).addInput(new IItemProvider[]{Blocks.field_150426_aN})).setEnergy(3200)).build(out, this.toRL("crusher/quartz"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151065_br, 4)).addSecondary(IETags.sulfurDust, 0.5f).addInput((Tag<Item>)Tags.Items.RODS_BLAZE)).setEnergy(1600)).build(out, this.toRL("crusher/blaze_powder"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_196106_bc, 6)).addInput(new IItemProvider[]{Items.field_151103_aS})).setEnergy(1600)).build(out, this.toRL("crusher/bone_meal"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(IETags.coalCokeDust, 1).addInput(IETags.coalCoke)).setEnergy(2400)).build(out, this.toRL("crusher/coke"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(IETags.coalCokeDust, 9).addInput(IETags.getItemTag(IETags.coalCokeBlock))).setEnergy(4800)).build(out, this.toRL("crusher/coke_block"));
        ItemTags.Wrapper coal_dust = new ItemTags.Wrapper(IETags.getDust("coal"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder((Tag<Item>)coal_dust, 1).addCondition(Recipes.getTagCondition(coal_dust))).addInput(new IItemProvider[]{Items.field_151044_h})).setEnergy(2400)).build(out, this.toRL("crusher/coal"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder((Tag<Item>)coal_dust, 9).addCondition(Recipes.getTagCondition(coal_dust))).addInput(new IItemProvider[]{Items.field_221896_ff})).setEnergy(4800)).build(out, this.toRL("crusher/coal_block"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder(new ItemStack((IItemProvider)Items.field_151007_F, 4)).addInput((Tag<Item>)ItemTags.field_199904_a)).setEnergy(3200)).build(out, this.toRL("crusher/wool"));
        ((SqueezerRecipeBuilder)((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder((Fluid)IEContent.fluidPlantoil, 80).addInput(new IItemProvider[]{Items.field_151014_N})).setEnergy(6400)).build(out, this.toRL("squeezer/wheat_seeds"));
        ((SqueezerRecipeBuilder)((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder((Fluid)IEContent.fluidPlantoil, 60).addInput(new IItemProvider[]{Items.field_185163_cU})).setEnergy(6400)).build(out, this.toRL("squeezer/beetroot_seeds"));
        ((SqueezerRecipeBuilder)((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder((Fluid)IEContent.fluidPlantoil, 40).addInput(new IItemProvider[]{Items.field_151080_bb})).setEnergy(6400)).build(out, this.toRL("squeezer/pumpkin_seeds"));
        ((SqueezerRecipeBuilder)((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder((Fluid)IEContent.fluidPlantoil, 20).addInput(new IItemProvider[]{Items.field_151081_bc})).setEnergy(6400)).build(out, this.toRL("squeezer/melon_seeds"));
        ((SqueezerRecipeBuilder)((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder((Fluid)IEContent.fluidPlantoil, 120).addInput(new IItemProvider[]{IEItems.Misc.hempSeeds})).setEnergy(6400)).build(out, this.toRL("squeezer/hemp_seeds"));
        ((SqueezerRecipeBuilder)((SqueezerRecipeBuilder)((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder().addResult(new IngredientWithSize(IETags.hopGraphiteDust))).addInput(new IngredientWithSize(IETags.coalCokeDust, 8))).setEnergy(19200)).build(out, this.toRL("squeezer/graphite_dust"));
        ((FermenterRecipeBuilder)((FermenterRecipeBuilder)FermenterRecipeBuilder.builder((Fluid)IEContent.fluidEthanol, 80).addInput(new IItemProvider[]{Items.field_222065_kN})).setEnergy(6400)).build(out, this.toRL("fermenter/sugar_cane"));
        ((FermenterRecipeBuilder)((FermenterRecipeBuilder)FermenterRecipeBuilder.builder((Fluid)IEContent.fluidEthanol, 80).addInput(new IItemProvider[]{Items.field_151127_ba})).setEnergy(6400)).build(out, this.toRL("fermenter/melon_slice"));
        ((FermenterRecipeBuilder)((FermenterRecipeBuilder)FermenterRecipeBuilder.builder((Fluid)IEContent.fluidEthanol, 80).addInput(new IItemProvider[]{Items.field_151034_e})).setEnergy(6400)).build(out, this.toRL("fermenter/apple"));
        ((FermenterRecipeBuilder)((FermenterRecipeBuilder)FermenterRecipeBuilder.builder((Fluid)IEContent.fluidEthanol, 80).addInput((Tag<Item>)Tags.Items.CROPS_POTATO)).setEnergy(6400)).build(out, this.toRL("fermenter/potato"));
        ((RefineryRecipeBuilder)RefineryRecipeBuilder.builder((Fluid)IEContent.fluidBiodiesel, 16).addInput(IETags.fluidPlantoil, 8).addInput(IETags.fluidEthanol, 8).setEnergy(80)).build(out, this.toRL("refinery/biodiesel"));
        ((MixerRecipeBuilder)((MixerRecipeBuilder)((MixerRecipeBuilder)((MixerRecipeBuilder)((MixerRecipeBuilder)MixerRecipeBuilder.builder((Fluid)IEContent.fluidConcrete, 500).addFluidTag((Tag<Fluid>)FluidTags.field_206959_a, 500)).addInput(new IngredientWithSize((Tag<Item>)Tags.Items.SAND, 2))).addInput((Tag<Item>)Tags.Items.GRAVEL)).addInput(IETags.clay)).setEnergy(3200)).build(out, this.toRL("mixer/concrete"));
        ((MixerRecipeBuilder)((MixerRecipeBuilder)((MixerRecipeBuilder)((MixerRecipeBuilder)((MixerRecipeBuilder)MixerRecipeBuilder.builder((Fluid)IEContent.fluidConcrete, 500).addFluidTag((Tag<Fluid>)FluidTags.field_206959_a, 500)).addInput(new IngredientWithSize(IETags.slag, 2))).addInput((Tag<Item>)Tags.Items.GRAVEL)).addInput(IETags.clay)).setEnergy(3200)).build(out, this.toRL("mixer/concrete"));
    }

    private void mineralMixes(@Nonnull Consumer<IFinishedRecipe> out) {
        Tag iron = Tags.Items.ORES_IRON;
        Tag gold = Tags.Items.ORES_GOLD;
        Tag<Item> copper = IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ore);
        Tag<Item> aluminum = IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ore);
        Tag<Item> lead = IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).ore);
        Tag<Item> silver = IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).ore);
        Tag<Item> nickel = IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).ore);
        Tag<Item> uranium = IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.URANIUM).ore);
        ItemTags.Wrapper tin = new ItemTags.Wrapper(IETags.getOre("tin"));
        ItemTags.Wrapper titanium = new ItemTags.Wrapper(IETags.getOre("titanium"));
        ItemTags.Wrapper thorium = new ItemTags.Wrapper(IETags.getOre("thorium"));
        ItemTags.Wrapper tungsten = new ItemTags.Wrapper(IETags.getOre("tungsten"));
        ItemTags.Wrapper manganese = new ItemTags.Wrapper(IETags.getOre("manganese"));
        ItemTags.Wrapper platinum = new ItemTags.Wrapper(IETags.getOre("platinum"));
        ItemTags.Wrapper paladium = new ItemTags.Wrapper(IETags.getOre("paladium"));
        ItemTags.Wrapper mercury = new ItemTags.Wrapper(IETags.getOre("mercury"));
        Tag<Item> sulfur = IETags.sulfurDust;
        ItemTags.Wrapper phosphorus = new ItemTags.Wrapper(IETags.getDust("phosphorus"));
        Tag redstone = Tags.Items.ORES_REDSTONE;
        Tag emerald = Tags.Items.ORES_EMERALD;
        Block prismarine = Blocks.field_180397_cI;
        ItemTags.Wrapper aquamarine = new ItemTags.Wrapper(IETags.getGem("aquamarine"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre((Tag<Item>)Tags.Items.ORES_COAL, 0.8f).addOre(sulfur, 0.2f).addOre((Tag<Item>)phosphorus, 0.2f, Recipes.getTagCondition(phosphorus)).setWeight(25).setFailchance(0.05f).build(out, this.toRL("mineral/bituminous_coal"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre((IItemProvider)Items.field_221776_cx, 0.5f).addOre((IItemProvider)Items.field_221548_A, 0.3f).addOre((IItemProvider)Items.field_221550_C, 0.2f).setWeight(25).setFailchance(0.05f).build(out, this.toRL("mineral/silt"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre((IItemProvider)Blocks.field_196650_c, 0.3f).addOre((IItemProvider)Blocks.field_196654_e, 0.3f).addOre((IItemProvider)Blocks.field_196656_g, 0.3f).addOre((IItemProvider)Blocks.field_150343_Z, 0.1f).setWeight(25).setFailchance(0.05f).build(out, this.toRL("mineral/igneous_rock"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre((Tag<Item>)iron, 0.35f).addOre(nickel, 0.35f).addOre(sulfur, 0.3f).setWeight(25).setFailchance(0.05f).build(out, this.toRL("mineral/pentlandite"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre((Tag<Item>)iron, 0.35f).addOre(copper, 0.35f).addOre(sulfur, 0.3f).setWeight(20).setFailchance(0.05f).build(out, this.toRL("mineral/chalcopyrite"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre(aluminum, 0.7f).addOre((Tag<Item>)iron, 0.2f).addOre((Tag<Item>)titanium, 0.1f, Recipes.getTagCondition(titanium)).setWeight(20).setFailchance(0.05f).build(out, this.toRL("mineral/laterite"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre(copper, 0.75f).addOre((Tag<Item>)gold, 0.25f).setWeight(30).setFailchance(0.1f).build(out, this.toRL("mineral/auricupride"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre(lead, 0.4f).addOre(sulfur, 0.4f).addOre(silver, 0.2f).setWeight(15).setFailchance(0.05f).build(out, this.toRL("mineral/galena"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre((Tag<Item>)redstone, 0.6f).addOre(sulfur, 0.4f).addOre((Tag<Item>)mercury, 0.3f, Recipes.getTagCondition(mercury)).setWeight(15).setFailchance(0.1f).build(out, this.toRL("mineral/cinnabar"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre(uranium, 0.7f).addOre(lead, 0.3f).addOre((Tag<Item>)thorium, 0.1f, Recipes.getTagCondition(thorium)).setWeight(10).setFailchance(0.15f).build(out, this.toRL("mineral/uraninite"));
        MineralMixBuilder.builder(DimensionType.field_223227_a_).addOre((Tag<Item>)emerald, 0.3f).addOre((IItemProvider)prismarine, 0.7f).addOre((Tag<Item>)aquamarine, 0.3f, Recipes.getTagCondition(aquamarine)).setWeight(5).setFailchance(0.2f).build(out, this.toRL("mineral/beryl"));
        MineralMixBuilder.builder(DimensionType.field_223228_b_).addOre((IItemProvider)Blocks.field_196766_fg, 0.8f).addOre(sulfur, 0.2f).setWeight(20).setFailchance(0.15f).setBackground(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)Blocks.field_150424_aL)).build(out, this.toRL("mineral/mephitic_quarzite"));
        ((MineralMixBuilder)MineralMixBuilder.builder(DimensionType.field_223227_a_).addCondition(Recipes.getTagCondition(tin))).addOre((Tag<Item>)tin, 1.0f).setWeight(20).setFailchance(0.05f).build(out, this.toRL("mineral/cassiterite"));
        ((MineralMixBuilder)MineralMixBuilder.builder(DimensionType.field_223227_a_).addCondition(Recipes.getTagCondition(platinum))).addOre((Tag<Item>)platinum, 0.5f).addOre((Tag<Item>)paladium, 0.5f, Recipes.getTagCondition(paladium)).addOre(nickel, 0.5f).setWeight(5).setFailchance(0.1f).build(out, this.toRL("mineral/cooperite"));
        ((MineralMixBuilder)MineralMixBuilder.builder(DimensionType.field_223227_a_).addCondition(Recipes.getTagCondition(tungsten))).addOre((Tag<Item>)tungsten, 0.5f).addOre((Tag<Item>)iron, 0.5f).addOre((Tag<Item>)manganese, 0.5f, Recipes.getTagCondition(manganese)).setWeight(5).setFailchance(0.1f).build(out, this.toRL("mineral/wolframite"));
    }

    private void recipesStoneDecorations(@Nonnull Consumer<IFinishedRecipe> out) {
        this.addCornerStraightMiddle((IItemProvider)IEBlocks.StoneDecoration.cokebrick, 3, this.makeIngredient(IETags.clay), this.makeIngredient((Tag<Item>)Tags.Items.INGOTS_BRICK), this.makeIngredient((Tag<Item>)Tags.Items.SANDSTONE), out);
        this.addCornerStraightMiddle((IItemProvider)IEBlocks.StoneDecoration.blastbrick, 3, this.makeIngredient((Tag<Item>)Tags.Items.INGOTS_NETHER_BRICK), this.makeIngredient((Tag<Item>)Tags.Items.INGOTS_BRICK), this.makeIngredient((IItemProvider)Blocks.field_196814_hQ), out);
        this.addSandwich((IItemProvider)IEBlocks.StoneDecoration.hempcrete, 6, this.makeIngredient(IETags.clay), this.makeIngredient(IETags.fiberHemp), this.makeIngredient(IETags.clay), out);
        this.add3x3Conversion((IItemProvider)IEBlocks.StoneDecoration.coke, (IItemProvider)IEItems.Ingredients.coalCoke, IETags.coalCoke, out);
        this.addStairs((IItemProvider)IEBlocks.StoneDecoration.hempcrete, (IItemProvider)IEBlocks.StoneDecoration.hempcreteStairs, out);
        this.addStairs((IItemProvider)IEBlocks.StoneDecoration.concrete, (IItemProvider)IEBlocks.StoneDecoration.concreteStairs[0], out);
        this.addStairs((IItemProvider)IEBlocks.StoneDecoration.concreteTile, (IItemProvider)IEBlocks.StoneDecoration.concreteStairs[1], out);
        this.addStairs((IItemProvider)IEBlocks.StoneDecoration.concreteLeaded, (IItemProvider)IEBlocks.StoneDecoration.concreteStairs[2], out);
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.hempcrete}), (IItemProvider)((IItemProvider)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.hempcrete)), (int)2).func_218643_a("has_hempcrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.hempcrete)).func_218647_a(out, this.toRL("hempcrete_slab_from_hempcrete_stonecutting"));
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.hempcrete}), (IItemProvider)IEBlocks.StoneDecoration.hempcreteStairs).func_218643_a("has_hempcrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.hempcrete)).func_218647_a(out, this.toRL("hempcrete_stairs_from_hempcrete_stonecutting"));
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.concrete}), (IItemProvider)((IItemProvider)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.concrete)), (int)2).func_218643_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_218647_a(out, this.toRL("concrete_slab_from_concrete_stonecutting"));
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.concrete}), (IItemProvider)IEBlocks.StoneDecoration.concreteStairs[0]).func_218643_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_218647_a(out, this.toRL("concrete_stairs_from_concrete_stonecutting"));
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.concreteTile}), (IItemProvider)((IItemProvider)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.concreteTile)), (int)2).func_218643_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_218647_a(out, this.toRL("concrete_tile_slab_from_concrete_tile_stonecutting"));
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.concreteTile}), (IItemProvider)IEBlocks.StoneDecoration.concreteStairs[1]).func_218643_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_218647_a(out, this.toRL("concrete_tile_stairs_from_concrete_tile_stonecutting"));
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.concreteLeaded}), (IItemProvider)((IItemProvider)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.concreteLeaded)), (int)2).func_218643_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_218647_a(out, this.toRL("concrete_leaded_slab_from_concrete_leaded_stonecutting"));
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.concreteLeaded}), (IItemProvider)IEBlocks.StoneDecoration.concreteStairs[2]).func_218643_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_218647_a(out, this.toRL("concrete_leaded_stairs_from_concrete_leaded_stonecutting"));
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEBlocks.StoneDecoration.concrete}), (IItemProvider)IEBlocks.StoneDecoration.concreteTile).func_218643_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_218647_a(out, this.toRL("concrete_tile_from_concrete_stonecutting"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.StoneDecoration.alloybrick, (int)2).func_200472_a("sb").func_200472_a("bs").func_200469_a(Character.valueOf('s'), Tags.Items.SANDSTONE).func_200469_a(Character.valueOf('b'), Tags.Items.INGOTS_BRICK).func_200465_a("has_brick", (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_BRICK)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.StoneDecoration.alloybrick)));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)IEBlocks.StoneDecoration.blastbrickReinforced).func_200487_b((IItemProvider)IEBlocks.StoneDecoration.blastbrick).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).func_200483_a("has_blastbrick", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.blastbrick)).func_200485_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.StoneDecoration.blastbrickReinforced)));
        TurnAndCopyRecipeBuilder.builder((IItemProvider)IEBlocks.StoneDecoration.concrete, 8).allowQuarterTurn().func_200473_b("ie_concrete").func_200472_a("scs").func_200472_a("gbg").func_200472_a("scs").func_200469_a(Character.valueOf('s'), Tags.Items.SAND).func_200469_a(Character.valueOf('c'), IETags.clay).func_200469_a(Character.valueOf('g'), Tags.Items.GRAVEL).func_200471_a(Character.valueOf('b'), (Ingredient)new IngredientFluidStack((Tag<Fluid>)FluidTags.field_206959_a, 1000)).func_200465_a("has_clay", (ICriterionInstance)this.func_200409_a(IETags.clay)).func_200467_a(out, this.toRL("concrete"));
        TurnAndCopyRecipeBuilder.builder((IItemProvider)IEBlocks.StoneDecoration.concrete, 12).allowQuarterTurn().func_200473_b("ie_concrete").func_200472_a("scs").func_200472_a("gbg").func_200472_a("scs").func_200462_a(Character.valueOf('s'), (IItemProvider)IEItems.Ingredients.slag).func_200469_a(Character.valueOf('c'), IETags.clay).func_200469_a(Character.valueOf('g'), Tags.Items.GRAVEL).func_200471_a(Character.valueOf('b'), (Ingredient)new IngredientFluidStack((Tag<Fluid>)FluidTags.field_206959_a, 1000)).func_200465_a("has_slag", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.slag)).func_200467_a(out, this.toRL("concrete"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.StoneDecoration.concreteTile, (int)4).func_200473_b("ie_concrete").func_200472_a("cc").func_200472_a("cc").func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.StoneDecoration.concrete).func_200465_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.StoneDecoration.concreteTile)));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)IEBlocks.StoneDecoration.concreteLeaded).func_200487_b((IItemProvider)IEBlocks.StoneDecoration.concrete).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).plate).func_200483_a("has_concrete", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.StoneDecoration.concrete)).func_200485_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.StoneDecoration.concreteLeaded)));
        TurnAndCopyRecipeBuilder.builder((IItemProvider)IEBlocks.StoneDecoration.insulatingGlass, 2).allowQuarterTurn().func_200472_a(" g ").func_200472_a("idi").func_200472_a(" g ").func_200469_a(Character.valueOf('g'), Tags.Items.GLASS).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).dust).func_200469_a(Character.valueOf('d'), Tags.Items.DYES_GREEN).func_200465_a("has_glass", (ICriterionInstance)this.func_200409_a(Tags.Items.GLASS)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.StoneDecoration.insulatingGlass)));
    }

    private void recipesWoodenDecorations(@Nonnull Consumer<IFinishedRecipe> out) {
        for (TreatedWoodStyles style : TreatedWoodStyles.values()) {
            this.addStairs((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)style), (IItemProvider)IEBlocks.WoodenDecoration.treatedStairs.get((Object)style), out);
        }
        int numTreatedStyles = TreatedWoodStyles.values().length;
        for (TreatedWoodStyles from : TreatedWoodStyles.values()) {
            TreatedWoodStyles to = TreatedWoodStyles.values()[(from.ordinal() + 1) % numTreatedStyles];
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)to))).func_200487_b((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)from)).func_200483_a("has_" + this.toPath((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)from)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)from))).func_200485_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)to)) + "_from_" + from.toString().toLowerCase()));
        }
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.WoodenDecoration.treatedScaffolding, (int)6).func_200472_a("iii").func_200472_a(" s ").func_200472_a("s s").func_200469_a(Character.valueOf('i'), IETags.getItemTag(IETags.treatedWood)).func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200465_a("has_treated_sticks", (ICriterionInstance)this.func_200409_a(IETags.treatedStick)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDecoration.treatedScaffolding)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.WoodenDecoration.treatedFence, (int)3).func_200472_a("isi").func_200472_a("isi").func_200469_a(Character.valueOf('i'), IETags.getItemTag(IETags.treatedWood)).func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200465_a("has_treated_sticks", (ICriterionInstance)this.func_200409_a(IETags.treatedStick)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDecoration.treatedFence)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDecoration.treatedPost).func_200472_a("f").func_200472_a("f").func_200472_a("s").func_200462_a(Character.valueOf('f'), (IItemProvider)IEBlocks.WoodenDecoration.treatedFence).func_200462_a(Character.valueOf('s'), (IItemProvider)Blocks.field_196696_di).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.WoodenDecoration.treatedFence), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.WoodenDecoration.treatedFence)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDecoration.treatedPost)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)TreatedWoodStyles.HORIZONTAL)), (int)8).func_200472_a("www").func_200472_a("wbw").func_200472_a("www").func_200469_a(Character.valueOf('w'), ItemTags.field_199905_b).func_200471_a(Character.valueOf('b'), (Ingredient)new IngredientFluidStack(IETags.fluidCreosote, 1000)).func_200465_a("has_creosote", (ICriterionInstance)this.func_200403_a((IItemProvider)IEContent.fluidCreosote.func_204524_b())).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDecoration.treatedWood.get((Object)TreatedWoodStyles.HORIZONTAL))));
    }

    private void recipesWoodenDevices(@Nonnull Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.craftingTable).func_200472_a("sss").func_200472_a("rcr").func_200472_a("r r").func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.treatedWoodSlab)).func_200469_a(Character.valueOf('r'), IETags.treatedStick).func_200462_a(Character.valueOf('c'), (IItemProvider)Blocks.field_150462_ai).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.craftingTable)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.crate).func_200472_a("ppp").func_200472_a("p p").func_200472_a("ppp").func_200469_a(Character.valueOf('p'), IETags.getItemTag(IETags.treatedWood)).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.crate)));
        TurnAndCopyRecipeBuilder.builder((IItemProvider)IEBlocks.WoodenDevices.reinforcedCrate).setNBTCopyTargetRecipe(4).allowQuarterTurn().func_200472_a("wpw").func_200472_a("rcr").func_200472_a("wpw").func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200469_a(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200469_a(Character.valueOf('r'), IETags.ironRod).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.WoodenDevices.crate).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.reinforcedCrate)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.WoodenDevices.treatedWallmount, (int)4).func_200472_a("ww").func_200472_a("ws").func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.treatedWallmount)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.sorter).func_200472_a("wrw").func_200472_a("ici").func_200472_a("wbw").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200462_a(Character.valueOf('b'), (IItemProvider)ConveyorHandler.getBlock(BasicConveyor.NAME)).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_" + this.toPath((IItemProvider)ConveyorHandler.getBlock(BasicConveyor.NAME)), (ICriterionInstance)this.func_200403_a((IItemProvider)ConveyorHandler.getBlock(BasicConveyor.NAME))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.sorter)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.itemBatcher).func_200472_a("wrw").func_200472_a("ici").func_200472_a("wpw").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200462_a(Character.valueOf('p'), (IItemProvider)IEItems.Ingredients.circuitBoard).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_" + this.toPath((IItemProvider)ConveyorHandler.getBlock(BasicConveyor.NAME)), (ICriterionInstance)this.func_200403_a((IItemProvider)ConveyorHandler.getBlock(BasicConveyor.NAME))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.itemBatcher)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.fluidSorter).func_200472_a("wrw").func_200472_a("ici").func_200472_a("wbw").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200462_a(Character.valueOf('b'), (IItemProvider)IEBlocks.MetalDevices.fluidPipe).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDevices.fluidPipe), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDevices.fluidPipe)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.fluidSorter)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.turntable).func_200472_a("iwi").func_200472_a("rcr").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.lvCoil), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.lvCoil)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.turntable)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.windmill).func_200472_a("ppp").func_200472_a("pip").func_200472_a("ppp").func_200462_a(Character.valueOf('p'), (IItemProvider)IEItems.Ingredients.windmillBlade).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.windmillBlade), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.windmillBlade)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.windmill)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.watermill).func_200472_a(" p ").func_200472_a("pip").func_200472_a(" p ").func_200462_a(Character.valueOf('p'), (IItemProvider)IEItems.Ingredients.waterwheelSegment).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.waterwheelSegment), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.waterwheelSegment)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.watermill)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.gunpowderBarrel).func_200472_a(" f ").func_200472_a("gbg").func_200472_a("ggg").func_200462_a(Character.valueOf('f'), (IItemProvider)IEItems.Ingredients.hempFiber).func_200469_a(Character.valueOf('g'), Tags.Items.GUNPOWDER).func_200462_a(Character.valueOf('b'), (IItemProvider)IEBlocks.WoodenDevices.woodenBarrel).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.WoodenDevices.woodenBarrel), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.WoodenDevices.woodenBarrel)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.gunpowderBarrel)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.workbench).func_200472_a("iss").func_200472_a("c f").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.treatedWoodSlab)).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.WoodenDevices.craftingTable).func_200462_a(Character.valueOf('f'), (IItemProvider)IEBlocks.WoodenDecoration.treatedFence).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.workbench)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.WoodenDevices.woodenBarrel).func_200472_a("sss").func_200472_a("w w").func_200472_a("www").func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.treatedWoodSlab)).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.WoodenDevices.woodenBarrel)));
    }

    /*
     * WARNING - void declaration
     */
    private void recipesMetalDecorations(@Nonnull Consumer<IFinishedRecipe> out) {
        void var5_12;
        for (DyeColor dyeColor : DyeColor.values()) {
            ItemTags.Wrapper dyeTag = new ItemTags.Wrapper(new ResourceLocation("forge", "dyes/" + dyeColor.func_176762_d()));
            Block coloredSheetmetal = IEBlocks.MetalDecoration.coloredSheetmetal.get(dyeColor);
            ShapedRecipeBuilder.func_200468_a((IItemProvider)coloredSheetmetal, (int)8).func_200472_a("sss").func_200472_a("sds").func_200472_a("sss").func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.sheetmetals)).func_200469_a(Character.valueOf('d'), (Tag)dyeTag).func_200465_a("has_sheetmetal", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.sheetmetals))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)coloredSheetmetal)));
        }
        for (MetalScaffoldingType metalScaffoldingType : MetalScaffoldingType.values()) {
            this.addStairs((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)metalScaffoldingType), (IItemProvider)IEBlocks.MetalDecoration.steelScaffoldingStair.get((Object)metalScaffoldingType), out);
            this.addStairs((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)metalScaffoldingType), (IItemProvider)IEBlocks.MetalDecoration.aluScaffoldingStair.get((Object)metalScaffoldingType), out);
        }
        int n = MetalScaffoldingType.values().length;
        MetalScaffoldingType[] metalScaffoldingTypeArray = MetalScaffoldingType.values();
        int n2 = metalScaffoldingTypeArray.length;
        boolean bl = false;
        while (var5_12 < n2) {
            MetalScaffoldingType from = metalScaffoldingTypeArray[var5_12];
            MetalScaffoldingType to = MetalScaffoldingType.values()[(from.ordinal() + 1) % n];
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)to))).func_200487_b((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)from)).func_200483_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)from)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)from))).func_200485_a(out, this.toRL("alu_scaffolding_" + to.name().toLowerCase() + "_from_" + from.name().toLowerCase()));
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)to))).func_200487_b((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)from)).func_200483_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)from)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)from))).func_200485_a(out, this.toRL("steel_scaffolding_" + to.name().toLowerCase() + "_from_" + from.name().toLowerCase()));
            ++var5_12;
        }
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)MetalScaffoldingType.STANDARD)), (int)6).func_200472_a("iii").func_200472_a(" s ").func_200472_a("s s").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200469_a(Character.valueOf('s'), IETags.aluminumRod).func_200465_a("has_alu_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot)).func_200465_a("has_alu_sticks", (ICriterionInstance)this.func_200409_a(IETags.aluminumRod)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)MetalScaffoldingType.STANDARD))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.slopeAlu).func_200472_a("sss").func_200472_a("ss ").func_200472_a("s  ").func_200462_a(Character.valueOf('s'), (IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)MetalScaffoldingType.STANDARD)).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)MetalScaffoldingType.STANDARD)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.aluScaffolding.get((Object)MetalScaffoldingType.STANDARD))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.slopeAlu)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD)), (int)6).func_200472_a("iii").func_200472_a(" s ").func_200472_a("s s").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200469_a(Character.valueOf('s'), IETags.steelRod).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200465_a("has_steel_sticks", (ICriterionInstance)this.func_200409_a(IETags.steelRod)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.slopeSteel).func_200472_a("sss").func_200472_a("ss ").func_200472_a("s  ").func_200462_a(Character.valueOf('s'), (IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD)).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.slopeSteel)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.MetalDecoration.aluFence, (int)3).func_200472_a("isi").func_200472_a("isi").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200469_a(Character.valueOf('s'), IETags.aluminumRod).func_200465_a("has_alu_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot)).func_200465_a("has_alu_sticks", (ICriterionInstance)this.func_200409_a(IETags.aluminumRod)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.aluFence)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.MetalDecoration.steelFence, (int)3).func_200472_a("isi").func_200472_a("isi").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200469_a(Character.valueOf('s'), IETags.steelRod).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200465_a("has_steel_sticks", (ICriterionInstance)this.func_200409_a(IETags.steelRod)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelFence)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200472_a("www").func_200472_a("wiw").func_200472_a("www").func_200469_a(Character.valueOf('i'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('w'), (IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER)).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.lvCoil)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.mvCoil).func_200472_a("www").func_200472_a("wiw").func_200472_a("www").func_200469_a(Character.valueOf('i'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('w'), (IItemProvider)IEItems.Misc.wireCoils.get(WireType.ELECTRUM)).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Misc.wireCoils.get(WireType.ELECTRUM)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Misc.wireCoils.get(WireType.ELECTRUM))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.mvCoil)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.hvCoil).func_200472_a("www").func_200472_a("wiw").func_200472_a("www").func_200469_a(Character.valueOf('i'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('w'), (IItemProvider)IEItems.Misc.wireCoils.get(WireType.STEEL)).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Misc.wireCoils.get(WireType.STEEL)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Misc.wireCoils.get(WireType.STEEL))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.hvCoil)));
        TurnAndCopyRecipeBuilder.builder((IItemProvider)IEBlocks.MetalDecoration.engineeringRS, 4).allowQuarterTurn().func_200472_a("iri").func_200472_a("rcr").func_200472_a("iri").func_200469_a(Character.valueOf('i'), IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).sheetmetal)).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200465_a("has_iron_sheetmetal", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).sheetmetal))).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200465_a("has_redstone", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151137_ax)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.engineeringRS)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.MetalDecoration.engineeringLight, (int)4).func_200472_a("igi").func_200472_a("gcg").func_200472_a("igi").func_200469_a(Character.valueOf('i'), IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).sheetmetal)).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_iron_sheetmetal", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).sheetmetal))).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200465_a("has_component_iron", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.componentIron)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.engineeringLight)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.MetalDecoration.engineeringHeavy, (int)4).func_200472_a("igi").func_200472_a("geg").func_200472_a("igi").func_200469_a(Character.valueOf('i'), IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).sheetmetal)).func_200469_a(Character.valueOf('e'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot).func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Ingredients.componentSteel).func_200465_a("has_steel_sheetmetal", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).sheetmetal))).func_200465_a("has_electrum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).func_200465_a("has_component_steel", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.componentSteel)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.engineeringHeavy)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.MetalDecoration.generator, (int)4).func_200472_a("iei").func_200472_a("ede").func_200472_a("iei").func_200469_a(Character.valueOf('i'), IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).sheetmetal)).func_200469_a(Character.valueOf('e'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).plate).func_200462_a(Character.valueOf('d'), (IItemProvider)IEBlocks.MetalDevices.dynamo).func_200465_a("has_steel_sheetmetal", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).sheetmetal))).func_200465_a("has_electrum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDevices.dynamo), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDevices.dynamo)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.generator)));
        TurnAndCopyRecipeBuilder.builder((IItemProvider)IEBlocks.MetalDecoration.radiator, 4).allowQuarterTurn().func_200472_a("ici").func_200472_a("cbc").func_200472_a("ici").func_200469_a(Character.valueOf('i'), IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).sheetmetal)).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).plate).func_200471_a(Character.valueOf('b'), (Ingredient)new IngredientFluidStack((Tag<Fluid>)FluidTags.field_206959_a, 1000)).func_200465_a("has_steel_sheetmetal", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).sheetmetal))).func_200465_a("has_water_bucket", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151131_as)).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.radiator)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.aluPost).func_200472_a("f").func_200472_a("f").func_200472_a("s").func_200462_a(Character.valueOf('f'), (IItemProvider)IEBlocks.MetalDecoration.aluFence).func_200462_a(Character.valueOf('s'), (IItemProvider)Blocks.field_196696_di).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.aluFence), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.aluFence)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.aluPost)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.steelPost).func_200472_a("f").func_200472_a("f").func_200472_a("s").func_200462_a(Character.valueOf('f'), (IItemProvider)IEBlocks.MetalDecoration.steelFence).func_200462_a(Character.valueOf('s'), (IItemProvider)Blocks.field_196696_di).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelFence), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.steelFence)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelPost)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.aluWallmount).func_200472_a("ii").func_200472_a("is").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200469_a(Character.valueOf('s'), IETags.aluminumRod).func_200465_a("has_aluminum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.aluWallmount)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.steelWallmount).func_200472_a("ii").func_200472_a("is").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200469_a(Character.valueOf('s'), IETags.steelRod).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelWallmount)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE)), (int)3).func_200472_a("s s").func_200472_a("sss").func_200472_a("s s").func_200469_a(Character.valueOf('s'), IETags.metalRods).func_200465_a("has_metal_rod", (ICriterionInstance)this.func_200409_a(IETags.metalRods)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE))));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.ALU)), (int)3).func_200472_a("s").func_200472_a("l").func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.scaffoldingAlu)).func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE)).func_200465_a("has_metal_ladder", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.ALU))));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.STEEL)), (int)3).func_200472_a("s").func_200472_a("l").func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.scaffoldingSteel)).func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE)).func_200465_a("has_metal_ladder", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.STEEL))));
    }

    private void recipesMetalDevices(@Nonnull Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.MetalDevices.razorWire, (int)3).func_200472_a("psp").func_200472_a("sss").func_200472_a("psp").func_200462_a(Character.valueOf('s'), (IItemProvider)IEItems.Ingredients.wireSteel).func_200469_a(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.wireSteel), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.wireSteel)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.razorWire)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.capacitorLV).func_200472_a("iii").func_200472_a("clc").func_200472_a("wrw").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('l'), IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).ingot).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200465_a("has_lead_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).ingot)).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.capacitorLV)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.capacitorMV).func_200472_a("iii").func_200472_a("ele").func_200472_a("wrw").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('l'), IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).ingot).func_200469_a(Character.valueOf('e'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200469_a(Character.valueOf('r'), Tags.Items.STORAGE_BLOCKS_REDSTONE).func_200465_a("has_electrum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).func_200465_a("has_lead_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).ingot)).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.capacitorMV)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.capacitorHV).func_200472_a("sss").func_200472_a("ala").func_200472_a("wrw").func_200469_a(Character.valueOf('s'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200469_a(Character.valueOf('a'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200469_a(Character.valueOf('l'), IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).storage)).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200469_a(Character.valueOf('r'), Tags.Items.STORAGE_BLOCKS_REDSTONE).func_200465_a("has_aluminum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot)).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.capacitorHV)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.barrel).func_200472_a("sss").func_200472_a("w w").func_200472_a("www").func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).sheetmetal)).func_200462_a(Character.valueOf('s'), (IItemProvider)IEBlocks.toSlab.get(IEBlocks.Metals.sheetmetal.get((Object)EnumMetals.IRON))).func_200465_a("has_iron_sheet_slab", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.Metals.sheetmetal.get((Object)EnumMetals.IRON))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.barrel)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.fluidPump).func_200472_a(" i ").func_200472_a("ici").func_200472_a("ppp").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200462_a(Character.valueOf('p'), (IItemProvider)IEBlocks.MetalDevices.fluidPipe).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDevices.fluidPipe), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDevices.fluidPipe)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.fluidPump)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.blastFurnacePreheater).func_200472_a("sss").func_200472_a("s s").func_200472_a("shs").func_200462_a(Character.valueOf('s'), (IItemProvider)IEBlocks.Metals.sheetmetal.get((Object)EnumMetals.IRON)).func_200462_a(Character.valueOf('h'), (IItemProvider)IEBlocks.MetalDevices.furnaceHeater).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDevices.furnaceHeater), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDevices.furnaceHeater)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.blastFurnacePreheater)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.furnaceHeater).func_200472_a("ici").func_200472_a("clc").func_200472_a("iri").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.lvCoil), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.lvCoil)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.furnaceHeater)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.dynamo).func_200472_a("rlr").func_200472_a("iii").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.lvCoil), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.lvCoil)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.dynamo)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.thermoelectricGen).func_200472_a("iii").func_200472_a("ele").func_200472_a("eee").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200469_a(Character.valueOf('e'), IETags.getTagsFor((EnumMetals)EnumMetals.CONSTANTAN).plate).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.lvCoil), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.lvCoil)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.thermoelectricGen)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.electricLantern).func_200472_a(" i ").func_200472_a("pep").func_200472_a("iri").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200462_a(Character.valueOf('e'), (IItemProvider)IEItems.Ingredients.electronTube).func_200469_a(Character.valueOf('p'), Tags.Items.GLASS_PANES).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.electronTube), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.electronTube)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.electricLantern)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.chargingStation).func_200472_a("ici").func_200472_a("ggg").func_200472_a("wlw").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", false)).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200469_a(Character.valueOf('g'), Tags.Items.GLASS).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.lvCoil), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.lvCoil)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.chargingStation)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.MetalDevices.fluidPipe, (int)8).func_200472_a("ppp").func_200472_a("   ").func_200472_a("ppp").func_200469_a(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200465_a("has_iron_plate", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.fluidPipe)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.sampleDrill).func_200472_a("sfs").func_200472_a("sfs").func_200472_a("efe").func_200462_a(Character.valueOf('s'), (IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD)).func_200462_a(Character.valueOf('f'), (IItemProvider)IEBlocks.MetalDecoration.steelFence).func_200462_a(Character.valueOf('e'), (IItemProvider)IEBlocks.MetalDecoration.engineeringLight).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.steelScaffolding.get((Object)MetalScaffoldingType.STANDARD))).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.steelFence), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.steelFence)).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.engineeringLight), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.engineeringLight)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.sampleDrill)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.teslaCoil).func_200472_a("iii").func_200472_a(" l ").func_200472_a("hlh").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200462_a(Character.valueOf('h'), (IItemProvider)IEBlocks.MetalDevices.capacitorHV).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDevices.capacitorHV), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDevices.capacitorHV)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.teslaCoil)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.floodlight).func_200472_a("iii").func_200472_a("pel").func_200472_a("ici").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200462_a(Character.valueOf('e'), (IItemProvider)IEItems.Ingredients.electronTube).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200469_a(Character.valueOf('p'), Tags.Items.GLASS_PANES).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.electronTube), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.electronTube)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.floodlight)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.turretChem).func_200472_a(" s ").func_200472_a(" gc").func_200472_a("bte").func_200462_a(Character.valueOf('s'), (IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.RAILGUN_SCOPE)).func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Weapons.chemthrower).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.circuitBoard).func_200462_a(Character.valueOf('b'), (IItemProvider)IEBlocks.MetalDevices.barrel).func_200462_a(Character.valueOf('t'), (IItemProvider)IEBlocks.WoodenDevices.turntable).func_200462_a(Character.valueOf('e'), (IItemProvider)IEBlocks.MetalDecoration.engineeringRS).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Weapons.chemthrower), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.chemthrower)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.turretChem)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.turretGun).func_200472_a(" s ").func_200472_a(" gc").func_200472_a("bte").func_200462_a(Character.valueOf('s'), (IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.RAILGUN_SCOPE)).func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Weapons.revolver).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.circuitBoard).func_200462_a(Character.valueOf('b'), (IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_MAGAZINE)).func_200462_a(Character.valueOf('t'), (IItemProvider)IEBlocks.WoodenDevices.turntable).func_200462_a(Character.valueOf('e'), (IItemProvider)IEBlocks.MetalDecoration.engineeringRS).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Weapons.revolver), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.revolver)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.turretGun)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.cloche).func_200472_a("geg").func_200472_a("g g").func_200472_a("wcw").func_200469_a(Character.valueOf('g'), Tags.Items.GLASS).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200462_a(Character.valueOf('e'), (IItemProvider)IEItems.Ingredients.electronTube).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.electronTube), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.electronTube)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.cloche)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDevices.fluidPlacer).func_200472_a("ibi").func_200472_a("b b").func_200472_a("ibi").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_221790_de).func_200465_a("has_iron_plate", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDevices.fluidPlacer)));
        for (Map.Entry<EnumMetals, Block> chute : IEBlocks.MetalDevices.chutes.entrySet()) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)chute.getValue()), (int)12).func_200472_a("s s").func_200472_a("s s").func_200472_a("s s").func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.getTagsFor((EnumMetals)chute.getKey()).sheetmetal)).func_200465_a("has_plate", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)chute.getKey()).plate)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)chute.getValue())));
        }
    }

    private void recipesConnectors(@Nonnull Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.Connectors.breakerswitch).func_200472_a(" l ").func_200472_a("cic").func_200462_a(Character.valueOf('l'), (IItemProvider)Items.field_221746_ci).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)Blocks.field_150405_ch).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.breakerswitch)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.Connectors.redstoneBreaker).func_200472_a("h h").func_200472_a("ici").func_200472_a("iri").func_200462_a(Character.valueOf('h'), (IItemProvider)IEBlocks.Connectors.getEnergyConnector("HV", false)).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_222027_iT).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200465_a("has_hv_connector", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("HV", false))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.redstoneBreaker)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.Connectors.currentTransformer).func_200472_a(" m ").func_200472_a("bcb").func_200472_a("ici").func_200462_a(Character.valueOf('m'), (IItemProvider)IEItems.Tools.voltmeter).func_200462_a(Character.valueOf('b'), (IItemProvider)Blocks.field_150405_ch).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200465_a("has_voltmeter", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Tools.voltmeter)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.currentTransformer)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.Connectors.transformer).func_200472_a("l m").func_200472_a("ibi").func_200472_a("iii").func_200462_a(Character.valueOf('l'), (IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", false)).func_200462_a(Character.valueOf('m'), (IItemProvider)IEBlocks.Connectors.getEnergyConnector("MV", false)).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('b'), (IItemProvider)IEBlocks.MetalDecoration.mvCoil).func_200465_a("has_mv_connector", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("MV", false))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.transformer)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.Connectors.transformerHV).func_200472_a("m h").func_200472_a("ibi").func_200472_a("iii").func_200462_a(Character.valueOf('m'), (IItemProvider)IEBlocks.Connectors.getEnergyConnector("MV", false)).func_200462_a(Character.valueOf('h'), (IItemProvider)IEBlocks.Connectors.getEnergyConnector("HV", false)).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('b'), (IItemProvider)IEBlocks.MetalDecoration.hvCoil).func_200465_a("has_hv_connector", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("HV", false))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.transformerHV)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Connectors.connectorStructural, (int)8).func_200472_a("isi").func_200472_a("i i").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200469_a(Character.valueOf('s'), IETags.steelRod).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.connectorStructural)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Connectors.connectorRedstone, (int)4).func_200472_a("iii").func_200472_a("brb").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).nugget).func_200462_a(Character.valueOf('b'), (IItemProvider)Blocks.field_150405_ch).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200465_a("has_electrum_nugget", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).nugget)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.connectorRedstone)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.Connectors.connectorProbe).func_200472_a(" c ").func_200472_a("gpg").func_200472_a(" q ").func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.Connectors.connectorRedstone).func_200469_a(Character.valueOf('g'), Tags.Items.GLASS_PANES).func_200462_a(Character.valueOf('p'), (IItemProvider)IEItems.Ingredients.circuitBoard).func_200469_a(Character.valueOf('q'), Tags.Items.GEMS_QUARTZ).func_200465_a("has_connector", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.Connectors.connectorRedstone)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.connectorProbe)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.Connectors.connectorBundled).func_200472_a(" w ").func_200472_a("wcw").func_200472_a(" w ").func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.Connectors.connectorRedstone).func_200469_a(Character.valueOf('w'), IETags.aluminumWire).func_200465_a("has_connector", (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.Connectors.connectorRedstone)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Connectors.connectorBundled)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", false), (int)4).func_200472_a(" i ").func_200472_a("cic").func_200472_a("cic").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)Blocks.field_150405_ch).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200467_a(out, this.toRL("connector_lv"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", true), (int)8).func_200472_a(" i ").func_200472_a("cic").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)Blocks.field_150405_ch).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200467_a(out, this.toRL("connector_lv_relay"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("MV", false), (int)4).func_200472_a(" i ").func_200472_a("cic").func_200472_a("cic").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)Blocks.field_150405_ch).func_200465_a("has_electrum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).func_200467_a(out, this.toRL("connector_mv"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("MV", true), (int)8).func_200472_a(" i ").func_200472_a("cic").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)Blocks.field_150405_ch).func_200465_a("has_electrum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).func_200467_a(out, this.toRL("connector_mv_relay"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("HV", false), (int)4).func_200472_a(" i ").func_200472_a("cic").func_200472_a("cic").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)Blocks.field_150405_ch).func_200465_a("has_aluminum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200467_a(out, this.toRL("connector_hv"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("HV", true), (int)8).func_200472_a(" i ").func_200472_a("cic").func_200472_a("cic").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.StoneDecoration.insulatingGlass).func_200465_a("has_aluminum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200467_a(out, this.toRL("connector_hv_relay"));
    }

    private void recipesConveyors(@Nonnull Consumer<IFinishedRecipe> out) {
        Block basic = ConveyorHandler.getBlock(BasicConveyor.NAME);
        Block redstone = ConveyorHandler.getBlock(RedstoneConveyor.NAME);
        Block covered = ConveyorHandler.getBlock(CoveredConveyor.NAME);
        Block dropper = ConveyorHandler.getBlock(DropConveyor.NAME);
        Block dropperCovered = ConveyorHandler.getBlock(DropCoveredConveyor.NAME);
        Block extract = ConveyorHandler.getBlock(ExtractConveyor.NAME);
        Block extractCovered = ConveyorHandler.getBlock(ExtractCoveredConveyor.NAME);
        Block splitter = ConveyorHandler.getBlock(SplitConveyor.NAME);
        Block splitterCovered = ConveyorHandler.getBlock(SplitCoveredConveyor.NAME);
        Block vertical = ConveyorHandler.getBlock(VerticalConveyor.NAME);
        Block verticalCovered = ConveyorHandler.getBlock(VerticalCoveredConveyor.NAME);
        this.addCoveyorCoveringRecipe((IItemProvider)covered, (IItemProvider)basic, out);
        this.addCoveyorCoveringRecipe((IItemProvider)dropperCovered, (IItemProvider)dropper, out);
        this.addCoveyorCoveringRecipe((IItemProvider)extractCovered, (IItemProvider)extract, out);
        this.addCoveyorCoveringRecipe((IItemProvider)splitterCovered, (IItemProvider)splitter, out);
        this.addCoveyorCoveringRecipe((IItemProvider)verticalCovered, (IItemProvider)vertical, out);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)basic, (int)8).func_200472_a("lll").func_200472_a("iri").func_200469_a(Character.valueOf('l'), Tags.Items.LEATHER).func_200469_a(Character.valueOf('i'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).func_200465_a("has_leather", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151116_aA)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)basic)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)redstone).func_200472_a("c").func_200472_a("r").func_200462_a(Character.valueOf('c'), (IItemProvider)basic).func_200462_a(Character.valueOf('r'), (IItemProvider)Blocks.field_150429_aA).func_200465_a("has_conveyor", (ICriterionInstance)this.func_200403_a((IItemProvider)basic)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)redstone)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)dropper).func_200472_a("c").func_200472_a("t").func_200462_a(Character.valueOf('c'), (IItemProvider)basic).func_200462_a(Character.valueOf('t'), (IItemProvider)Blocks.field_180400_cw).func_200465_a("has_trapdoor", (ICriterionInstance)this.func_200403_a((IItemProvider)Blocks.field_180400_cw)).func_200465_a("has_conveyor", (ICriterionInstance)this.func_200403_a((IItemProvider)basic)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)dropper)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)extract).func_200472_a("ws").func_200472_a("mc").func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200462_a(Character.valueOf('s'), (IItemProvider)IEBlocks.Cloth.curtain).func_200462_a(Character.valueOf('m'), (IItemProvider)IEItems.Ingredients.componentIron).func_200462_a(Character.valueOf('c'), (IItemProvider)basic).func_200465_a("has_conveyor", (ICriterionInstance)this.func_200403_a((IItemProvider)basic)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)extract)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)splitter, (int)3).func_200472_a("cic").func_200472_a(" c ").func_200462_a(Character.valueOf('c'), (IItemProvider)basic).func_200469_a(Character.valueOf('i'), Tags.Items.INGOTS_IRON).func_200465_a("has_conveyor", (ICriterionInstance)this.func_200403_a((IItemProvider)basic)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)splitter)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)vertical, (int)3).func_200472_a("ci").func_200472_a("c ").func_200472_a("ci").func_200462_a(Character.valueOf('c'), (IItemProvider)basic).func_200469_a(Character.valueOf('i'), Tags.Items.INGOTS_IRON).func_200465_a("has_conveyor", (ICriterionInstance)this.func_200403_a((IItemProvider)basic)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)vertical)));
    }

    private void addCoveyorCoveringRecipe(IItemProvider covered, IItemProvider base, Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)covered).func_200472_a("s").func_200472_a("c").func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.scaffoldingSteel)).func_200462_a(Character.valueOf('c'), base).func_200465_a("has_vertical_conveyor", (ICriterionInstance)this.func_200403_a(base)).func_200467_a(out, this.toRL(this.toPath(covered)));
    }

    private void recipesCloth(@Nonnull Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Cloth.balloon, (int)2).func_200472_a(" f ").func_200472_a("ftf").func_200472_a(" s ").func_200462_a(Character.valueOf('f'), (IItemProvider)IEItems.Ingredients.hempFabric).func_200462_a(Character.valueOf('t'), (IItemProvider)Items.field_221657_bQ).func_200469_a(Character.valueOf('s'), IETags.getItemTag(IETags.treatedWoodSlab)).func_200465_a("has_hemp_fabric", (ICriterionInstance)this.func_200409_a(IETags.fabricHemp)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Cloth.balloon)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Cloth.cushion, (int)3).func_200472_a("fff").func_200472_a("f f").func_200472_a("fff").func_200462_a(Character.valueOf('f'), (IItemProvider)IEItems.Ingredients.hempFabric).func_200465_a("has_hemp_fabric", (ICriterionInstance)this.func_200409_a(IETags.fabricHemp)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Cloth.cushion)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEBlocks.Cloth.curtain, (int)3).func_200472_a("sss").func_200472_a("fff").func_200472_a("fff").func_200469_a(Character.valueOf('s'), IETags.metalRods).func_200462_a(Character.valueOf('f'), (IItemProvider)IEItems.Ingredients.hempFabric).func_200465_a("has_hemp_fabric", (ICriterionInstance)this.func_200409_a(IETags.fabricHemp)).func_200465_a("has_metal_rod", (ICriterionInstance)this.func_200409_a(IETags.metalRods)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.Cloth.curtain)));
    }

    private void recipesTools(@Nonnull Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.hammer).func_200472_a(" if").func_200472_a(" si").func_200472_a("s  ").func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('f'), Tags.Items.STRING).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.hammer)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.wirecutter).func_200472_a("si").func_200472_a(" s").func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.wirecutter)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.screwdriver).func_200472_a(" i").func_200472_a("s ").func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('i'), IETags.ironRod).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.screwdriver)));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)IEItems.Tools.manual).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b((IItemProvider)Items.field_221746_ci).func_200483_a("has_book", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151122_aG)).func_200485_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.manual)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.steelAxe).func_200472_a("ii").func_200472_a("is").func_200472_a(" s").func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.steelAxe)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.steelPick).func_200472_a("iii").func_200472_a(" s ").func_200472_a(" s ").func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.steelPick)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.steelShovel).func_200472_a("i").func_200472_a("s").func_200472_a("s").func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.steelShovel)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.steelHoe).func_200472_a("ii").func_200472_a(" s").func_200472_a(" s").func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.steelHoe)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.steelSword).func_200472_a("i").func_200472_a("i").func_200472_a("s").func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.steelSword)));
        this.addArmor(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate, IEItems.Tools.steelArmor, "steel_plate", out);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.toolbox).func_200472_a("ppp").func_200472_a("rcr").func_200469_a(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate).func_200469_a(Character.valueOf('r'), Tags.Items.DYES_RED).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.WoodenDevices.crate).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200465_a("has_red_dye", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_222078_li)).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.WoodenDevices.crate), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.WoodenDevices.crate)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.toolbox)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.voltmeter).func_200472_a(" p ").func_200472_a("scs").func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151111_aL).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200465_a("has_compass", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151111_aL)).func_200465_a("has_treated_sticks", (ICriterionInstance)this.func_200409_a(IETags.treatedStick)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.voltmeter)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.drill).func_200472_a("  g").func_200472_a(" hg").func_200472_a("c  ").func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Ingredients.woodenGrip).func_200462_a(Character.valueOf('h'), (IItemProvider)IEBlocks.MetalDecoration.engineeringHeavy).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDecoration.engineeringHeavy), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDecoration.engineeringHeavy)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.drill)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.drillheadIron).func_200472_a("  i").func_200472_a("ii ").func_200472_a("bi ").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200471_a(Character.valueOf('b'), this.makeIngredient((Tag<Item>)Tags.Items.STORAGE_BLOCKS_IRON)).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.drillheadIron)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.drillheadSteel).func_200472_a("  i").func_200472_a("ii ").func_200472_a("bi ").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200471_a(Character.valueOf('b'), this.makeIngredientFromBlock(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).storage)).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.drillheadSteel)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.buzzsaw).func_200472_a("  g").func_200472_a("rcg").func_200472_a("r  ").func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Ingredients.woodenGrip).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentSteel).func_200469_a(Character.valueOf('r'), IETags.steelRod).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.componentSteel), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.componentSteel)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.buzzsaw)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.sawblade).func_200472_a("ipi").func_200472_a("p p").func_200472_a("ipi").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200469_a(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.sawblade)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.rockcutter).func_200472_a("ipi").func_200472_a("p p").func_200472_a("ipi").func_200469_a(Character.valueOf('i'), Tags.Items.GEMS_DIAMOND).func_200469_a(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.rockcutter)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Tools.surveyTools).func_200472_a("cbh").func_200472_a("fff").func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151069_bo).func_200462_a(Character.valueOf('h'), (IItemProvider)IEItems.Tools.hammer).func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_151099_bA).func_200469_a(Character.valueOf('f'), IETags.fabricHemp).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Tools.hammer), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Tools.hammer)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Tools.surveyTools)));
    }

    private void recipesIngredients(@Nonnull Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEItems.Ingredients.stickTreated, (int)4).func_200472_a("w").func_200472_a("w").func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200473_b("sticks").func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.stickTreated)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEItems.Ingredients.stickIron, (int)4).func_200472_a("i").func_200472_a("i").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200473_b("sticks").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.stickIron)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEItems.Ingredients.stickSteel, (int)4).func_200472_a("i").func_200472_a("i").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200473_b("sticks").func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.stickSteel)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)IEItems.Ingredients.stickAluminum, (int)4).func_200472_a("i").func_200472_a("i").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200473_b("sticks").func_200465_a("has_alu_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.stickAluminum)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.hempFabric).func_200472_a("fff").func_200472_a("fsf").func_200472_a("fff").func_200469_a(Character.valueOf('f'), IETags.fiberHemp).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_hemp_fiber", (ICriterionInstance)this.func_200409_a(IETags.fiberHemp)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.hempFabric)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.componentIron).func_200472_a("i i").func_200472_a(" c ").func_200472_a("i i").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.componentIron)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.componentSteel).func_200472_a("i i").func_200472_a(" c ").func_200472_a("i i").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.componentSteel)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.waterwheelSegment).func_200472_a(" s ").func_200472_a("sbs").func_200472_a("bsb").func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200469_a(Character.valueOf('b'), IETags.getItemTag(IETags.treatedWood)).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.waterwheelSegment)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.windmillBlade).func_200472_a("bb ").func_200472_a("ssb").func_200472_a("ss ").func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200469_a(Character.valueOf('b'), IETags.getItemTag(IETags.treatedWood)).func_200465_a("has_treated_planks", (ICriterionInstance)this.func_200409_a(IETags.getItemTag(IETags.treatedWood))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.windmillBlade)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.windmillSail).func_200472_a(" cc").func_200472_a("ccc").func_200472_a(" c ").func_200469_a(Character.valueOf('c'), IETags.fabricHemp).func_200465_a("has_hemp_fabric", (ICriterionInstance)this.func_200409_a(IETags.fabricHemp)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.windmillSail)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.woodenGrip).func_200472_a("ss").func_200472_a("cs").func_200472_a("ss").func_200469_a(Character.valueOf('s'), IETags.treatedStick).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).nugget).func_200465_a("has_treated_sticks", (ICriterionInstance)this.func_200409_a(IETags.treatedStick)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.woodenGrip)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.gunpartBarrel).func_200472_a("ss").func_200469_a(Character.valueOf('s'), IETags.steelRod).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.stickSteel), (ICriterionInstance)this.func_200409_a(IETags.steelRod)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.gunpartBarrel)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.gunpartDrum).func_200472_a(" i ").func_200472_a("ici").func_200472_a(" i ").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentSteel).func_200465_a("has_ingot_steel", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.gunpartDrum)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Ingredients.gunpartHammer).func_200472_a("i  ").func_200472_a("ii ").func_200472_a(" ii").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_ingot_steel", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.gunpartHammer)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_WATERPROOF))).func_200472_a("bl ").func_200472_a("lbl").func_200472_a(" lc").func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151133_ar).func_200469_a(Character.valueOf('l'), Tags.Items.GEMS_LAPIS).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_drill", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Tools.drill)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_WATERPROOF))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_LUBE))).func_200472_a("bi ").func_200472_a("ibi").func_200472_a(" ic").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200471_a(Character.valueOf('b'), (Ingredient)new IngredientFluidStack(IETags.fluidPlantoil, 1000)).func_200465_a("has_drill", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Tools.drill)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_LUBE))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_DAMAGE))).func_200472_a("iii").func_200472_a(" c ").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_drill", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Tools.drill)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_DAMAGE))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_CAPACITY))).func_200472_a("ci ").func_200472_a("ibr").func_200472_a(" rb").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200469_a(Character.valueOf('r'), Tags.Items.DYES_RED).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151133_ar).func_200465_a("has_drill", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Tools.drill)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_CAPACITY))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_BAYONET))).func_200472_a("si").func_200472_a("iw").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200462_a(Character.valueOf('s'), (IItemProvider)Items.field_151040_l).func_200465_a("has_revolver", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.revolver)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_BAYONET))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_MAGAZINE))).func_200472_a(" ai").func_200472_a("a a").func_200472_a("ca ").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200469_a(Character.valueOf('a'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200465_a("has_revolver", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.revolver)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_MAGAZINE))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_ELECTRO))).func_200472_a("eee").func_200472_a("rwr").func_200462_a(Character.valueOf('e'), (IItemProvider)IEItems.Ingredients.electronTube).func_200469_a(Character.valueOf('r'), IETags.steelRod).func_200462_a(Character.valueOf('w'), (IItemProvider)IEItems.Ingredients.wireCopper).func_200465_a("has_revolver", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.revolver)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.REVOLVER_ELECTRO))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.CHEMTHROWER_FOCUS))).func_200472_a(" ii").func_200472_a("pph").func_200472_a(" ii").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200462_a(Character.valueOf('p'), (IItemProvider)IEBlocks.MetalDevices.fluidPipe).func_200462_a(Character.valueOf('h'), (IItemProvider)Items.field_221862_eo).func_200465_a("has_chemthrower", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.chemthrower)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.CHEMTHROWER_FOCUS))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.CHEMTHROWER_MULTITANK))).func_200472_a(" p ").func_200472_a("tct").func_200462_a(Character.valueOf('p'), (IItemProvider)IEBlocks.MetalDevices.fluidPipe).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200462_a(Character.valueOf('t'), (IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_CAPACITY)).func_200465_a("has_chemthrower", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.chemthrower)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.CHEMTHROWER_MULTITANK))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.RAILGUN_SCOPE))).func_200472_a("pi ").func_200472_a("c i").func_200472_a(" cp").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200469_a(Character.valueOf('p'), Tags.Items.GLASS_PANES).func_200465_a("has_railgun", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.railgun)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.RAILGUN_SCOPE))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.RAILGUN_CAPACITORS))).func_200472_a("p  ").func_200472_a("ip ").func_200472_a(" ip").func_200469_a(Character.valueOf('p'), IETags.getTagsFor((EnumMetals)EnumMetals.CONSTANTAN).plate).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_railgun", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Weapons.railgun)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.RAILGUN_CAPACITORS))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.SHIELD_FLASH))).func_200472_a("ipi").func_200472_a("pep").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate).func_200469_a(Character.valueOf('p'), Tags.Items.GLASS_PANES).func_200462_a(Character.valueOf('e'), (IItemProvider)IEItems.Ingredients.electronTube).func_200465_a("has_shield", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Misc.shield)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.SHIELD_FLASH))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.SHIELD_SHOCK))).func_200472_a("crc").func_200472_a("crc").func_200472_a("crc").func_200469_a(Character.valueOf('r'), IETags.ironRod).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", false)).func_200465_a("has_shield", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Misc.shield)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.SHIELD_SHOCK))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.SHIELD_MAGNET))).func_200472_a("  l").func_200472_a("lc ").func_200472_a("lil").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('l'), Tags.Items.LEATHER).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.MetalDecoration.lvCoil).func_200465_a("has_shield", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Misc.shield)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.SHIELD_MAGNET))));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.BUZZSAW_SPAREBLADES))).func_200472_a("rht").func_200472_a("rt ").func_200469_a(Character.valueOf('r'), IETags.ironRod).func_200469_a(Character.valueOf('h'), IETags.fiberHemp).func_200469_a(Character.valueOf('t'), IETags.getItemTag(IETags.treatedWood)).func_200465_a("has_buzzsaw", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Tools.buzzsaw)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.BUZZSAW_SPAREBLADES))));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)IEItems.Ingredients.wireCopper).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).plate).func_200487_b((IItemProvider)IEItems.Tools.wirecutter).func_200483_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200485_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.wireCopper)));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)IEItems.Ingredients.wireElectrum).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).plate).func_200487_b((IItemProvider)IEItems.Tools.wirecutter).func_200483_a("has_electrum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).func_200485_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.wireElectrum)));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)IEItems.Ingredients.wireAluminum).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate).func_200487_b((IItemProvider)IEItems.Tools.wirecutter).func_200483_a("has_aluminum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot)).func_200485_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.wireAluminum)));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)IEItems.Ingredients.wireSteel).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).func_200487_b((IItemProvider)IEItems.Tools.wirecutter).func_200483_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200485_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Ingredients.wireSteel)));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)IEItems.Metals.dusts.get((Object)EnumMetals.ELECTRUM)), (int)2).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.GOLD).dust).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).dust).func_200483_a("has_gold_dust", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.GOLD).dust)).func_200485_a(out, this.toRL("electrum_mix"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)IEItems.Metals.dusts.get((Object)EnumMetals.CONSTANTAN)), (int)2).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).dust).func_203221_a(IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).dust).func_200483_a("has_nickel_dust", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).dust)).func_200485_a(out, this.toRL("constantan_mix"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.blueprint).func_200472_a("jkl").func_200472_a("ddd").func_200472_a("ppp").func_200469_a(Character.valueOf('j'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot).func_200469_a(Character.valueOf('l'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('k'), IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot).func_200469_a(Character.valueOf('d'), Tags.Items.DYES_BLUE).func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + this.toPath((IItemProvider)Items.field_151121_aF), (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151121_aF)).func_200467_a(this.buildBlueprint(out, "components", new ICondition[0]), this.toRL("blueprint_components"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.blueprint).func_200472_a(" P ").func_200472_a("ddd").func_200472_a("ppp").func_200469_a(Character.valueOf('P'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200469_a(Character.valueOf('d'), Tags.Items.DYES_BLUE).func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + this.toPath((IItemProvider)Items.field_151121_aF), (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151121_aF)).func_200467_a(this.buildBlueprint(out, "molds", new ICondition[0]), this.toRL("blueprint_molds"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.blueprint).func_200472_a("gcg").func_200472_a("ddd").func_200472_a("ppp").func_200469_a(Character.valueOf('g'), Tags.Items.GUNPOWDER).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.emptyCasing).func_200469_a(Character.valueOf('d'), Tags.Items.DYES_BLUE).func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + this.toPath((IItemProvider)Items.field_151121_aF), (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151121_aF)).func_200467_a(this.buildBlueprint(out, "bullet", new ICondition[0]), this.toRL("blueprint_bullets"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.blueprint).func_200472_a("ggg").func_200472_a("ddd").func_200472_a("ppp").func_200469_a(Character.valueOf('g'), IETags.hopGraphiteIngot).func_200469_a(Character.valueOf('d'), Tags.Items.DYES_BLUE).func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + this.toPath((IItemProvider)Items.field_151121_aF), (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151121_aF)).func_200467_a(this.buildBlueprint(out, "electrode", new IEConfigConditionSerializer.ConditionIEConfig(true, "machines.arcfurnace_electrodeCrafting")), this.toRL("blueprint_electrode"));
    }

    private void recipesVanilla(@Nonnull Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_221657_bQ, (int)12).func_200472_a("wc ").func_200472_a("sss").func_200469_a(Character.valueOf('w'), ItemTags.field_199904_a).func_200471_a(Character.valueOf('c'), (Ingredient)new IngredientFluidStack(IETags.fluidCreosote, 1000)).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_wool", (ICriterionInstance)this.func_200409_a(ItemTags.field_199904_a)).func_200465_a("has_stick", (ICriterionInstance)this.func_200409_a(Tags.Items.RODS_WOODEN)).func_200465_a("has_creosote", (ICriterionInstance)this.func_200403_a((IItemProvider)IEContent.fluidCreosote.func_204524_b())).func_200467_a(out, this.toRL(this.toPath((IItemProvider)Items.field_221657_bQ)));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151007_F).func_200492_a(Ingredient.func_199805_a(IETags.fiberHemp), 3).func_200483_a("has_hemp_fiber", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.hempFiber)).func_200485_a(out, this.toRL(this.toPath((IItemProvider)Items.field_151007_F)));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151016_H, (int)3).func_200492_a(Ingredient.func_199805_a(IETags.saltpeterDust), 4).func_203221_a(IETags.sulfurDust).func_200487_b((IItemProvider)Items.field_196155_l).func_200483_a("has_sulfur", (ICriterionInstance)this.func_200409_a(IETags.sulfurDust)).func_200485_a(out, this.toRL("gunpowder_from_dusts"));
    }

    private Consumer<IFinishedRecipe> buildBlueprint(Consumer<IFinishedRecipe> out, String blueprint, final ICondition ... conditions) {
        return recipe -> out.accept(new IFinishedRecipe((IFinishedRecipe)recipe, blueprint){
            final /* synthetic */ IFinishedRecipe val$recipe;
            final /* synthetic */ String val$blueprint;
            {
                this.val$recipe = iFinishedRecipe;
                this.val$blueprint = string;
            }

            public void func_218610_a(@Nonnull JsonObject json) {
                if (conditions.length > 0) {
                    JsonArray conditionArray = new JsonArray();
                    for (ICondition condition : conditions) {
                        conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                    }
                    json.add("conditions", (JsonElement)conditionArray);
                }
                this.val$recipe.func_218610_a(json);
                JsonObject output = json.getAsJsonObject("result");
                JsonObject nbt = new JsonObject();
                nbt.addProperty("blueprint", this.val$blueprint);
                output.add("nbt", (JsonElement)nbt);
            }

            @Nonnull
            public ResourceLocation func_200442_b() {
                return this.val$recipe.func_200442_b();
            }

            @Nonnull
            public IRecipeSerializer<?> func_218609_c() {
                return this.val$recipe.func_218609_c();
            }

            @Nullable
            public JsonObject func_200440_c() {
                return this.val$recipe.func_200440_c();
            }

            @Nullable
            public ResourceLocation func_200443_d() {
                return this.val$recipe.func_200443_d();
            }
        });
    }

    private void recipesWeapons(@Nonnull Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Weapons.chemthrower).func_200472_a(" tg").func_200472_a(" hg").func_200472_a("pb ").func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Ingredients.woodenGrip).func_200462_a(Character.valueOf('p'), (IItemProvider)IEBlocks.MetalDevices.fluidPipe).func_200462_a(Character.valueOf('h'), (IItemProvider)IEBlocks.MetalDecoration.engineeringHeavy).func_200462_a(Character.valueOf('t'), (IItemProvider)IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_WATERPROOF)).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151133_ar).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.woodenGrip), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.woodenGrip)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Weapons.chemthrower)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Weapons.railgun).func_200472_a(" vg").func_200472_a("icp").func_200472_a("ci ").func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Ingredients.woodenGrip).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200462_a(Character.valueOf('v'), (IItemProvider)IEBlocks.MetalDevices.capacitorHV).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.MetalDecoration.mvCoil).func_200462_a(Character.valueOf('p'), (IItemProvider)IEItems.Ingredients.circuitBoard).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDevices.capacitorHV), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDevices.capacitorHV)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Weapons.railgun)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.skyhook).func_200472_a("ii ").func_200472_a("ic ").func_200472_a(" gg").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.componentIron).func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Ingredients.woodenGrip).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.woodenGrip), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.woodenGrip)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.skyhook)));
        RevolverAssemblyRecipeBuilder.builder((IItemProvider)IEItems.Weapons.revolver).setNBTCopyTargetRecipe(3, 4, 5).func_200472_a(" i ").func_200472_a("bdh").func_200472_a("gig").func_200462_a(Character.valueOf('b'), (IItemProvider)IEItems.Ingredients.gunpartBarrel).func_200462_a(Character.valueOf('d'), (IItemProvider)IEItems.Ingredients.gunpartDrum).func_200462_a(Character.valueOf('h'), (IItemProvider)IEItems.Ingredients.gunpartHammer).func_200462_a(Character.valueOf('g'), (IItemProvider)IEItems.Ingredients.woodenGrip).func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Ingredients.woodenGrip), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.woodenGrip)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Weapons.revolver)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Weapons.speedloader).func_200472_a("  i").func_200472_a("iis").func_200472_a("  i").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot).func_200469_a(Character.valueOf('s'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Weapons.speedloader)));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)BulletHandler.emptyShell.func_77973_b(), (int)5).func_200472_a("prp").func_200472_a("prp").func_200472_a(" c ").func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151121_aF).func_200469_a(Character.valueOf('r'), Tags.Items.DYES_RED).func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).plate).func_200465_a("has_coppper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)BulletHandler.emptyShell.func_77973_b())));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)BulletHandler.emptyCasing.func_77973_b(), (int)5).func_200472_a("c c").func_200472_a("c c").func_200472_a(" c ").func_200469_a(Character.valueOf('c'), IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).plate).func_200465_a("has_coppper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)BulletHandler.emptyCasing.func_77973_b())));
        BulletHandler.getBulletStack(BulletItem.FLARE);
        TurnAndCopyRecipeBuilder.builder((IItemProvider)BulletHandler.getBulletItem(BulletItem.FIREWORK)).setNBTCopyTargetRecipe(0, 1, 2, 3, 4, 5, 6).func_200472_a("f").func_200472_a("c").func_200462_a(Character.valueOf('f'), (IItemProvider)Items.field_196152_dE).func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Ingredients.emptyShell).func_200465_a("has_firework", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_196152_dE)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)BulletHandler.getBulletItem(BulletItem.FIREWORK))));
    }

    private void recipesMisc(@Nonnull Consumer<IFinishedRecipe> out) {
        Item wireCoilCopper = IEItems.Misc.wireCoils.get(WireType.COPPER);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wireCoilCopper, (int)4).func_200472_a(" w ").func_200472_a("wsw").func_200472_a(" w ").func_200469_a(Character.valueOf('w'), IETags.copperWire).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)wireCoilCopper)));
        Item wireCoilElectrum = IEItems.Misc.wireCoils.get(WireType.ELECTRUM);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wireCoilElectrum, (int)4).func_200472_a(" w ").func_200472_a("wsw").func_200472_a(" w ").func_200469_a(Character.valueOf('w'), IETags.electrumWire).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_electrum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)wireCoilElectrum)));
        Item wireCoilSteel = IEItems.Misc.wireCoils.get(WireType.STEEL);
        TurnAndCopyRecipeBuilder.builder((IItemProvider)wireCoilSteel, 4).allowQuarterTurn().func_200472_a(" w ").func_200472_a("asa").func_200472_a(" w ").func_200469_a(Character.valueOf('w'), IETags.steelWire).func_200469_a(Character.valueOf('a'), IETags.aluminumWire).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)wireCoilSteel)));
        Item wireCoilRope = IEItems.Misc.wireCoils.get(WireType.STRUCTURE_ROPE);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wireCoilRope, (int)4).func_200472_a(" w ").func_200472_a("wsw").func_200472_a(" w ").func_200462_a(Character.valueOf('w'), (IItemProvider)IEItems.Ingredients.hempFiber).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_hemp_fiber", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Ingredients.hempFiber)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)wireCoilRope)));
        Item wireCoilStructure = IEItems.Misc.wireCoils.get(WireType.STRUCTURE_STEEL);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wireCoilStructure, (int)4).func_200472_a(" w ").func_200472_a("wsw").func_200472_a(" w ").func_200462_a(Character.valueOf('w'), (IItemProvider)IEItems.Ingredients.wireSteel).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_steel_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)wireCoilStructure)));
        this.addCornerStraightMiddle((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER_INSULATED), 4, this.makeIngredient(IETags.fabricHemp), this.makeIngredient((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER)), this.makeIngredient(IETags.fabricHemp), out);
        this.addCornerStraightMiddle((IItemProvider)IEItems.Misc.wireCoils.get(WireType.ELECTRUM_INSULATED), 4, this.makeIngredient(IETags.fabricHemp), this.makeIngredient((IItemProvider)IEItems.Misc.wireCoils.get(WireType.ELECTRUM)), this.makeIngredient(IETags.fabricHemp), out);
        Item wireCoilRedstone = IEItems.Misc.wireCoils.get(WireType.REDSTONE);
        TurnAndCopyRecipeBuilder.builder((IItemProvider)wireCoilRedstone, 4).allowQuarterTurn().func_200472_a(" w ").func_200472_a("asa").func_200472_a(" w ").func_200469_a(Character.valueOf('w'), IETags.aluminumWire).func_200469_a(Character.valueOf('a'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('s'), Tags.Items.RODS_WOODEN).func_200465_a("has_aluminum_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)wireCoilRedstone)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.jerrycan).func_200472_a(" ii").func_200472_a("ibb").func_200472_a("ibb").func_200469_a(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151133_ar).func_200465_a("has_bucket", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151133_ar)).func_200467_a(out, this.toRL("jerrycan"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.powerpack).func_200472_a("lbl").func_200472_a("wcw").func_200469_a(Character.valueOf('l'), Tags.Items.LEATHER).func_200462_a(Character.valueOf('w'), (IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER)).func_200462_a(Character.valueOf('b'), (IItemProvider)IEBlocks.MetalDevices.capacitorLV).func_200462_a(Character.valueOf('c'), (IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", false)).func_200465_a("has_leather", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151116_aA)).func_200465_a("has_copper_ingot", (ICriterionInstance)this.func_200409_a(IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.MetalDevices.capacitorLV), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.MetalDevices.capacitorLV)).func_200465_a("has_" + this.toPath((IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", false)), (ICriterionInstance)this.func_200403_a((IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", false))).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.powerpack)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.maintenanceKit).func_200472_a("sc ").func_200472_a("fff").func_200462_a(Character.valueOf('c'), (IItemProvider)IEItems.Tools.wirecutter).func_200462_a(Character.valueOf('s'), (IItemProvider)IEItems.Tools.screwdriver).func_200469_a(Character.valueOf('f'), IETags.fabricHemp).func_200465_a("has_" + this.toPath((IItemProvider)IEItems.Tools.wirecutter), (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Tools.wirecutter)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.maintenanceKit)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.shield).func_200472_a("sws").func_200472_a("scs").func_200472_a("sws").func_200469_a(Character.valueOf('s'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).func_200469_a(Character.valueOf('w'), IETags.getItemTag(IETags.treatedWood)).func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_185159_cQ).func_200465_a("has_shield", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_185159_cQ)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.shield)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.fluorescentTube).func_200472_a("GeG").func_200472_a("GgG").func_200472_a("GgG").func_200469_a(Character.valueOf('g'), Tags.Items.DUSTS_GLOWSTONE).func_200462_a(Character.valueOf('e'), (IItemProvider)IEItems.Misc.graphiteElectrode).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS).func_200465_a("has_electrode", (ICriterionInstance)this.func_200403_a((IItemProvider)IEItems.Misc.graphiteElectrode)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.fluorescentTube)));
        this.addArmor(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate, IEItems.Misc.faradaySuit, "alu_plate", out);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.earmuffs).func_200472_a(" S ").func_200472_a("S S").func_200472_a("W W").func_200469_a(Character.valueOf('S'), IETags.ironRod).func_200469_a(Character.valueOf('W'), ItemTags.field_199904_a).func_200465_a("has_iron_rod", (ICriterionInstance)this.func_200409_a(IETags.ironRod)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.earmuffs)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEBlocks.MetalDecoration.lantern).func_200472_a(" I ").func_200472_a("PGP").func_200472_a(" I ").func_200469_a(Character.valueOf('I'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).func_200469_a(Character.valueOf('G'), Tags.Items.DUSTS_GLOWSTONE).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_221792_df).func_200465_a("has_glowstone", (ICriterionInstance)this.func_200409_a(Tags.Items.DUSTS_GLOWSTONE)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEBlocks.MetalDecoration.lantern)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.cartWoodenCrate).func_200472_a("B").func_200472_a("C").func_200462_a(Character.valueOf('B'), (IItemProvider)IEBlocks.WoodenDevices.crate).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151143_au).func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151143_au)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.cartWoodenCrate)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.cartReinforcedCrate).func_200472_a("B").func_200472_a("C").func_200462_a(Character.valueOf('B'), (IItemProvider)IEBlocks.WoodenDevices.reinforcedCrate).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151143_au).func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151143_au)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.cartReinforcedCrate)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.cartWoodenBarrel).func_200472_a("B").func_200472_a("C").func_200462_a(Character.valueOf('B'), (IItemProvider)IEBlocks.WoodenDevices.woodenBarrel).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151143_au).func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151143_au)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.cartWoodenBarrel)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)IEItems.Misc.cartMetalBarrel).func_200472_a("B").func_200472_a("C").func_200462_a(Character.valueOf('B'), (IItemProvider)IEBlocks.MetalDevices.barrel).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151143_au).func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151143_au)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)IEItems.Misc.cartMetalBarrel)));
    }

    private void addArmor(Tag<Item> input, Map<EquipmentSlotType, Item> items, String name, Consumer<IFinishedRecipe> out) {
        Item head = items.get(EquipmentSlotType.HEAD);
        Item chest = items.get(EquipmentSlotType.CHEST);
        Item legs = items.get(EquipmentSlotType.LEGS);
        Item feet = items.get(EquipmentSlotType.FEET);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)head).func_200472_a("xxx").func_200472_a("x x").func_200469_a(Character.valueOf('x'), input).func_200465_a("has_" + name, (ICriterionInstance)this.func_200409_a(input)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)head)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)chest).func_200472_a("x x").func_200472_a("xxx").func_200472_a("xxx").func_200469_a(Character.valueOf('x'), input).func_200465_a("has_" + name, (ICriterionInstance)this.func_200409_a(input)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)chest)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)legs).func_200472_a("xxx").func_200472_a("x x").func_200472_a("x x").func_200469_a(Character.valueOf('x'), input).func_200465_a("has_" + name, (ICriterionInstance)this.func_200409_a(input)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)legs)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)feet).func_200472_a("x x").func_200472_a("x x").func_200469_a(Character.valueOf('x'), input).func_200465_a("has_" + name, (ICriterionInstance)this.func_200409_a(input)).func_200467_a(out, this.toRL(this.toPath((IItemProvider)feet)));
    }

    private void add3x3Conversion(IItemProvider bigItem, IItemProvider smallItem, Tag<Item> smallTag, Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)bigItem).func_200469_a(Character.valueOf('s'), smallTag).func_200462_a(Character.valueOf('i'), smallItem).func_200472_a("sss").func_200472_a("sis").func_200472_a("sss").func_200465_a("has_" + this.toPath(smallItem), (ICriterionInstance)this.func_200403_a(smallItem)).func_200466_a(out, this.toRL(this.toPath(smallItem) + "_to_") + this.toPath(bigItem));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)smallItem, (int)9).func_200487_b(bigItem).func_200483_a("has_" + this.toPath(bigItem), (ICriterionInstance)this.func_200403_a(smallItem)).func_200485_a(out, this.toRL(this.toPath(bigItem) + "_to_" + this.toPath(smallItem)));
    }

    private void addSlab(IItemProvider block, IItemProvider slab, Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)slab, (int)6).func_200462_a(Character.valueOf('s'), block).func_200472_a("sss").func_200465_a("has_" + this.toPath(block), (ICriterionInstance)this.func_200403_a(block)).func_200467_a(out, this.toRL(this.toPath(block) + "_to_slab"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)block).func_200462_a(Character.valueOf('s'), slab).func_200472_a("s").func_200472_a("s").func_200465_a("has_" + this.toPath(block), (ICriterionInstance)this.func_200403_a(block)).func_200467_a(out, this.toRL(this.toPath(block) + "_from_slab"));
    }

    private void addStairs(IItemProvider block, IItemProvider stairs, Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)stairs, (int)4).func_200462_a(Character.valueOf('s'), block).func_200472_a("s  ").func_200472_a("ss ").func_200472_a("sss").func_200465_a("has_" + this.toPath(block), (ICriterionInstance)this.func_200403_a(block)).func_200467_a(out, this.toRL(this.toPath(stairs)));
    }

    @ParametersAreNonnullByDefault
    private void addCornerStraightMiddle(IItemProvider output, int count, Ingredient corner, Ingredient side, Ingredient middle, Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)output, (int)count).func_200471_a(Character.valueOf('c'), corner).func_200471_a(Character.valueOf('s'), side).func_200471_a(Character.valueOf('m'), middle).func_200472_a("csc").func_200472_a("sms").func_200472_a("csc").func_200465_a("has_" + this.toPath(output), (ICriterionInstance)this.func_200403_a(output)).func_200467_a(out, this.toRL(this.toPath(output)));
    }

    @ParametersAreNonnullByDefault
    private void addSandwich(IItemProvider output, int count, Ingredient top, Ingredient middle, Ingredient bottom, Consumer<IFinishedRecipe> out) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)output, (int)count).func_200471_a(Character.valueOf('t'), top).func_200471_a(Character.valueOf('m'), middle).func_200471_a(Character.valueOf('b'), bottom).func_200472_a("ttt").func_200472_a("mmm").func_200472_a("bbb").func_200465_a("has_" + this.toPath(output), (ICriterionInstance)this.func_200403_a(output)).func_200467_a(out, this.toRL(this.toPath(output)));
    }

    private String toPath(IItemProvider src) {
        return src.func_199767_j().getRegistryName().func_110623_a();
    }

    private ResourceLocation toRL(String s) {
        if (!s.contains("/")) {
            s = "crafting/" + s;
        }
        if (this.PATH_COUNT.containsKey(s)) {
            int count = this.PATH_COUNT.get(s) + 1;
            this.PATH_COUNT.put(s, count);
            return new ResourceLocation("immersiveengineering", s + count);
        }
        this.PATH_COUNT.put(s, 1);
        return new ResourceLocation("immersiveengineering", s);
    }

    @Nonnull
    private Ingredient makeIngredient(IItemProvider in) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{in});
    }

    @Nonnull
    private Ingredient makeIngredient(Tag<Item> in) {
        return Ingredient.func_199805_a(in);
    }

    @Nonnull
    private Ingredient makeIngredientFromBlock(Tag<Block> in) {
        Tag itemTag = IETags.getItemTag(in);
        if (itemTag == null) {
            itemTag = (Tag)ItemTags.func_199903_a().func_200039_c().get(in.func_199886_b());
        }
        Preconditions.checkNotNull((Object)itemTag, (Object)("Failed to convert block tag " + in.func_199886_b() + " to item tag"));
        return this.makeIngredient((Tag<Item>)itemTag);
    }

    public static ICondition getTagCondition(Tag<?> tag) {
        return new NotCondition((ICondition)new TagEmptyCondition(tag.func_199886_b()));
    }

    public static ICondition getTagCondition(ResourceLocation tag) {
        return Recipes.getTagCondition(new ItemTags.Wrapper(tag));
    }

    private void addStandardSmeltingBlastingRecipe(IItemProvider input, IItemProvider output, float xp, int smeltingTime, Consumer<IFinishedRecipe> out, String extraPostfix, boolean smeltPostfix) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)smeltingTime).func_218628_a("has_" + this.toPath(input), (ICriterionInstance)this.func_200403_a(input)).func_218635_a(out, this.toRL(this.toPath(output) + extraPostfix + (smeltPostfix ? "_from_smelting" : "")));
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)(smeltingTime / 2)).func_218628_a("has_" + this.toPath(input), (ICriterionInstance)this.func_200403_a(input)).func_218635_a(out, this.toRL(this.toPath(output) + extraPostfix + "_from_blasting"));
    }

    private void addStandardSmeltingBlastingRecipe(IItemProvider input, IItemProvider output, float xp, Consumer<IFinishedRecipe> out) {
        this.addStandardSmeltingBlastingRecipe(input, output, xp, out, "");
    }

    private void addStandardSmeltingBlastingRecipe(IItemProvider input, IItemProvider output, float xp, Consumer<IFinishedRecipe> out, String extraPostfix) {
        this.addStandardSmeltingBlastingRecipe(input, output, xp, 200, out, extraPostfix, false);
    }

    private void addRGBRecipe(Consumer<IFinishedRecipe> out, final ResourceLocation recipeName, final Ingredient target, final String nbtKey) {
        out.accept(new IFinishedRecipe(){

            public void func_218610_a(JsonObject json) {
                json.add("target", target.func_200304_c());
                json.addProperty("key", nbtKey);
            }

            public ResourceLocation func_200442_b() {
                return recipeName;
            }

            public IRecipeSerializer<?> func_218609_c() {
                return (IRecipeSerializer)RecipeSerializers.RGB_SERIALIZER.get();
            }

            @Nullable
            public JsonObject func_200440_c() {
                return null;
            }

            @Nullable
            public ResourceLocation func_200443_d() {
                return null;
            }
        });
    }
}

