/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.SawbladeItem;
import blusunrize.immersiveengineering.common.items.ToolUpgradeItem;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Triple;

public class BuzzsawItem
extends UpgradeableToolItem
implements IEItemInterfaces.IAdvancedFluidItem,
IOBJModelCallback<ItemStack>,
ITool,
IEItemInterfaces.IScrollwheel {
    public static Collection<SawbladeItem> sawblades = new ArrayList<SawbladeItem>(2);
    private static final int MAX_HORIZONTAL_DISTANCE = 7;
    public static HashMap<UUID, Integer> animationTimer = new HashMap();
    private static final String[][] GROUP_BLADE = new String[][]{{"blade"}};
    @OnlyIn(value=Dist.CLIENT)
    private static TransformationMatrix MAT_FIXED;

    public BuzzsawItem() {
        super("buzzsaw", BuzzsawItem.withIEOBJRender().func_200917_a(1).setISTER(() -> () -> IEOBJItemRenderer.INSTANCE), "BUZZSAW");
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        ret = ret == null ? new CompoundNBT() : ret.func_74737_b();
        ItemStack sawblade = this.getSawblade(stack);
        if (!sawblade.func_190926_b()) {
            ret.func_218657_a("sawblade", (INBT)sawblade.func_77955_b(new CompoundNBT()));
        }
        return ret;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                LazyOptional<IEItemFluidHandler> fluids;
                LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.fluids = CapabilityUtils.constantOptional(new IEItemFluidHandler(stack, 2000));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "buzzsaw"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                        return this.fluids.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getBladeDamage(stack) / (double)this.getMaxBladeDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getBladeDamage(stack) > 0;
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 5;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        if (BuzzsawItem.hasQuiverUpgrade(stack)) {
            return new Slot[]{new IESlot.WithPredicate(inv, 0, 88, 22, itemStack -> sawblades.contains(itemStack.func_77973_b())), new IESlot.Upgrades(container, inv, 1, 88, 52, "BUZZSAW", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 2, 108, 52, "BUZZSAW", stack, true, getWorld, getPlayer), new IESlot.WithPredicate(inv, 3, 108, 12, itemStack -> sawblades.contains(itemStack.func_77973_b())), new IESlot.WithPredicate(inv, 4, 108, 32, itemStack -> sawblades.contains(itemStack.func_77973_b()))};
        }
        return new Slot[]{new IESlot.WithPredicate(inv, 0, 98, 22, itemStack -> sawblades.contains(itemStack.func_77973_b())), new IESlot.Upgrades(container, inv, 1, 88, 52, "BUZZSAW", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 2, 108, 52, "BUZZSAW", stack, true, getWorld, getPlayer)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack removeUpgrade(ItemStack stack, PlayerEntity player, ItemStack upgrade) {
        if (upgrade.func_77973_b() == IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.BUZZSAW_SPAREBLADES)) {
            for (int i = 1; i <= 2; ++i) {
                ItemStack sawblade = this.getSawblade(stack, i);
                if (sawblade.func_190926_b()) continue;
                ItemNBTHelper.setItemStack(upgrade, "sawblade" + i, sawblade);
                this.setSawblade(stack, ItemStack.field_190927_a, i);
            }
        }
        return upgrade;
    }

    @Override
    public void removeFromWorkbench(PlayerEntity player, ItemStack stack) {
        LazyOptional invCap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        invCap.ifPresent(inv -> {
            if (!(inv.getStackInSlot(0).func_190926_b() || inv.getStackInSlot(1).func_190926_b() || inv.getStackInSlot(2).func_190926_b())) {
                Utils.unlockIEAdvancement(player, "main/upgrade_buzzsaw");
            }
        });
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, World w, PlayerEntity player) {
        super.recalculateUpgrades(stack, w, player);
        LazyOptional invCap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        invCap.ifPresent(inv -> {
            for (int iUpgrade = 1; iUpgrade <= 2; ++iUpgrade) {
                ItemStack upgrade = inv.getStackInSlot(iUpgrade);
                if (upgrade.func_77973_b() != IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.BUZZSAW_SPAREBLADES)) continue;
                for (int i = 1; i <= 2; ++i) {
                    if (!ItemNBTHelper.hasKey(upgrade, "sawblade" + i)) continue;
                    ItemStack sawblade = ItemNBTHelper.getItemStack(upgrade, "sawblade" + i);
                    this.setSawblade(stack, sawblade, i);
                    ItemNBTHelper.remove(upgrade, "sawblade" + i);
                }
            }
        });
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getAmount() > this.getCapacity(stack, 2000)) {
            fs.setAmount(this.getCapacity(stack, 2000));
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getAmount() > this.getCapacity(stack, 2000)) {
            fs.setAmount(this.getCapacity(stack, 2000));
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    public ItemStack getSawblade(ItemStack itemStack) {
        return this.getSawblade(itemStack, 0);
    }

    public ItemStack getSawblade(ItemStack itemStack, int spare) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == null) {
            return ItemStack.field_190927_a;
        }
        boolean remote = EffectiveSide.get() == LogicalSide.CLIENT;
        LazyOptional cap = itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        int slot = spare == 0 ? 0 : 2 + spare;
        String key = "sawblade" + (spare == 0 ? "" : "_spare" + spare);
        if (!remote && ((Boolean)cap.map(h -> h.getStackInSlot(slot).func_190926_b()).orElse((Object)false)).booleanValue()) {
            remote = true;
        } else if (remote && !ItemNBTHelper.hasKey(itemStack, key)) {
            remote = false;
        }
        ItemStack sawblade = remote ? ItemStack.func_199557_a((CompoundNBT)ItemNBTHelper.getTagCompound(itemStack, key)) : ((IItemHandler)cap.orElseThrow(RuntimeException::new)).getStackInSlot(slot);
        return !sawblade.func_190926_b() && sawblades.contains(sawblade.func_77973_b()) ? sawblade : ItemStack.field_190927_a;
    }

    public void setSawblade(ItemStack buzzsaw, ItemStack sawblade) {
        this.setSawblade(buzzsaw, sawblade, 0);
    }

    public void setSawblade(ItemStack buzzsaw, ItemStack sawblade, int spare) {
        int slot = spare == 0 ? 0 : 2 + spare;
        IItemHandler inv = (IItemHandler)buzzsaw.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        ((IItemHandlerModifiable)inv).setStackInSlot(slot, sawblade);
        ListNBT enchants = null;
        if (sawblade.func_77973_b() instanceof SawbladeItem) {
            enchants = ((SawbladeItem)sawblade.func_77973_b()).getSawbladeEnchants();
        }
        if (enchants != null) {
            buzzsaw.func_196082_o().func_218657_a("Enchantments", (INBT)enchants);
        } else {
            buzzsaw.func_196082_o().func_82580_o("Enchantments");
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add(IEItemFluidHandler.fluidItemInfoFlavor(this.getFluid(stack), this.getCapacity(stack, 2000)));
        if (this.getSawblade(stack).func_190926_b()) {
            list.add(new TranslationTextComponent("desc.immersiveengineering.flavour.buzzsaw.noBlade", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        } else {
            int maxDmg = this.getMaxBladeDamage(stack);
            int dmg = maxDmg - this.getBladeDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            TextFormatting status = (double)quote < 0.1 ? TextFormatting.RED : ((double)quote < 0.3 ? TextFormatting.GOLD : ((double)quote < 0.6 ? TextFormatting.YELLOW : TextFormatting.GREEN));
            list.add(new TranslationTextComponent("desc.immersiveengineering.flavour.buzzsaw.bladeDamage", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150258_a(" ").func_150257_a(new TranslationTextComponent("desc.immersiveengineering.info.percent", new Object[]{(int)(quote * 100.0f)}).func_150255_a(new Style().func_150238_a(status))));
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.COMMON;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ItemStack sawblade;
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND && !(sawblade = this.getSawblade(stack)).func_190926_b() && this.canBuzzsawBeUsed(stack, null)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)((SawbladeItem)sawblade.func_77973_b()).getSawbladeDamage(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BOW;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity player) {
        this.consumeDurability(stack, target.func_130014_f_(), null, null, player);
        return true;
    }

    @Override
    public void onScrollwheel(ItemStack stack, PlayerEntity playerEntity, boolean forward) {
        if (BuzzsawItem.hasQuiverUpgrade(stack)) {
            ItemStack sawblade = this.getSawblade(stack);
            ItemStack spare1 = this.getSawblade(stack, 1);
            ItemStack spare2 = this.getSawblade(stack, 2);
            if (forward) {
                this.setSawblade(stack, spare2);
                this.setSawblade(stack, sawblade, 1);
                this.setSawblade(stack, spare1, 2);
            } else {
                this.setSawblade(stack, spare1);
                this.setSawblade(stack, spare2, 1);
                this.setSawblade(stack, sawblade, 2);
            }
        }
    }

    public boolean canBuzzsawBeUsed(ItemStack stack, @Nullable LivingEntity player) {
        if (this.getBladeDamage(stack) >= this.getMaxBladeDamage(stack)) {
            return false;
        }
        return !this.getFluid(stack).isEmpty();
    }

    public int getMaxBladeDamage(ItemStack stack) {
        ItemStack sawblade = this.getSawblade(stack);
        return !sawblade.func_190926_b() ? sawblade.func_77958_k() : 0;
    }

    public int getBladeDamage(ItemStack stack) {
        ItemStack sawblade = this.getSawblade(stack);
        return !sawblade.func_190926_b() ? sawblade.func_77952_i() : 0;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity living) {
        this.consumeDurability(stack, world, state, pos, living);
        if (!world.field_72995_K && !living.func_225608_bj_() && living instanceof ServerPlayerEntity && this.canFellTree(stack) && this.canBuzzsawBeUsed(stack, living) && this.isTree(world, pos)) {
            this.fellTree(world, pos, (ServerPlayerEntity)living, stack);
        }
        return true;
    }

    private void consumeDurability(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity living) {
        if (state == null || state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            int dmg;
            int n = dmg = state == null || ForgeHooks.isToolEffective((IWorldReader)world, (BlockPos)pos, (ItemStack)stack) || this.isEffective(stack, state.func_185904_a()) ? 1 : 3;
            if (state.func_203425_a(BlockTags.field_206952_E) && Utils.RAND.nextInt(10) != 0) {
                return;
            }
            ItemStack sawblade = this.getSawblade(stack);
            if (!sawblade.func_190926_b()) {
                if (!this.getUpgrades(stack).func_74767_n("oiled") || Utils.RAND.nextInt(4) == 0) {
                    sawblade.func_222118_a(dmg, living, entity -> entity.func_213334_d(Hand.MAIN_HAND));
                }
                this.setSawblade(stack, sawblade);
                IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElseThrow(RuntimeException::new);
                handler.drain(1, IFluidHandler.FluidAction.EXECUTE);
                Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader = ShaderRegistry.getStoredShaderAndCase(stack);
                if (shader != null) {
                    ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(world, (ItemStack)shader.getLeft(), stack, ((ShaderCase)shader.getRight()).getShaderType().toString(), new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), null, 0.375f);
                }
            }
        }
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        ItemStack sawblade = this.getSawblade(stack);
        if (!sawblade.func_190926_b()) {
            return 3;
        }
        return -1;
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (!this.getSawblade(stack).func_190926_b() && this.canBuzzsawBeUsed(stack, null)) {
            return ImmutableSet.of((Object)ToolType.AXE);
        }
        return super.getToolTypes(stack);
    }

    public boolean isEffective(ItemStack stack, Material mat) {
        Material[] validMaterials = null;
        ItemStack sawblade = this.getSawblade(stack);
        if (sawblade.func_77973_b() instanceof SawbladeItem) {
            validMaterials = ((SawbladeItem)sawblade.func_77973_b()).getSawbladeMaterials();
        }
        if (validMaterials != null) {
            for (Material m : validMaterials) {
                if (m != mat) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return this.isEffective(stack, state.func_185904_a()) && this.canBuzzsawBeUsed(stack, null);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        ItemStack sawblade;
        if (this.isEffective(stack, state.func_185904_a()) && !(sawblade = this.getSawblade(stack)).func_190926_b() && this.canBuzzsawBeUsed(stack, null)) {
            return ((SawbladeItem)sawblade.func_77973_b()).getSawbladeSpeed();
        }
        return super.func_150893_a(stack, state);
    }

    private boolean isTree(World world, BlockPos initialPos) {
        int logs = 0;
        boolean leafTop = false;
        BlockPos pos = initialPos;
        for (int y = 0; y < 32; ++y) {
            BlockState state = world.func_180495_p(pos = pos.func_177984_a());
            if (state.func_203425_a(BlockTags.field_200031_h)) {
                ++logs;
                continue;
            }
            if (state.func_203425_a(BlockTags.field_206952_E)) {
                leafTop = true;
            }
            boolean foundLog = false;
            if (!leafTop) {
                boolean loop = true;
                for (int z = -1; z <= 1 && loop; ++z) {
                    for (int x = -1; x <= 1 && loop; ++x) {
                        state = world.func_180495_p(pos.func_177982_a(x, 0, z));
                        if (!state.func_203425_a(BlockTags.field_200031_h)) continue;
                        pos = pos.func_177982_a(x, 0, z);
                        foundLog = true;
                        ++logs;
                        loop = false;
                    }
                }
            }
            if (!foundLog) break;
        }
        return logs >= 3 && leafTop;
    }

    private boolean canFellTree(ItemStack stack) {
        ItemStack sawblade = this.getSawblade(stack);
        if (sawblade.func_77973_b() instanceof SawbladeItem) {
            return ((SawbladeItem)sawblade.func_77973_b()).canSawbladeFellTree();
        }
        return false;
    }

    private boolean fellTree(final World world, BlockPos initialPos, final ServerPlayerEntity player, final ItemStack stack) {
        int logs = 0;
        ArrayDeque<BlockPos> openList = new ArrayDeque<BlockPos>();
        final ArrayDeque<BlockPos> closedList = new ArrayDeque<BlockPos>();
        openList.add(initialPos);
        while (!openList.isEmpty() && closedList.size() < 512 && logs < 256) {
            BlockPos next = (BlockPos)openList.pollFirst();
            if (Math.abs(next.func_177958_n() - initialPos.func_177958_n()) > 7 || Math.abs(next.func_177952_p() - initialPos.func_177952_p()) > 7 || closedList.contains(next)) continue;
            BlockState state = world.func_180495_p(next);
            if (state.func_203425_a(BlockTags.field_200031_h)) {
                closedList.add(next);
                ++logs;
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int x = -1; x <= 1; ++x) {
                            openList.add(next.func_177982_a(x, y, z));
                        }
                    }
                }
                continue;
            }
            if (!state.func_203425_a(BlockTags.field_206952_E)) continue;
            closedList.add(next);
            int trunkDist = state.func_177230_c() instanceof LeavesBlock ? (Integer)state.func_177229_b((IProperty)LeavesBlock.field_208494_a) : 0;
            for (Direction dir : new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
                BlockPos adj = next.func_177972_a(dir);
                BlockState adjState = world.func_180495_p(adj);
                if (adjState.func_203425_a(BlockTags.field_206952_E)) {
                    int adjDist;
                    int n = adjDist = adjState.func_177230_c() instanceof LeavesBlock ? (Integer)adjState.func_177229_b((IProperty)LeavesBlock.field_208494_a) : 0;
                    if (adjDist < trunkDist) continue;
                }
                openList.add(adj);
            }
        }
        if (closedList.size() == 0) {
            return false;
        }
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onTick(TickEvent.WorldTickEvent event) {
                if (event.phase == TickEvent.Phase.START && event.world == world) {
                    BuzzsawItem.this.breakFromList(closedList, 5, world, player, stack);
                    if (closedList.isEmpty()) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            }
        });
        return true;
    }

    private void breakFromList(Deque<BlockPos> closedList, int maxAmount, World world, ServerPlayerEntity player, ItemStack stack) {
        int count = 0;
        while (count++ < maxAmount && !closedList.isEmpty()) {
            BlockState state;
            Block block;
            BlockPos pos = closedList.pollFirst();
            int xpDropEvent = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (ServerPlayerEntity)player, (BlockPos)pos);
            if (xpDropEvent < 0 || (block = (state = world.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockReader)world, pos) || state.func_185903_a((PlayerEntity)player, (IBlockReader)world, pos) == 0.0f) continue;
            if (player.field_71075_bZ.field_75098_d) {
                block.func_176208_a(world, pos, state, (PlayerEntity)player);
                if (block.removedByPlayer(state, world, pos, (PlayerEntity)player, false, state.func_204520_s())) {
                    block.func_176206_d((IWorld)world, pos, state);
                }
            } else {
                block.func_176208_a(world, pos, state, (PlayerEntity)player);
                TileEntity te = world.func_175625_s(pos);
                this.consumeDurability(stack, world, state, pos, (LivingEntity)player);
                if (block.removedByPlayer(state, world, pos, (PlayerEntity)player, true, state.func_204520_s())) {
                    block.func_176206_d((IWorld)world, pos, state);
                    block.func_180657_a(world, (PlayerEntity)player, pos, state, te, stack);
                    block.func_180637_b(world, pos, xpDropEvent);
                }
            }
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            player.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
        }
    }

    @Override
    public int getCapacity(ItemStack container, int baseCapacity) {
        return baseCapacity + this.getUpgrades(container).func_74762_e("capacity");
    }

    @Override
    public boolean allowFluid(ItemStack container, FluidStack fluid) {
        return fluid != null && DieselHandler.isValidDrillFuel(fluid.getFluid());
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        LazyOptional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return (Boolean)wrapperNew.map(w -> ItemStack.func_77989_b((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse((Object)true);
        });
        if (!((Boolean)sameShader.orElse((Object)true)).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (this.canBuzzsawBeUsed(stack, entity)) {
            if (!animationTimer.containsKey(entity.func_110124_au())) {
                animationTimer.put(entity.func_110124_au(), 40);
            } else if (animationTimer.get(entity.func_110124_au()) < 20) {
                animationTimer.put(entity.func_110124_au(), 20);
            }
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTextureReplacement(ItemStack stack, String group, String material) {
        ResourceLocation rl;
        int spare;
        ItemStack sawblade;
        if ("blade".equals(material) && (sawblade = this.getSawblade(stack, spare = "upgrade_blades1".equals(group) ? 1 : ("upgrade_blades2".equals(group) ? 2 : 0))).func_77973_b() instanceof SawbladeItem && (rl = ((SawbladeItem)sawblade.func_77973_b()).getSawbladeTexture()) != null) {
            return ClientUtils.getSprite(rl);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if ("body".equals(group)) {
            return true;
        }
        if ("blade".equals(group)) {
            return !this.getSawblade(stack).func_190926_b();
        }
        CompoundNBT upgrades = this.getUpgrades(stack);
        if ("upgrade_lube".equals(group)) {
            return upgrades.func_74767_n("oiled");
        }
        if ("upgrade_launcher".equals(group)) {
            return upgrades.func_74767_n("launcher");
        }
        if ("upgrade_blades0".equals(group)) {
            return BuzzsawItem.hasQuiverUpgrade(stack);
        }
        if ("upgrade_blades1".equals(group)) {
            return BuzzsawItem.hasQuiverUpgrade(stack) && !this.getSawblade(stack, 1).func_190926_b();
        }
        if ("upgrade_blades2".equals(group)) {
            return BuzzsawItem.hasQuiverUpgrade(stack) && !this.getSawblade(stack, 2).func_190926_b();
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix applyTransformations(ItemStack stack, String group, TransformationMatrix transform) {
        return transform;
    }

    private boolean shouldRotate(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transform) {
        return !(entity == null || !this.canBuzzsawBeUsed(stack, entity) || entity.func_184586_b(Hand.MAIN_HAND) != stack && entity.func_184586_b(Hand.OFF_HAND) != stack || transform != ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND && transform != ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND && transform != ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND && transform != ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String[][] getSpecialGroups(ItemStack stack, ItemCameraTransforms.TransformType transform, LivingEntity entity) {
        return GROUP_BLADE;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix getTransformForGroups(ItemStack stack, String[] groups, ItemCameraTransforms.TransformType transform, LivingEntity entity, float partialTicks) {
        if (MAT_FIXED == null) {
            MAT_FIXED = new TransformationMatrix(new Vector3f(0.60945f, 0.0f, 0.0f), null, null, null);
        }
        if (!this.shouldRotate(entity, stack, transform)) {
            return MAT_FIXED;
        }
        float ticksPerRotation = 10.0f;
        float angle = ((float)entity.field_70173_aa % ticksPerRotation + partialTicks) / ticksPerRotation * ((float)Math.PI * 2);
        return new TransformationMatrix(new Vector3f(0.60945f, 0.0f, 0.0f), new Quaternion(0.0f, angle, 0.0f, false), null, null);
    }

    public static boolean hasQuiverUpgrade(ItemStack stack) {
        return ((BuzzsawItem)IEItems.Tools.buzzsaw).getUpgrades(stack).func_74767_n("spareblades");
    }
}

