/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class CoresampleItem
extends IEBaseItem {
    public CoresampleItem() {
        super("coresample", new Item.Properties().func_200916_a(ImmersiveEngineering.itemGroup));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        CoresampleItem.getCoresampleInfo(stack, list, TextFormatting.GRAY, world, true, true);
    }

    public static void getCoresampleInfo(ItemStack coresample, List<ITextComponent> list, TextFormatting baseColor, @Nullable World world, boolean showYield, boolean showTimestamp) {
        ColumnPos coords;
        if (coresample.func_196082_o().func_74764_b("coords")) {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.coresample.outdated", new Object[0]));
        }
        if ((coords = CoresampleItem.getCoords(coresample)) != null) {
            ColumnPos pos;
            ListNBT nbtList = coresample.func_196082_o().func_150295_c("mineralInfo", 10);
            if (nbtList.size() > 0) {
                nbtList.forEach(inbt -> {
                    CompoundNBT tag = (CompoundNBT)inbt;
                    MineralMix mineral = MineralMix.mineralList.get(new ResourceLocation(tag.func_74779_i("mineral")));
                    StringTextComponent component = new StringTextComponent(Utils.formatDouble(tag.func_74769_h("percentage") * 100.0, "0.00") + "% ");
                    component.func_150257_a((ITextComponent)new TranslationTextComponent(mineral.getTranslationKey(), new Object[0]));
                    list.add(component.func_211708_a(baseColor));
                    if (showYield) {
                        component = new StringTextComponent("  ");
                        component.func_150257_a((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.coresample.saturation", new Object[]{Utils.formatDouble(tag.func_74769_h("saturation") * 100.0, "0.00")}));
                        list.add(component.func_211708_a(TextFormatting.DARK_GRAY));
                        component = new StringTextComponent("  ");
                        int yield = ExcavatorHandler.mineralVeinYield - tag.func_74762_e("depletion");
                        yield = (int)((float)yield * (1.0f - mineral.failChance));
                        if (ExcavatorHandler.mineralVeinYield == 0) {
                            component.func_150257_a((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.coresample.infinite", new Object[0]));
                        } else {
                            component.func_150257_a((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.coresample.yield", new Object[]{yield}));
                        }
                        list.add(component.func_211708_a(TextFormatting.DARK_GRAY));
                    }
                });
            } else {
                list.add(new TranslationTextComponent("desc.immersiveengineering.info.coresample.noMineral", new Object[0]).func_211708_a(baseColor));
            }
            ResourceLocation dimension = CoresampleItem.getDimenson(coresample);
            if (dimension != null) {
                String s2 = dimension.func_110623_a();
                if (s2.toLowerCase(Locale.ENGLISH).startsWith("the_")) {
                    s2 = s2.substring(4);
                }
                list.add(new StringTextComponent(Utils.toCamelCase(s2)).func_211708_a(baseColor));
            }
            if ((pos = CoresampleItem.getCoords(coresample)) != null) {
                list.add(new TranslationTextComponent("desc.immersiveengineering.info.coresample.pos", new Object[]{pos.field_219439_a, pos.field_219440_b}).func_211708_a(baseColor));
            }
            if (showTimestamp) {
                boolean hasStamp = ItemNBTHelper.hasKey(coresample, "timestamp");
                if (hasStamp && world != null) {
                    long timestamp = ItemNBTHelper.getLong(coresample, "timestamp");
                    long dist = world.func_82737_E() - timestamp;
                    if (dist < 0L) {
                        list.add(new StringTextComponent("Somehow this sample is dated in the future...are you a time traveller?!").func_211708_a(TextFormatting.RED));
                    } else {
                        list.add(new TranslationTextComponent("desc.immersiveengineering.info.coresample.timestamp", new Object[]{ClientUtils.fomatTimestamp(dist, ClientUtils.TimestampFormat.DHM)}).func_211708_a(baseColor));
                    }
                } else if (hasStamp) {
                    list.add(new TranslationTextComponent("desc.immersiveengineering.info.coresample.timezone", new Object[0]).func_211708_a(baseColor));
                } else {
                    list.add(new TranslationTextComponent("desc.immersiveengineering.info.coresample.noTimestamp", new Object[0]).func_211708_a(baseColor));
                }
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        if (player != null && player.func_225608_bj_()) {
            BlockItemUseContext blockCtx;
            World world = ctx.func_195991_k();
            BlockPos pos = ctx.func_195995_a();
            Direction side = ctx.func_196000_l();
            BlockState state = world.func_180495_p(pos);
            if (!state.func_196953_a(blockCtx = new BlockItemUseContext(ctx))) {
                pos = pos.func_177972_a(side);
            }
            if (!stack.func_190926_b() && player.func_175151_a(pos, side, stack) && world.func_180495_p(pos).func_196953_a(blockCtx)) {
                BlockState coresample = IEBlocks.StoneDecoration.coresample.func_176223_P();
                if (world.func_180501_a(pos, coresample, 3)) {
                    ((IEBaseBlock)IEBlocks.StoneDecoration.coresample).onIEBlockPlacedBy(blockCtx, coresample);
                    SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), (IWorldReader)world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return super.func_195939_a(ctx);
    }

    public static MineralMix[] getMineralMixes(ItemStack coresample) {
        if (ItemNBTHelper.hasKey(coresample, "mineralInfo", 9)) {
            ListNBT nbtList = coresample.func_196082_o().func_150295_c("mineralInfo", 10);
            return (MineralMix[])nbtList.stream().map(inbt -> {
                CompoundNBT tag = (CompoundNBT)inbt;
                return MineralMix.mineralList.get(new ResourceLocation(tag.func_74779_i("mineral")));
            }).filter(Objects::nonNull).toArray(MineralMix[]::new);
        }
        return new MineralMix[0];
    }

    public static ListNBT getSimplifiedMineralList(ItemStack coresample) {
        ListNBT outList = new ListNBT();
        if (ItemNBTHelper.hasKey(coresample, "mineralInfo", 9)) {
            coresample.func_196082_o().func_150295_c("mineralInfo", 10).forEach(inbt -> outList.add((Object)StringNBT.func_229705_a_((String)((CompoundNBT)inbt).func_74779_i("mineral"))));
        }
        return outList;
    }

    public static void setMineralInfo(ItemStack stack, MineralWorldInfo info, BlockPos pos) {
        if (info == null) {
            return;
        }
        List<Pair<MineralVein, Integer>> veins = info.getAllVeins();
        ListNBT nbtList = new ListNBT();
        veins.forEach(pair -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74780_a("percentage", (double)((Integer)pair.getRight()).intValue() / (double)info.getTotalWeight());
            tag.func_74778_a("mineral", ((MineralVein)pair.getLeft()).getMineral().func_199560_c().toString());
            tag.func_74768_a("depletion", ((MineralVein)pair.getLeft()).getDepletion());
            tag.func_74780_a("saturation", 1.0 - ((MineralVein)pair.getLeft()).getFailChance(pos));
            nbtList.add((Object)tag);
        });
        stack.func_196082_o().func_218657_a("mineralInfo", (INBT)nbtList);
    }

    @Nullable
    public static ColumnPos getCoords(@Nullable ItemStack stack) {
        if (stack != null && stack.func_77942_o() && stack.func_196082_o().func_74764_b("x")) {
            return new ColumnPos(stack.func_196082_o().func_74762_e("x"), stack.func_196082_o().func_74762_e("z"));
        }
        return null;
    }

    public static void setCoords(ItemStack stack, BlockPos pos) {
        stack.func_196082_o().func_74768_a("x", pos.func_177958_n());
        stack.func_196082_o().func_74768_a("z", pos.func_177952_p());
    }

    @Nullable
    public static ResourceLocation getDimenson(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_196082_o().func_74764_b("dimension")) {
            return new ResourceLocation(stack.func_196082_o().func_74779_i("dimension"));
        }
        return null;
    }

    public static void setDimenson(ItemStack stack, DimensionType dimension) {
        stack.func_196082_o().func_74778_a("dimension", dimension.getRegistryName().toString());
    }
}

