/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EngineersBlueprintItem
extends IEBaseItem {
    public EngineersBlueprintItem() {
        super("blueprint", new Item.Properties().func_200917_a(1));
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        String key = EngineersBlueprintItem.getCategory(stack);
        if (!key.isEmpty() && BlueprintCraftingRecipe.recipeCategories.contains(key)) {
            String formatted;
            String formatKey = "desc.immersiveengineering.info.blueprint." + key;
            if (formatKey.equals(formatted = I18n.func_135052_a((String)formatKey, (Object[])new Object[0]))) {
                list.add((ITextComponent)new StringTextComponent(key));
            } else {
                list.add((ITextComponent)new TranslationTextComponent(formatKey, new Object[0]));
            }
            if (Screen.hasShiftDown()) {
                list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.blueprint.creates1", new Object[0]));
                BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(key);
                if (recipes.length > 0) {
                    for (BlueprintCraftingRecipe recipe : recipes) {
                        list.add(new StringTextComponent(" ").func_150257_a(recipe.output.func_200301_q()));
                    }
                }
            } else {
                list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.blueprint.creates0", new Object[0]));
            }
        }
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (String key : BlueprintCraftingRecipe.recipeCategories) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemNBTHelper.putString(stack, "blueprint", key);
                list.add((Object)stack);
            }
        }
    }

    @Nonnull
    public static BlueprintCraftingRecipe[] getRecipes(ItemStack stack) {
        return BlueprintCraftingRecipe.findRecipes(EngineersBlueprintItem.getCategory(stack));
    }

    public static String getCategory(ItemStack stack) {
        return ItemNBTHelper.getString(stack, "blueprint");
    }
}

