/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.common.entities.FluorescentTubeEntity;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluorescentTubeItem
extends IEBaseItem
implements IConfigurableTool,
IElectricEquipment,
IOBJModelCallback<ItemStack> {
    private static final String LIT_TIME = "litTime";
    private static final String LIT_STRENGTH = "litStrength";
    private static final String[][] special = new String[][]{{"tube"}};

    public FluorescentTubeItem() {
        super("fluorescent_tube", new Item.Properties().func_200917_a(1).setISTER(() -> () -> IEOBJItemRenderer.INSTANCE));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        Direction side = ctx.func_196000_l();
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        if (side == Direction.UP && player != null) {
            if (!world.field_72995_K) {
                ItemStack stack = ctx.func_195996_i();
                Vec3d look = player.func_70040_Z();
                float angle = (float)Math.toDegrees(Math.atan2(look.field_72450_a, look.field_72449_c));
                FluorescentTubeEntity tube = new FluorescentTubeEntity(world, stack.func_77946_l(), angle);
                tube.func_70107_b(ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b + 1.5, ctx.func_221532_j().field_72449_c);
                world.func_217376_c((Entity)tube);
                stack.func_77979_a(1);
                if (stack.func_190916_E() > 0) {
                    player.func_184611_a(ctx.func_221531_n(), stack);
                } else {
                    player.func_184611_a(ctx.func_221531_n(), ItemStack.field_190927_a);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(ctx);
    }

    public static float[] getRGB(ItemStack s) {
        if (ItemNBTHelper.hasKey(s, "rgb")) {
            CompoundNBT nbt = ItemNBTHelper.getTagCompound(s, "rgb");
            return new float[]{nbt.func_74760_g("r"), nbt.func_74760_g("g"), nbt.func_74760_g("b")};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public static void setRGB(ItemStack s, float[] rgb) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74776_a("r", rgb[0]);
        nbt.func_74776_a("g", rgb[1]);
        nbt.func_74776_a("b", rgb[2]);
        ItemNBTHelper.setTagCompound(s, "rgb", nbt);
    }

    @Override
    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigBoolean[0];
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        IConfigurableTool.ToolConfig.ToolConfigFloat[] ret = new IConfigurableTool.ToolConfig.ToolConfigFloat[3];
        float[] rgb = FluorescentTubeItem.getRGB(stack);
        ret[0] = new IConfigurableTool.ToolConfig.ToolConfigFloat("red", 60, 20, rgb[0]);
        ret[1] = new IConfigurableTool.ToolConfig.ToolConfigFloat("green", 60, 40, rgb[1]);
        ret[2] = new IConfigurableTool.ToolConfig.ToolConfigFloat("blue", 60, 60, rgb[2]);
        return ret;
    }

    @Override
    public void applyConfigOption(ItemStack stack, String key, Object value) {
        int id = key.equals("red") ? 0 : (key.equals("green") ? 1 : 2);
        float[] rgb = FluorescentTubeItem.getRGB(stack);
        rgb[id] = ((Float)value).floatValue();
        FluorescentTubeItem.setRGB(stack, rgb);
    }

    @Override
    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return config.name;
    }

    @Override
    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return config.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.colour", new Object[]{"#" + FluorescentTubeItem.hexColorString(stack)}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        if (pass == 0) {
            return FluorescentTubeItem.getRGBInt(stack, 1.0f);
        }
        return super.getColourForIEItem(stack, pass);
    }

    public static float[] getRGBFloat(ItemStack stack, float factor) {
        float[] fRGB = FluorescentTubeItem.getRGB(stack);
        return new float[]{fRGB[0] * factor, fRGB[1] * factor, fRGB[2] * factor, 1.0f};
    }

    public static int getRGBInt(ItemStack stack, float factor) {
        float[] scaled = FluorescentTubeItem.getRGBFloat(stack, factor);
        return ((int)(scaled[0] * 255.0f) << 16) + ((int)(scaled[1] * 255.0f) << 8) + (int)(scaled[2] * 255.0f);
    }

    public static String hexColorString(ItemStack stack) {
        String hexCol = Integer.toHexString(FluorescentTubeItem.getRGBInt(stack, 1.0f));
        while (hexCol.length() < 6) {
            hexCol = "0" + hexCol;
        }
        return hexCol;
    }

    public static boolean isLit(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, LIT_TIME);
    }

    public static void setLit(ItemStack stack, float strength) {
        ItemNBTHelper.putInt(stack, LIT_TIME, 35);
        ItemNBTHelper.putFloat(stack, LIT_STRENGTH, MathHelper.func_76131_a((float)strength, (float)0.0f, (float)1.0f));
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlotType eqSlot, LivingEntity owner, Map<String, Object> cache, DamageSource dmg, IElectricEquipment.ElectricSource eSource) {
        FluorescentTubeItem.setLit(equipped, eSource.level);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && FluorescentTubeItem.isLit(stack)) {
            int litTicksRemaining = ItemNBTHelper.getInt(stack, LIT_TIME);
            if (--litTicksRemaining <= 0) {
                ItemNBTHelper.remove(stack, LIT_TIME);
                ItemNBTHelper.remove(stack, LIT_STRENGTH);
            } else {
                ItemNBTHelper.putInt(stack, LIT_TIME, litTicksRemaining);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack) || !Arrays.equals(FluorescentTubeItem.getRGB(oldStack), FluorescentTubeItem.getRGB(newStack));
    }

    @Override
    public String[][] getSpecialGroups(ItemStack stack, ItemCameraTransforms.TransformType transform, LivingEntity entity) {
        if (FluorescentTubeItem.isLit(stack)) {
            return special;
        }
        return IOBJModelCallback.EMPTY_STRING_A;
    }

    @Override
    public boolean areGroupsFullbright(ItemStack stack, String[] groups) {
        return groups.length == 1 && "tube".equals(groups[0]) && FluorescentTubeItem.isLit(stack);
    }

    @Override
    public Vector4f getRenderColor(ItemStack object, String group, Vector4f original) {
        if ("tube".equals(group)) {
            boolean lit = FluorescentTubeItem.isLit(object);
            float min = 0.3f + (lit ? ItemNBTHelper.getFloat(object, LIT_STRENGTH) * 0.68f : 0.0f);
            float mult = min + (lit ? Utils.RAND.nextFloat() * MathHelper.func_76131_a((float)(1.0f - min), (float)0.0f, (float)0.1f) : 0.0f);
            float[] colors = FluorescentTubeItem.getRGBFloat(object, mult);
            return new Vector4f(colors[0], colors[1], colors[2], colors[3]);
        }
        return new Vector4f(0.067f, 0.067f, 0.067f, 1.0f);
    }
}

