/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientEventHandler;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MessageObstructedConnection
implements IMessage {
    private Vec3d start;
    private Vec3d end;
    private BlockPos startB;
    private BlockPos endB;
    private Collection<BlockPos> blocking;
    private WireType wireType;

    public MessageObstructedConnection(Connection conn, Collection<BlockPos> blocking) {
        this.blocking = blocking;
        this.start = conn.getPoint(0.0, conn.getEndA());
        this.end = conn.getPoint(1.0, conn.getEndA());
        this.startB = conn.getEndA().getPosition();
        this.endB = conn.getEndB().getPosition();
        this.wireType = conn.type;
    }

    public MessageObstructedConnection(PacketBuffer buf) {
        this.start = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.end = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.startB = buf.func_179259_c();
        this.endB = buf.func_179259_c();
        int count = buf.readInt();
        this.blocking = new ArrayList<BlockPos>(count);
        for (int i = 0; i < count; ++i) {
            this.blocking.add(buf.func_179259_c());
        }
        this.wireType = WireType.getValue(buf.func_150789_c(100));
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeDouble(this.start.field_72450_a).writeDouble(this.start.field_72448_b).writeDouble(this.start.field_72449_c);
        buf.writeDouble(this.end.field_72450_a).writeDouble(this.end.field_72448_b).writeDouble(this.end.field_72449_c);
        buf.func_179255_a(this.startB);
        buf.func_179255_a(this.endB);
        buf.writeInt(this.blocking.size());
        for (BlockPos b : this.blocking) {
            buf.func_179255_a(b);
        }
        buf.func_180714_a(this.wireType.getUniqueName());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Connection conn = new Connection(this.wireType, new ConnectionPoint(this.startB, 0), new ConnectionPoint(this.endB, 0));
            conn.generateCatenaryData(this.start, this.end);
            ClientEventHandler.FAILED_CONNECTIONS.put(conn, (Pair<Collection<BlockPos>, AtomicInteger>)new ImmutablePair(this.blocking, (Object)new AtomicInteger(200)));
        });
    }
}

