/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.IELogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSetGhostSlots
implements IMessage {
    private Int2ObjectMap<ItemStack> stacksToSet;

    public MessageSetGhostSlots(Int2ObjectMap<ItemStack> stacksToSet) {
        this.stacksToSet = stacksToSet;
    }

    public MessageSetGhostSlots(PacketBuffer buf) {
        int size = buf.readInt();
        this.stacksToSet = new Int2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            int slot = buf.readInt();
            this.stacksToSet.put(slot, (Object)buf.func_150791_c());
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.stacksToSet.size());
        for (Int2ObjectMap.Entry e : this.stacksToSet.int2ObjectEntrySet()) {
            buf.writeInt(e.getIntKey());
            buf.func_150788_a((ItemStack)e.getValue());
        }
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ServerPlayerEntity player = ctx.getSender();
        assert (player != null);
        ServerWorld world = player.func_71121_q();
        ctx.enqueueWork(() -> {
            Container container = player.field_71070_bA;
            if (container != null) {
                for (Int2ObjectMap.Entry e : this.stacksToSet.int2ObjectEntrySet()) {
                    int slot = e.getIntKey();
                    if (slot < 0 || slot >= container.field_75151_b.size()) continue;
                    Slot target = (Slot)container.field_75151_b.get(slot);
                    if (!(target instanceof IESlot.Ghost)) {
                        IELogger.error("Player " + player.func_145748_c_() + " tried to set the contents of a non-ghost slot.This is either a bug in IE or an attempt at cheating.");
                        return;
                    }
                    container.func_75141_a(slot, (ItemStack)e.getValue());
                }
            }
        });
    }
}

