/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageTileSync
implements IMessage {
    private BlockPos pos;
    private CompoundNBT nbt;

    public MessageTileSync(IEBaseTileEntity tile, CompoundNBT nbt) {
        this.pos = tile.func_174877_v();
        this.nbt = nbt;
    }

    public MessageTileSync(PacketBuffer buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.nbt = buf.func_150793_b();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.pos.func_177958_n()).writeInt(this.pos.func_177956_o()).writeInt(this.pos.func_177952_p());
        buf.func_150786_a(this.nbt);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.enqueueWork(() -> {
                TileEntity tile;
                ServerWorld world = Objects.requireNonNull(ctx.getSender()).func_71121_q();
                if (world.isAreaLoaded(this.pos, 1) && (tile = world.func_175625_s(this.pos)) instanceof IEBaseTileEntity) {
                    ((IEBaseTileEntity)tile).receiveMessageFromClient(this.nbt);
                }
            });
        } else {
            ctx.enqueueWork(() -> {
                TileEntity tile;
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (tile = world.func_175625_s(this.pos)) instanceof IEBaseTileEntity) {
                    ((IEBaseTileEntity)tile).receiveMessageFromServer(this.nbt);
                }
            });
        }
    }
}

