/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class CapabilityReference<T> {
    protected final Capability<T> cap;

    public static <T> CapabilityReference<T> forTileEntity(TileEntity local, Supplier<DirectionalBlockPos> pos, Capability<T> cap) {
        return new TECapReference<T>(() -> ((TileEntity)local).func_145831_w(), pos, cap);
    }

    public static <T> CapabilityReference<T> forRelative(TileEntity local, Capability<T> cap, Vec3i offset, Direction side) {
        return CapabilityReference.forTileEntity(local, () -> new DirectionalBlockPos(local.func_174877_v().func_177971_a(offset), side.func_176734_d()), cap);
    }

    public static <T> CapabilityReference<T> forNeighbor(TileEntity local, Capability<T> cap, NonNullSupplier<Direction> side) {
        return CapabilityReference.forTileEntity(local, () -> {
            Direction d = (Direction)side.get();
            return new DirectionalBlockPos(local.func_174877_v().func_177972_a(d), d.func_176734_d());
        }, cap);
    }

    public static <T> CapabilityReference<T> forNeighbor(TileEntity local, Capability<T> cap, @Nonnull Direction side) {
        return CapabilityReference.forRelative(local, cap, (Vec3i)BlockPos.field_177992_a.func_177972_a(side), side);
    }

    protected CapabilityReference(Capability<T> cap) {
        this.cap = cap;
    }

    @Nullable
    public abstract T getNullable();

    @Nonnull
    public T get() {
        return Objects.requireNonNull(this.getNullable());
    }

    public abstract boolean isPresent();

    private static class TECapReference<T>
    extends CapabilityReference<T> {
        private final Supplier<World> world;
        private final Supplier<DirectionalBlockPos> pos;
        @Nonnull
        private LazyOptional<T> currentCap = LazyOptional.empty();
        private DirectionalBlockPos lastPos;
        private World lastWorld;
        private TileEntity lastTE;

        public TECapReference(Supplier<World> world, Supplier<DirectionalBlockPos> pos, Capability<T> cap) {
            super(cap);
            this.world = world;
            this.pos = pos;
        }

        @Override
        @Nullable
        public T getNullable() {
            this.updateLazyOptional();
            return (T)this.currentCap.orElse(null);
        }

        @Override
        public boolean isPresent() {
            this.updateLazyOptional();
            return this.currentCap.isPresent();
        }

        private void updateLazyOptional() {
            World currWorld = this.world.get();
            DirectionalBlockPos currPos = this.pos.get();
            if (currWorld == null || currPos == null) {
                this.currentCap = LazyOptional.empty();
                this.lastWorld = null;
                this.lastPos = null;
                this.lastTE = null;
            } else if (currWorld != this.lastWorld || !currPos.equals((Object)this.lastPos) || !this.currentCap.isPresent() || this.lastTE != null && this.lastTE.func_145837_r()) {
                if (this.currentCap.isPresent() && this.lastTE != null && this.lastTE.func_145837_r()) {
                    IELogger.logger.warn("The tile entity {} (class {}) was removed, but the value {} provided by it for the capability {} is still marked as valid. This is likely a bug in the mod(s) adding the tile entity/the capability", (Object)this.lastTE, this.lastTE.getClass(), this.currentCap.orElseThrow(RuntimeException::new), (Object)this.cap.getName());
                }
                this.lastTE = Utils.getExistingTileEntity(currWorld, currPos);
                this.currentCap = this.lastTE != null ? this.lastTE.getCapability(this.cap, currPos.direction) : LazyOptional.empty();
                this.lastWorld = currWorld;
                this.lastPos = currPos;
            }
        }
    }
}

