/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class BlastFurnaceFuelCategory
extends IERecipeCategory<BlastFurnaceFuel> {
    public static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "blastfurnace_fuel");
    private final IDrawableAnimated flame;

    public BlastFurnaceFuelCategory(IGuiHelper helper) {
        super(BlastFurnaceFuel.class, helper, UID, "gui.immersiveengineering.blastFurnace.fuel");
        ResourceLocation furnaceBackgroundLocation = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        this.setBackground(helper.drawableBuilder(furnaceBackgroundLocation, 55, 36, 18, 36).addPadding(0, 0, 0, 68).build());
        this.setIcon((IDrawable)helper.createDrawable(new ResourceLocation("immersiveengineering", "textures/gui/blast_furnace.png"), 176, 0, 14, 14));
        IDrawableStatic flameStatic = helper.createDrawable(furnaceBackgroundLocation, 176, 0, 14, 14);
        this.flame = helper.createAnimatedDrawable(flameStatic, 80, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void setIngredients(BlastFurnaceFuel recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, JEIIngredientStackListBuilder.make(recipe.input).build());
    }

    public void setRecipe(IRecipeLayout recipeLayout, BlastFurnaceFuel recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 16);
        guiItemStacks.set(0, Arrays.asList(recipe.input.func_193365_a()));
    }

    public void draw(BlastFurnaceFuel recipe, double mouseX, double mouseY) {
        this.flame.draw(1, 0);
        String burnTime = I18n.func_135052_a((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.formatDouble(recipe.burnTime / 20, "#.##")});
        ClientUtils.font().func_211126_b(burnTime, 24.0f, 12.0f, 0x777777);
    }
}

