/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fluids;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.fluids.IEFluid;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ConcreteFluid
extends IEFluid {
    boolean hasFlownInTick = false;
    private static Method doesSideHaveHoles = ObfuscationReflectionHelper.findMethod(FlowingFluid.class, (String)"func_212751_a", (Class[])new Class[]{Direction.class, IBlockReader.class, BlockPos.class, BlockState.class, BlockPos.class, BlockState.class});

    public ConcreteFluid() {
        this("concrete", new ResourceLocation("immersiveengineering:block/fluid/concrete_still"), new ResourceLocation("immersiveengineering:block/fluid/concrete_flow"), ConcreteFluid.createBuilder(2400, 4000), true);
    }

    public ConcreteFluid(String fluidName, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidAttributes.Builder> buildAttributes, boolean isSource) {
        super(fluidName, stillTex, flowingTex, buildAttributes, isSource);
    }

    protected boolean func_207196_h() {
        return true;
    }

    @Override
    public int func_205569_a(IWorldReader p_205569_1_) {
        return 20;
    }

    public void func_207191_a(World world, BlockPos pos, IFluidState state) {
        this.hasFlownInTick = false;
        super.func_207191_a(world, pos, state);
        int timer = (Integer)state.func_177229_b((IProperty)IEProperties.INT_16);
        int level = ConcreteFluid.func_207205_e((IFluidState)state);
        int quantaRemaining = 16 - level;
        if (timer >= Math.min(14, quantaRemaining)) {
            Block solidBlock = level >= 14 ? IEBlocks.StoneDecoration.concreteSheet : (level >= 10 ? IEBlocks.StoneDecoration.concreteQuarter : (level >= 6 ? (Block)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.concrete) : (level >= 2 ? IEBlocks.StoneDecoration.concreteThreeQuarter : IEBlocks.StoneDecoration.concrete)));
            world.func_175656_a(pos, solidBlock.func_176223_P());
            for (LivingEntity living : world.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)))) {
                living.func_195064_c(new EffectInstance(IEPotions.concreteFeet, Integer.MAX_VALUE));
            }
        } else if (world.func_180495_p(pos).func_177230_c() == this.block) {
            BlockState newState = (BlockState)world.func_180495_p(pos).func_206870_a((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(timer + (this.hasFlownInTick ? 1 : 2)));
            world.func_175656_a(pos, newState);
        }
    }

    protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
        super.func_207184_a(builder);
        builder.func_206894_a(new IProperty[]{IEProperties.INT_16});
    }

    @Override
    protected BlockState func_204527_a(IFluidState state) {
        return (BlockState)super.func_204527_a(state).func_206870_a((IProperty)IEProperties.INT_16, state.func_177229_b((IProperty)IEProperties.INT_16));
    }

    @Override
    protected ConcreteFluid createFlowingVariant() {
        ConcreteFluid ret = new ConcreteFluid(this.fluidName, this.stillTex, this.flowingTex, this.buildAttributes, false){

            @Override
            protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
                super.func_207184_a(builder);
                builder.func_206894_a(new IProperty[]{field_207210_b});
            }
        };
        ret.source = this;
        ret.bucket = this.bucket;
        ret.block = this.block;
        ret.func_207183_f((IFluidState)((IFluidState)ret.func_207182_e().func_177621_b()).func_206870_a((IProperty)field_207210_b, (Comparable)Integer.valueOf(7)));
        return ret;
    }

    private boolean doesSideHaveHoles(Direction side, IBlockReader world, BlockPos pos, BlockState state, BlockPos pos2, BlockState state2) {
        try {
            return (Boolean)doesSideHaveHoles.invoke((Object)this, side, world, pos, state, pos2, state2);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    protected IFluidState func_205576_a(IWorldReader worldIn, BlockPos pos, @Nonnull BlockState blockStateIn) {
        int maxNeighborLevel = 0;
        int correspondingTimer = 0;
        for (Direction neighborSide : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.func_177972_a(neighborSide);
            BlockState neighborState = worldIn.func_180495_p(neighborPos);
            IFluidState fluidAtNeighbor = neighborState.func_204520_s();
            if (!fluidAtNeighbor.func_206886_c().func_207187_a((Fluid)this) || !this.doesSideHaveHoles(neighborSide, (IBlockReader)worldIn, pos, blockStateIn, neighborPos, neighborState) || fluidAtNeighbor.func_206882_g() <= maxNeighborLevel) continue;
            correspondingTimer = (Integer)fluidAtNeighbor.func_177229_b((IProperty)IEProperties.INT_16);
            maxNeighborLevel = fluidAtNeighbor.func_206882_g();
        }
        BlockPos abovePos = pos.func_177984_a();
        BlockState aboveState = worldIn.func_180495_p(abovePos);
        IFluidState aboveFluid = aboveState.func_204520_s();
        IFluidState currFluid = blockStateIn.func_204520_s();
        if (!aboveFluid.func_206888_e() && aboveFluid.func_206886_c().func_207187_a((Fluid)this) && this.doesSideHaveHoles(Direction.UP, (IBlockReader)worldIn, pos, blockStateIn, abovePos, aboveState)) {
            return this.getFlowingFluidState(8, true, currFluid, Math.max(correspondingTimer, (Integer)aboveFluid.func_177229_b((IProperty)IEProperties.INT_16)));
        }
        int newLevel = maxNeighborLevel - this.func_204528_b(worldIn);
        if (newLevel <= 0) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return this.getFlowingFluidState(newLevel, false, currFluid, correspondingTimer);
    }

    public IFluidState getFlowingFluidState(int level, boolean falling, IFluidState currentState, int baseDecay) {
        IFluidState baseState = super.func_207207_a(level, falling);
        if (this.func_207187_a(currentState.func_206886_c())) {
            baseDecay = Math.max((Integer)currentState.func_177229_b((IProperty)IEProperties.INT_16), baseDecay);
        }
        baseState = (IFluidState)baseState.func_206870_a((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(baseDecay));
        return baseState;
    }

    protected void func_205574_a(@Nonnull IWorld worldIn, @Nonnull BlockPos pos, BlockState blockStateIn, Direction direction, @Nonnull IFluidState fluidStateIn) {
        if (blockStateIn.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)blockStateIn.func_177230_c()).func_204509_a(worldIn, pos, blockStateIn, fluidStateIn);
        } else {
            if (!blockStateIn.func_196958_f()) {
                this.func_205580_a(worldIn, pos, blockStateIn);
            }
            worldIn.func_180501_a(pos, fluidStateIn.func_206883_i(), 3);
        }
        this.hasFlownInTick = true;
    }
}

