/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fluids;

import blusunrize.immersiveengineering.common.util.fluids.IEFluid;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class IEFluidBlock
extends FlowingFluidBlock {
    private final IEFluid ieFluid;
    @Nullable
    private Effect effect;
    private int duration;
    private int level;
    private static IEFluid tempFluid;

    private static Supplier<IEFluid> supply(IEFluid fluid) {
        tempFluid = fluid;
        return () -> fluid;
    }

    public IEFluidBlock(IEFluid ieFluid) {
        super(IEFluidBlock.supply(ieFluid), Block.Properties.func_200945_a((Material)Material.field_151586_h));
        this.ieFluid = ieFluid;
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        IEFluid f = this.ieFluid != null ? this.ieFluid : tempFluid;
        builder.func_206894_a(f.func_207182_e().func_177623_d().toArray(new IProperty[0]));
    }

    @Nonnull
    public IFluidState func_204507_t(@Nonnull BlockState state) {
        IFluidState baseState = super.func_204507_t(state);
        for (IProperty prop : this.ieFluid.func_207182_e().func_177623_d()) {
            if (prop == FlowingFluidBlock.field_176367_b) continue;
            baseState = this.withCopiedValue((IProperty)prop, (IStateHolder)baseState, (IStateHolder<?>)state);
        }
        return baseState;
    }

    private <T extends IStateHolder<T>, S extends Comparable<S>> T withCopiedValue(IProperty<S> prop, T oldState, IStateHolder<?> copyFrom) {
        return (T)((IStateHolder)oldState.func_206870_a(prop, copyFrom.func_177229_b(prop)));
    }

    public void setEffect(@Nonnull Effect effect, int duration, int level) {
        this.effect = effect;
        this.duration = duration;
        this.level = level;
    }

    public void func_196262_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (this.effect != null && entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(this.effect, this.duration, this.level));
        }
    }
}

