/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class DropInventoryLootEntry
extends StandaloneLootEntry {
    protected DropInventoryLootEntry(int weightIn, int qualityIn, ILootCondition[] conditionsIn, ILootFunction[] functionsIn) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
    }

    protected void func_216154_a(@Nonnull Consumer<ItemStack> output, LootContext context) {
        if (context.func_216033_a(LootParameters.field_216288_h)) {
            TileEntity te = (TileEntity)context.func_216031_c(LootParameters.field_216288_h);
            if (te instanceof IEBlockInterfaces.IGeneralMultiblock) {
                te = (TileEntity)((IEBlockInterfaces.IGeneralMultiblock)te).master();
            }
            if (te instanceof IIEInventory && ((IIEInventory)te).getDroppedItems() != null) {
                ((IIEInventory)te).getDroppedItems().forEach(output);
            } else if (te != null) {
                LazyOptional itemHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                itemHandler.ifPresent(h -> {
                    if (h instanceof IEInventoryHandler) {
                        for (int i = 0; i < h.getSlots(); ++i) {
                            if (h.getStackInSlot(i).func_190926_b()) continue;
                            output.accept(h.getStackInSlot(i));
                            ((IEInventoryHandler)h).setStackInSlot(i, ItemStack.field_190927_a);
                        }
                    }
                });
            }
        }
    }

    public static StandaloneLootEntry.Builder<?> builder() {
        return DropInventoryLootEntry.func_216156_a(DropInventoryLootEntry::new);
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<DropInventoryLootEntry> {
        public Serializer() {
            super(new ResourceLocation("immersiveengineering", "drop_inv"), DropInventoryLootEntry.class);
        }

        @Nonnull
        protected DropInventoryLootEntry func_212829_b_(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, int weight, int quality, @Nonnull ILootCondition[] conditions, @Nonnull ILootFunction[] functions) {
            return new DropInventoryLootEntry(weight, quality, conditions, functions);
        }
    }
}

