/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.wires;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.WireDamageHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.items.IEItems;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IEWireTypes {
    public static String[] uniqueNames = new String[]{"COPPER", "ELECTRUM", "STEEL", "STRUCTURE_ROPE", "STRUCTURE_STEEL", "REDSTONE", "COPPER_INS", "ELECTRUM_INS"};
    public static double[] renderDiameter = new double[]{0.03125, 0.03125, 0.0625, 0.0625, 0.0625, 0.03125};
    public static ShockingWire COPPER;
    public static ShockingWire ELECTRUM;
    public static ShockingWire STEEL;
    public static WireType STRUCTURE_ROPE;
    public static WireType STRUCTURE_STEEL;
    public static WireType REDSTONE;
    public static EnergyWire COPPER_INSULATED;
    public static EnergyWire ELECTRUM_INSULATED;
    public static InternalConnection INTERNAL_CONNECTION;

    public static void modConstruction() {
        COPPER = new ShockingWire(0);
        WireType.COPPER = COPPER;
        ELECTRUM = new ShockingWire(1);
        WireType.ELECTRUM = ELECTRUM;
        STEEL = new ShockingWire(2);
        WireType.STEEL = STEEL;
        WireType.STRUCTURE_ROPE = STRUCTURE_ROPE = new BasicWire(3);
        WireType.STRUCTURE_STEEL = STRUCTURE_STEEL = new BasicWire(4);
        WireType.REDSTONE = REDSTONE = new BasicWire(5);
        COPPER_INSULATED = new EnergyWire(6);
        WireType.COPPER_INSULATED = COPPER_INSULATED;
        ELECTRUM_INSULATED = new EnergyWire(7);
        WireType.ELECTRUM_INSULATED = ELECTRUM_INSULATED;
        INTERNAL_CONNECTION = new InternalConnection();
        WireType.INTERNAL_CONNECTION = INTERNAL_CONNECTION;
    }

    public static void setup() {
        WireApi.registerFeedthroughForWiretype(COPPER, new ResourceLocation("immersiveengineering", "block/connector/connector_lv"), new float[]{0.0f, 4.0f, 8.0f, 12.0f}, 0.5, () -> IEBlocks.Connectors.getEnergyConnector("LV", false).func_176223_P());
        WireApi.registerFeedthroughForWiretype(ELECTRUM, new ResourceLocation("immersiveengineering", "block/connector/connector_mv"), new float[]{0.0f, 4.0f, 8.0f, 12.0f}, 0.5625, () -> IEBlocks.Connectors.getEnergyConnector("MV", false).func_176223_P());
        WireApi.registerFeedthroughForWiretype(STEEL, new ResourceLocation("immersiveengineering", "block/connector/connector_hv"), new float[]{0.0f, 4.0f, 8.0f, 12.0f}, 0.75, () -> IEBlocks.Connectors.getEnergyConnector("HV", false).func_176223_P());
        WireApi.registerFeedthroughForWiretype(REDSTONE, new ResourceLocation("immersiveengineering", "block/connector/connector_redstone"), new float[]{3.0f, 8.0f, 11.0f, 16.0f}, 0.5625, 0.5, () -> IEBlocks.Connectors.connectorRedstone.func_176223_P());
    }

    private static class InternalConnection
    extends WireType {
        private InternalConnection() {
        }

        @Override
        public String getUniqueName() {
            return "INTERNAL";
        }

        @Override
        public int getColour(Connection connection) {
            return 0;
        }

        @Override
        public double getSlack() {
            return 0.0;
        }

        @Override
        public TextureAtlasSprite getIcon(Connection connection) {
            return null;
        }

        @Override
        public int getMaxLength() {
            return 0;
        }

        @Override
        public ItemStack getWireCoil(Connection con) {
            return ItemStack.field_190927_a;
        }

        @Override
        public double getRenderDiameter() {
            return 0.0;
        }

        @Override
        @Nonnull
        public String getCategory() {
            return "INTERNAL";
        }
    }

    private static class ShockingWire
    extends EnergyWire
    implements WireDamageHandler.IShockingWire {
        private final IElectricEquipment.ElectricSource eSource;

        public ShockingWire(int ordinal) {
            super(ordinal);
            this.eSource = this.getDamageRadius() > 0.0 ? new IElectricEquipment.ElectricSource(0.5f * (float)(1 + ordinal)) : new IElectricEquipment.ElectricSource(-1.0f);
        }

        @Override
        public double getDamageRadius() {
            switch (this.ordinal) {
                case 0: {
                    return 0.05;
                }
                case 1: {
                    return 0.1;
                }
                case 2: {
                    return 0.3;
                }
            }
            return 0.0;
        }

        @Override
        public IElectricEquipment.ElectricSource getElectricSource() {
            return this.eSource;
        }

        @Override
        public float getDamageAmount(Entity e, Connection c, int energy) {
            float factor;
            if (this == COPPER) {
                factor = 2.0f;
            } else if (this == ELECTRUM) {
                factor = 5.0f;
            } else if (this == STEEL) {
                factor = 15.0f;
            } else {
                throw new UnsupportedOperationException("");
            }
            return factor * (float)energy / (float)this.getTransferRate() * 8.0f;
        }

        @Override
        public Collection<ResourceLocation> getRequestedHandlers() {
            return ImmutableList.of((Object)WireDamageHandler.ID);
        }
    }

    private static class EnergyWire
    extends BasicWire
    implements EnergyTransferHandler.IEnergyWire {
        public EnergyWire(int ordinal) {
            super(ordinal);
        }

        public double getLossRatio() {
            return Math.abs(IEConfig.CACHED.wireLossRatio[this.ordinal % 6]);
        }

        @Override
        public int getTransferRate() {
            return Math.abs(IEConfig.CACHED.wireTransferRate[this.ordinal % 6]);
        }

        @Override
        public double getBasicLossRate(Connection c) {
            double length = Math.sqrt(c.getEndA().getPosition().func_218138_a((IPosition)new Vec3d((Vec3i)c.getEndB().getPosition()), false));
            return this.getLossRatio() * length / (double)this.getMaxLength();
        }

        @Override
        public double getLossRate(Connection c, int transferred) {
            return 0.0;
        }
    }

    private static class BasicWire
    extends WireType {
        final int ordinal;

        public BasicWire(int ordinal) {
            this.ordinal = ordinal;
            WireApi.registerWireType(this);
        }

        @Override
        public int getColour(Connection connection) {
            return (Integer)((List)IEConfig.WIRES.wireColouration.get()).get(this.ordinal);
        }

        @Override
        public double getSlack() {
            return 1.005;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public TextureAtlasSprite getIcon(Connection connection) {
            return iconDefaultWire;
        }

        @Override
        public int getMaxLength() {
            return (Integer)((List)IEConfig.WIRES.wireLength.get()).get(this.ordinal % 6);
        }

        @Override
        public ItemStack getWireCoil(Connection con) {
            return new ItemStack((IItemProvider)IEItems.Misc.wireCoils.get(this), 1);
        }

        @Override
        public String getUniqueName() {
            return uniqueNames[this.ordinal];
        }

        @Override
        public double getRenderDiameter() {
            return renderDiameter[this.ordinal % 6];
        }

        @Override
        @Nonnull
        public String getCategory() {
            switch (this.ordinal) {
                case 0: 
                case 6: {
                    return "LV";
                }
                case 1: 
                case 7: {
                    return "MV";
                }
                case 2: {
                    return "HV";
                }
                case 3: 
                case 4: {
                    return "STRUCTURE";
                }
                case 5: {
                    return "REDSTONE";
                }
            }
            throw new IllegalStateException("Ordinal " + this.ordinal + " is not valid");
        }

        @Override
        public Collection<ResourceLocation> getRequestedHandlers() {
            return ImmutableList.of();
        }
    }
}

